"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClientAttributes = void 0;
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const semantic_conventions_1 = require("@opentelemetry/semantic-conventions");
function getClientAttributes(options) {
    var _a, _b;
    return {
        [semantic_conventions_1.SemanticAttributes.DB_SYSTEM]: semantic_conventions_1.DbSystemValues.REDIS,
        [semantic_conventions_1.SemanticAttributes.NET_PEER_NAME]: (_a = options === null || options === void 0 ? void 0 : options.socket) === null || _a === void 0 ? void 0 : _a.host,
        [semantic_conventions_1.SemanticAttributes.NET_PEER_PORT]: (_b = options === null || options === void 0 ? void 0 : options.socket) === null || _b === void 0 ? void 0 : _b.port,
        [semantic_conventions_1.SemanticAttributes.DB_CONNECTION_STRING]: options === null || options === void 0 ? void 0 : options.url,
    };
}
exports.getClientAttributes = getClientAttributes;
//# sourceMappingURL=utils.js.map