(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsGu = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"અ":[{},[0,1]],"આ":[{},[0,1]],"ઇ":[{},[0,1]],"ઈ":[{},[0,1]],"ઉ":[{},[0,1]],"ઊ":[{},[0,1]],"ઋ":[{},[0,1]],"ૠ":[{},[0,1]],"એ":[{},[0,1]],"ઐ":[{},[0,1]],"ઓ":[{},[0,1]],"ઔ":[{},[0,1]],"ા":[{},[0,1]],"િ":[{},[0,1]],"ી":[{},[0,1]],"ુ":[{},[0,1]],"ૂ":[{},[0,1]],"ૃ":[{},[0,1]],"ૄ":[{},[0,1]],"ૢ":[{},[0,1]],"ૣ":[{},[0,1]],"ે":[{},[0,1]],"ૈ":[{},[0,1]],"ો":[{},[0,1]],"ૌ":[{},[0,1]],"ક":[{},[1]],"ખ":[{},[1]],"ગ":[{},[1]],"ઘ":[{},[1]],"ઙ":[{},[1]],"ચ":[{},[1]],"છ":[{},[1]],"જ":[{},[1]],"ઝ":[{},[1]],"ઞ":[{},[1]],"ટ":[{},[1]],"ઠ":[{},[1]],"ડ":[{},[1]],"ઢ":[{},[1]],"ણ":[{},[1]],"ત":[{},[1]],"થ":[{},[1]],"દ":[{},[1]],"ધ":[{},[1]],"ન":[{},[1]],"પ":[{},[1]],"ફ":[{},[1]],"બ":[{},[1]],"ભ":[{},[1]],"મ":[{},[1]],"ય":[{},[1]],"ર":[{},[1]],"લ":[{},[1]],"ળ":[{},[1]],"વ":[{},[1]],"શ":[{},[1]],"ષ":[{},[1]],"સ":[{},[1]],"હ":[{},[1]],"ઁ":[{},[2,1]],"ઃ":[{},[2,1]],"ઽ":[{},[2,1]],"્":[{},[2,2]],"ં":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
