(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsKmr = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"k":[{"a":[{"r":[{"a":[{},[0,0,6]]}]}]}]}],"a":[{"l":[{"a":[{},[0,0,4]]}],"m":[{"î":[{"t":[{".":[{},[6]]}]}]}],"n":[{},[4]],"r":[{"a":[{"n":[{"î":[{},[0,0,5,6]]}]}]}],"v":[{"a":[{"y":[{},[4]]}]},[3]],"y":[{},[2]]},[0,1]],"b":[{"a":[{},[0,4]],"b":[{},[2]],"l":[{},[2]],"r":[{},[2]],"s":[{},[2]],"x":[{},[2]]},[1]],"c":[{"b":[{},[2]],"k":[{},[2,2]],"l":[{},[2]]},[1]],"ç":[{"k":[{},[2]]},[1]],"d":[{"a":[{"v":[{"ê":[{"j":[{"i":[{},[0,0,6]]}]}]}]}],"b":[{"û":[{"n":[{"a":[{},[0,0,0,6]]}]}]},[2]],"d":[{"a":[{},[0,0,0,4]]},[2]],"g":[{},[2]],"r":[{},[2]],"t":[{},[2]],"y":[{"o":[{},[0,4]],"û":[{},[4]]}]},[1]],"e":[{"a":[{},[0,0,2]],"d":[{"y":[{},[0,4]]}],"e":[{},[0,0,2]],"ê":[{},[0,0,2]],"f":[{"r":[{},[0,4]]}],"l":[{"a":[{},[0,0,4]]}],"r":[{"d":[{"e":[{"s":[{"t":[{"a":[{},[0,0,6]]}]},[0,0,0,0,0,6]]}]}]}],"t":[{"r":[{},[0,4]]}],"z":[{},[2]]},[0,1]],"ê":[{"a":[{},[0,2]],"l":[{"a":[{"v":[{},[0,0,0,4]]}]}]},[0,1]],"f":[{"l":[{"î":[{},[0,4]],"û":[{},[4]]},[0,0,4]],"r":[{"o":[{},[0,4]]}],"s":[{},[2]],"ş":[{},[2]],"t":[{},[2]],"x":[{},[2]]},[1]],"g":[{"b":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{},[0,2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]]},[1]],"h":[{"b":[{},[2]],"d":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]]},[1]],"i":[{"i":[{},[0,0,2]],"l":[{"a":[{},[0,0,4]]}],"n":[{"ê":[{"r":[{},[0,4]]}]}],"r":[{"e":[{"h":[{},[0,0,0,4]]}]}],"s":[{},[0,2]]},[0,1]],"î":[{"a":[{},[0,2]],"d":[{},[2]],"e":[{"t":[{},[0,0,4]]}],"j":[{},[0,2]],"l":[{},[0,0,3]],"p":[{"l":[{},[0,4]]}],"s":[{"t":[{"i":[{"y":[{"e":[{},[0,0,0,0,6]]}]}]}]}]},[0,1]],"j":[{"a":[{"v":[{"a":[{".":[{},[6,0,6]]}]}]}],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"t":[{},[2]]},[1]],"k":[{"b":[{},[2]],"ç":[{},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"w":[{},[2]],"x":[{},[2]],"y":[{},[2]]},[1]],"l":[{"a":[{"m":[{"î":[{"t":[{"ê":[{},[6]]}]}]}]}],"b":[{},[2]],"c":[{},[2]],"ç":[{},[2]],"d":[{},[2]],"e":[{},[0,4]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"w":[{},[2]],"x":[{},[2]],"y":[{},[2]],"z":[{},[2]]},[1]],"m":[{"a":[{"î":[{},[0,0,4]]}],"b":[{},[2]],"d":[{},[2]],"f":[{},[2]],"î":[{"t":[{"ê":[{},[4]]}]}],"m":[{},[2]],"p":[{},[2,0,2]],"r":[{},[2]],"s":[{},[2]],"w":[{},[2]],"y":[{},[2]],"z":[{},[2]]},[1]],"n":[{"a":[{},[0,4]],"b":[{},[2]],"c":[{},[2]],"ç":[{},[2]],"d":[{},[2]],"ê":[{"r":[{"e":[{},[0,0,4]]}]}],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{"i":[{},[0,0,0,4]]},[2]],"n":[{},[2]],"p":[{},[2]],"s":[{},[2]],"ş":[{},[2]],"t":[{},[2]],"v":[{},[2]],"x":[{},[2]],"y":[{},[2]],"z":[{},[2,2]]},[1]],"o":[{"f":[{},[0,0,2]],"h":[{},[0,2]],"s":[{},[0,2]],"w":[{},[0,2]]},[2]],"p":[{"s":[{},[2]],"t":[{},[2]]},[1]],"q":[{"p":[{},[2]],"ş":[{},[2]]},[1]],"r":[{"a":[{"î":[{},[0,0,0,4]]},[0,4]],"b":[{},[2]],"c":[{},[2]],"ç":[{},[2]],"d":[{},[2]],"f":[{"i":[{},[0,4,0,4]]},[2]],"g":[{},[2]],"h":[{},[2]],"j":[{},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"w":[{},[2]],"x":[{},[2]],"y":[{},[2]],"z":[{},[2]]},[1]],"s":[{"a":[{},[3]],"b":[{},[2]],"e":[{},[3]],"g":[{},[2]],"î":[{},[3]],"k":[{},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{"a":[{"v":[{},[0,0,0,4]]}],"r":[{},[0,0,4]]},[2]],"u":[{},[3]],"û":[{},[3]],"y":[{},[2]]},[1]],"ş":[{"a":[{"v":[{},[4,0,4]]}],"b":[{},[2]],"d":[{},[2]],"ê":[{"l":[{},[0,0,4]]}],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"t":[{},[2,0,2]],"v":[{},[2]],"x":[{},[2]]},[1]],"t":[{"a":[{"v":[{},[4]]}],"g":[{"e":[{},[0,0,0,4]]},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{"î":[{},[0,0,0,4]]},[2]],"p":[{},[2]],"r":[{"a":[{},[0,4]],"û":[{},[0,4]]}],"s":[{},[2,3,2]],"t":[{},[2]],"x":[{},[2]],"y":[{},[2]]},[1]],"u":[{"e":[{},[0,0,2]],"i":[{},[0,2]],"k":[{},[0,2]],"r":[{"a":[{"n":[{"d":[{"i":[{},[0,0,0,0,0,0,6]]}]}]}]}],"ş":[{},[0,2]]},[0,1]],"v":[{"b":[{},[2]],"ç":[{},[2]],"d":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"ş":[{},[2]],"y":[{},[2]]},[1]],"w":[{"c":[{},[2]],"d":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"ş":[{},[2]],"t":[{},[2]]},[1]],"x":[{"a":[{},[0,4]],"ç":[{},[2]],"l":[{},[2]],"n":[{},[2]],"t":[{"r":[{},[0,4]]},[2]],"w":[{},[0,2]]},[1]],"y":[{"b":[{},[2]],"d":[{"a":[{},[0,0,0,4]]},[2]],"l":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"w":[{},[2]]},[1]],"z":[{"b":[{},[2]],"d":[{},[2]],"e":[{"z":[{},[0,3,4]]}],"k":[{},[2]],"m":[{},[2]],"r":[{},[2]],"t":[{},[2]],"y":[{},[2]],"z":[{},[2]]},[1]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
