"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "assetRoutes", {
    enumerable: true,
    get: function() {
        return assetRoutes;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _importable = require("@tamanu/constants/importable");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const assetRoutes = _express.default.Router();
const assetSchema = _yup.object().shape({
    name: _yup.string().oneOf(Object.values(_importable.ASSET_NAMES)).required(),
    type: _yup.string().oneOf(Object.values(_importable.ASSET_MIME_TYPES)).required(),
    data: _yup.string().required()
});
assetRoutes.put('/:name', (0, _expressasynchandler.default)(async (req, res)=>{
    // Flagging permission check in case the request fails validation
    // Then we have further permission check for assets afterwards.
    req.flagPermissionChecked();
    const { params, body } = req;
    const { name } = params;
    const ext = (body.filename || '').split('.').slice(-1);
    const type = _importable.ASSET_MIME_TYPES[ext] || 'unknown';
    const data = Buffer.from(body.data, 'base64');
    const record = {
        name,
        data,
        type
    };
    await assetSchema.validate(record);
    const { Asset } = req.store.models;
    const existing = await Asset.findOne({
        where: {
            name
        }
    });
    if (existing) {
        req.checkPermission('write', existing);
        await existing.update(record);
        res.send({
            action: 'updated',
            id: existing.id,
            name,
            type
        });
        return;
    }
    req.checkPermission('create', 'Asset');
    const created = await Asset.create(record);
    res.send({
        action: 'created',
        id: created.id,
        name,
        type
    });
}));

//# sourceMappingURL=asset.js.map