"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "migrateCommand", {
    enumerable: true,
    get: function() {
        return migrateCommand;
    }
});
const _commander = require("commander");
const _migrations = require("@tamanu/shared/services/migrations");
const _database = require("../database");
async function migrate(direction) {
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    await store.sequelize.migrate(direction);
    process.exit(0);
}
const migrateCommand = (0, _migrations.createMigrateCommand)(_commander.Command, migrate);

//# sourceMappingURL=migrate.js.map