"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('imaging_results', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        updated_at_sync_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false,
            defaultValue: 0
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        },
        imaging_request_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'imaging_requests',
                key: 'id'
            }
        },
        completed_by_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        description: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        external_code: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        }
    });
    await query.renameColumn('imaging_requests', 'results', 'legacy_results');
    if (!_config.default.serverFacilityId) {
        // only insert imaging_results on the central server
        // facility servers can sync new results down
        await query.sequelize.query(`
      INSERT INTO imaging_results (id, created_at, updated_at, imaging_request_id, description)
      SELECT uuid_generate_v4(), ir.updated_at, ir.updated_at, ir.id, ir.legacy_results FROM imaging_requests ir
      WHERE ir.legacy_results IS NOT NULL AND ir.legacy_results != '';
  `);
    }
}
async function down(query) {
    await query.renameColumn('imaging_requests', 'legacy_results', 'results');
    await query.dropTable('imaging_results');
}

//# sourceMappingURL=1669589923823-createImagingResultsTable.js.map