"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDataRelation", {
    enumerable: true,
    get: function() {
        return ReferenceDataRelation;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ReferenceDataRelation = class ReferenceDataRelation extends _Model.Model {
    static init(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
            },
            referenceDataId: {
                type: _sequelize.DataTypes.TEXT,
                references: {
                    model: 'reference_data',
                    key: 'id'
                }
            },
            referenceDataParentId: {
                type: _sequelize.DataTypes.TEXT,
                references: {
                    model: 'reference_data',
                    key: 'id'
                }
            },
            type: {
                type: _sequelize.DataTypes.ENUM(Object.values(_constants.REFERENCE_DATA_RELATION_TYPES)),
                defaultValue: _constants.REFERENCE_DATA_RELATION_TYPES.ADDRESS_HIERARCHY
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ReferenceDataRelation.js.map