"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildAbility: function() {
        return buildAbility;
    },
    buildAbilityForTests: function() {
        return buildAbilityForTests;
    },
    buildAbilityForUser: function() {
        return buildAbilityForUser;
    },
    buildAdminAbility: function() {
        return buildAdminAbility;
    }
});
const _ability = require("@casl/ability");
function buildAbility(permissions, options = {}) {
    const { can, build } = new _ability.AbilityBuilder(_ability.Ability);
    permissions.forEach((a)=>{
        if (a.objectId) {
            can(a.verb, a.noun, {
                id: a.objectId
            });
        } else {
            can(a.verb, a.noun);
        }
    });
    return build(options);
}
function buildAdminAbility() {
    return buildAbility([
        // these values are specially understood by CASL to grant
        // wildcard permission for all actions
        {
            verb: 'manage',
            noun: 'all'
        }
    ]);
}
function buildAbilityForUser(user, permissions) {
    if (user.role === 'admin') {
        return buildAdminAbility();
    }
    return buildAbility([
        ...permissions,
        // a user can always read themselves -- this is
        // separate to the role system as it's cached per-role, not per-user
        {
            verb: 'read',
            noun: 'User',
            objectId: user.id
        },
        {
            verb: 'write',
            noun: 'User',
            objectId: user.id
        }
    ]);
}
function buildAbilityForTests(permissions) {
    return buildAbility(permissions, {
        detectSubjectType: (obj)=>{
            if (typeof obj === 'string') {
                return obj;
            }
            return (obj || {}).type;
        }
    });
}

//# sourceMappingURL=buildAbility.js.map