"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildAdministeredVaccine: function() {
        return buildAdministeredVaccine;
    },
    buildEncounter: function() {
        return buildEncounter;
    },
    buildNestedEncounter: function() {
        return buildNestedEncounter;
    },
    buildScheduledVaccine: function() {
        return buildScheduledVaccine;
    },
    buildSurveyResponse: function() {
        return buildSurveyResponse;
    },
    buildSurveyResponseAnswer: function() {
        return buildSurveyResponseAnswer;
    },
    findOneOrCreate: function() {
        return findOneOrCreate;
    },
    upsertAssociations: function() {
        return upsertAssociations;
    }
});
const _constants = require("@tamanu/constants");
const _generateId = require("../utils/generateId");
const _fake = require("./fake");
const buildEncounter = async (models, patientId, optionalEncounterId)=>{
    const { Patient, User } = models;
    const patient = (0, _fake.fake)(Patient);
    if (patientId) {
        patient.id = patientId;
    }
    await Patient.upsert(patient);
    const examiner = (0, _fake.fakeUser)('examiner');
    await User.upsert(examiner);
    const encounter = (0, _fake.fakeEncounter)();
    if (optionalEncounterId !== undefined) {
        encounter.id = optionalEncounterId;
    }
    encounter.patientId = patient.id;
    encounter.examinerId = examiner.id;
    encounter.patientBillingTypeId = null;
    encounter.referralSourceId = null;
    encounter.locationId = await findOrCreateId(models, models.Location);
    encounter.departmentId = await findOrCreateId(models, models.Department);
    encounter.plannedLocationId = null;
    encounter.plannedLocationStartTime = null;
    return encounter;
};
const buildNestedEncounter = async (models, patientId, optionalEncounterId)=>{
    const encounter = await buildEncounter(models, patientId, optionalEncounterId);
    const scheduledVaccine = await (0, _fake.fakeScheduledVaccine)();
    await models.ScheduledVaccine.upsert(scheduledVaccine);
    const administeredVaccine = (0, _fake.fakeAdministeredVaccine)('test-', scheduledVaccine.id);
    administeredVaccine.encounterId = encounter.id;
    encounter.administeredVaccines = [
        administeredVaccine
    ];
    const survey = (0, _fake.fakeSurvey)();
    await models.Survey.upsert(survey);
    const surveyResponse = (0, _fake.fakeSurveyResponse)();
    surveyResponse.encounterId = encounter.id;
    surveyResponse.surveyId = survey.id;
    encounter.surveyResponses = [
        surveyResponse
    ];
    const programDataElement = (0, _fake.fakeProgramDataElement)();
    await models.ProgramDataElement.upsert(programDataElement);
    const surveyResponseAnswer = (0, _fake.fakeSurveyResponseAnswer)();
    surveyResponseAnswer.responseId = surveyResponse.id;
    surveyResponseAnswer.dataElementId = programDataElement.id;
    surveyResponse.answers = [
        surveyResponseAnswer
    ];
    const diagnosis = (0, _fake.fakeReferenceData)();
    await models.ReferenceData.create(diagnosis);
    const encounterDiagnosis = (0, _fake.fakeEncounterDiagnosis)();
    encounterDiagnosis.encounterId = encounter.id;
    encounterDiagnosis.diagnosisId = diagnosis.id;
    encounter.diagnoses = [
        encounterDiagnosis
    ];
    const medication = (0, _fake.fakeReferenceData)();
    await models.ReferenceData.create(medication);
    const encounterMedication = (0, _fake.fakeEncounterMedication)();
    encounterMedication.encounterId = encounter.id;
    encounterMedication.medicationId = medication.id;
    encounterMedication.prescriberId = encounter.examinerId;
    encounter.medications = [
        encounterMedication
    ];
    const labRequest = (0, _fake.fake)(models.LabRequest);
    labRequest.encounterId = encounter.id;
    encounter.labRequests = [
        labRequest
    ];
    const labTest = (0, _fake.fake)(models.LabTest);
    labTest.labRequestId = labRequest.id;
    labRequest.tests = [
        labTest
    ];
    const imagingRequest = {
        ...(0, _fake.fake)(models.ImagingRequest),
        status: _constants.IMAGING_REQUEST_STATUS_TYPES.COMPLETED,
        requestedById: encounter.examinerId
    };
    imagingRequest.encounterId = encounter.id;
    encounter.imagingRequests = [
        imagingRequest
    ];
    return encounter;
};
const buildAdministeredVaccine = async (models, patientId)=>{
    const encounter = await buildEncounter(models, patientId);
    await models.Encounter.upsert(encounter);
    const administeredVaccine = (0, _fake.fakeAdministeredVaccine)();
    administeredVaccine.encounterId = encounter.id;
    return administeredVaccine;
};
const buildSurveyResponse = async (models, patientId)=>{
    const encounter = await buildEncounter(models, patientId);
    await models.Encounter.upsert(encounter);
    const surveyResponse = (0, _fake.fakeSurveyResponse)();
    surveyResponse.encounterId = encounter.id;
    return surveyResponse;
};
const buildSurveyResponseAnswer = async (models, patientId)=>{
    const surveyResponse = await buildSurveyResponse(models, patientId);
    await models.SurveyResponse.upsert(surveyResponse);
    const surveyResponseAnswer = (0, _fake.fakeSurveyResponseAnswer)();
    surveyResponseAnswer.responseId = surveyResponse.id;
    return surveyResponseAnswer;
};
const buildScheduledVaccine = async (models)=>{
    const scheduledVaccine = (0, _fake.fakeScheduledVaccine)();
    const vaccineId = (0, _generateId.fakeUUID)();
    const vaccine = {
        id: vaccineId,
        type: _constants.REFERENCE_TYPES.VACCINE,
        ...(0, _fake.fakeStringFields)(`vaccine_${vaccineId}_`, [
            'code',
            'name'
        ])
    };
    await models.ReferenceData.upsert(vaccine);
    scheduledVaccine.vaccineId = vaccineId;
    return scheduledVaccine;
};
const upsertAssociations = async (model, record)=>{
    for (const [name, association] of Object.entries(model.associations)){
        const associatedRecords = record[name];
        if (associatedRecords) {
            for (const associatedRecord of associatedRecords){
                await association.target.upsert({
                    ...associatedRecord,
                    [association.foreignKey]: record.id
                });
                await upsertAssociations(association.target, associatedRecord);
            }
        }
    }
};
const addAssociations = async (models, model, record)=>{
    const newRecord = {
        ...record
    };
    for (const association of Object.values(model.associations)){
        const { associationType, foreignKey, target } = association;
        if (associationType === 'BelongsTo') {
            if (!newRecord[foreignKey]) {
                newRecord[foreignKey] = await findOrCreateId(models, target);
            }
        }
    }
    return newRecord;
};
const findOneOrCreate = async (models, model, where, insertOverrides)=>{
    const existingRecord = await model.findOne({
        where
    });
    if (existingRecord) {
        return existingRecord;
    }
    const overrides = {
        ...where,
        ...insertOverrides
    };
    const values = await addAssociations(models, model, (0, _fake.fake)(model, overrides));
    return model.create(values);
};
const findOrCreateId = async (models, model)=>(await findOneOrCreate(models, model)).id;

//# sourceMappingURL=factory.js.map