"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fetchWithTimeout", {
    enumerable: true,
    get: function() {
        return fetchWithTimeout;
    }
});
const _nodefetch = /*#__PURE__*/ _interop_require_default(require("node-fetch"));
const _abortcontroller = /*#__PURE__*/ _interop_require_default(require("abort-controller"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const fetchWithTimeout = async (url, { timeout, ...params } = {}, fetchImpl = _nodefetch.default)=>{
    let controller;
    let response;
    let timeoutHandle;
    if (Number.isFinite(timeout)) {
        controller = new _abortcontroller.default();
        timeoutHandle = setTimeout(()=>{
            controller.abort();
        }, timeout);
    }
    try {
        response = await fetchImpl(url, {
            ...params,
            signal: controller?.signal
        });
    } finally{
        clearTimeout(timeoutHandle); // succeeds even with an undefined handle
    }
    return response;
};

//# sourceMappingURL=fetchWithTimeout.js.map