"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LetterheadSection", {
    enumerable: true,
    get: function() {
        return LetterheadSection;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _Layout = require("./Layout");
const _Typography = require("./Typography");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const LetterheadSection = ({ getLocalisation, logoSrc, certificateTitle, letterheadConfig })=>{
    // Give priority to letterheadConfig which is extracted from settings
    const title = letterheadConfig?.title ?? getLocalisation('templates.letterhead.title');
    const subTitle = letterheadConfig?.subTitle ?? getLocalisation('templates.letterhead.subTitle');
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, logoSrc && /*#__PURE__*/ _react.default.createElement(_Layout.CertificateLogo, {
        logoSrc: logoSrc
    }), /*#__PURE__*/ _react.default.createElement(_Typography.CertificateAddress, null, `${title}\n${subTitle}`), /*#__PURE__*/ _react.default.createElement(_Typography.CertificateTitle, null, certificateTitle));
};

//# sourceMappingURL=LetterheadSection.js.map