import { DataSection } from './DataSection';
import { Col } from '../Layout';
import { DataItem } from './DataItem';
import React from 'react';
import { formatShort } from '../../dateTime';
export const EncounterDetailsExtended = ({ encounter, discharge, clinicianText })=>{
    const { location, examiner, department, startDate, endDate, reasonForEncounter } = encounter;
    return /*#__PURE__*/ React.createElement(DataSection, {
        title: "Encounter details",
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Facility",
        value: location.facility.name,
        key: "facility"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: `Supervising ${clinicianText.toLowerCase()}`,
        value: examiner.displayName,
        key: "supervisingClinician"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: `Discharging ${clinicianText.toLowerCase()}`,
        value: discharge?.discharger?.displayName,
        key: "dischargingClinician"
    }), discharge?.disposition?.name && /*#__PURE__*/ React.createElement(DataItem, {
        label: "Discharge disposition",
        value: discharge?.disposition?.name,
        key: "dischargeDisposition"
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Department",
        value: department.name,
        key: "department"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Date of admission",
        value: formatShort(startDate),
        key: "dateOfAdmission"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Date of discharge",
        value: formatShort(endDate),
        key: "dateOfDischarge"
    })), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Reason for encounter",
        value: reasonForEncounter,
        key: "reasonForEncounter"
    }));
};

//# sourceMappingURL=EncounterDetailsExtended.js.map