(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsId = factory();
  }
})(this, function () {
  var patterns =
    '{"a":[{"i":[{"r":[{},[0,2]]}],"n":[{".":[{},[3]]}]},[0,1]],"e":[{},[0,1]],"i":[{"o":[{"n":[{},[0,2,1]]}]},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"b":[{"d":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"a":[{"g":[{"a":[{"i":[{},[1,0,1,0,2]]}]}],"n":[{".":[{},[2,1]]}]}]}],"c":[{"k":[{},[2,1]],"n":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"d":[{"k":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"f":[{"d":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"t":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"g":[{"g":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"h":[{"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"w":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"j":[{"k":[{},[2,1]],"n":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"k":[{"b":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"l":[{"b":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"q":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"m":[{"b":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"n":[{"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"s":[{"t":[{},[2,3,2]]},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"g":[{"g":[{},[2,0,1]],"h":[{},[2,0,1]],"k":[{},[2,0,1]],"n":[{},[2,0,1]],"s":[{},[2,0,1]],".":[{},[2]],"a":[{"n":[{".":[{},[2,0,1]]}]}]}],"y":[{".":[{},[2]]}],"a":[{"n":[{".":[{},[2,1]]}]}]}],"p":[{"k":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"t":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"r":[{"b":[{},[2,1]],"c":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"w":[{},[2,1]],"y":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"s":[{"b":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"w":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"t":[{"k":[{},[2,1]],"l":[{},[2,1]],"n":[{},[2,1]],"t":[{},[2,1]],"a":[{"n":[{".":[{},[2,1]]}]}]}],"w":[{"t":[{},[2,1]]}],".":[{"b":[{"e":[{"r":[{},[0,0,2,3]]}]}],"t":[{"e":[{"r":[{},[0,0,2,3]]}],"a":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"m":[{"e":[{"n":[{"g":[{},[0,0,2,0,3]]}]}],"a":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"p":[{"e":[{"r":[{},[0,0,2,3]]}],"a":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"a":[{"t":[{"a":[{"u":[{},[0,2,0,2]]}]}]}],"l":[{"e":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"j":[{"a":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"r":[{"i":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}],"d":[{"e":[{"n":[{"g":[{"a":[{"n":[{".":[{},[0,0,3,0,4]]}]}]}]}]}]}]}],"v":[{"a":[{"n":[{".":[{},[2,1]]}]}]}],"z":[{"a":[{"n":[{".":[{},[2,1]]}]}]}]}';
  var hyphenation = [
    "be-ra-be be-ra-hi be-rak be-ran-da be-ran-dal be-rang",
    "be-ra-ngas-an",
    "be-rang-sang",
    "be-ra-ngus",
    "be-ra-ni",
    "be-ran-tak-an",
    "be-ran-tam",
    "be-ran-tas",
    "be-ra-pa",
    "be-ras",
    "be-ren-deng",
    "be-re-ngut",
    "be-re-rot",
    "be-res",
    "be-re-wok",
    "be-ri",
    "be-ri-ngas",
    "be-ri-sik",
    "be-ri-ta",
    "be-rok",
    "be-ron-dong",
    "be-ron-tak",
    "be-ru-du",
    "be-ruk",
    "be-run-tun",
    "peng-eks-por",
    "peng-im-por",
    "te-ra",
    "te-rang",
    "te-ras",
    "te-ra-si",
    "te-ra-tai",
    "te-ra-wang",
    "te-ra-weh",
    "te-ri-ak",
    "te-ri-gu",
    "te-rik",
    "te-ri-ma",
    "te-ri-pang",
    "te-ro-bos",
    "te-ro-bos-an",
    "te-ro-mol",
    "te-rom-pah",
    "te-rom-pet",
    "te-ro-pong",
    "             te-ro-wong-an te-ru-buk te-ru-na te-rus te-ru-si"
  ];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
