(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsKn = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"ಅ":[{},[0,1]],"ಆ":[{},[0,1]],"ಇ":[{},[0,1]],"ಈ":[{},[0,1]],"ಉ":[{},[0,1]],"ಊ":[{},[0,1]],"ಋ":[{},[0,1]],"ೠ":[{},[0,1]],"ಌ":[{},[0,1]],"ೡ":[{},[0,1]],"ಎ":[{},[0,1]],"ಏ":[{},[0,1]],"ಐ":[{},[0,1]],"ಒ":[{},[0,1]],"ಓ":[{},[0,1]],"ಔ":[{},[0,1]],"ಾ":[{},[0,1]],"ಿ":[{},[0,1]],"ೀ":[{},[0,1]],"ು":[{},[0,1]],"ೂ":[{},[0,1]],"ೃ":[{},[0,1]],"ೄ":[{},[0,1]],"ೆ":[{},[0,1]],"ೇ":[{},[0,1]],"ೈ":[{},[0,1]],"ೊ":[{},[0,1]],"ೋ":[{},[0,1]],"ೌ":[{},[0,1]],"ಕ":[{},[1]],"ಖ":[{},[1]],"ಗ":[{},[1]],"ಘ":[{},[1]],"ಙ":[{},[1]],"ಚ":[{},[1]],"ಛ":[{},[1]],"ಜ":[{},[1]],"ಝ":[{},[1]],"ಞ":[{},[1]],"ಟ":[{},[1]],"ಠ":[{},[1]],"ಡ":[{},[1]],"ಢ":[{},[1]],"ಣ":[{},[1]],"ತ":[{},[1]],"ಥ":[{},[1]],"ದ":[{},[1]],"ಧ":[{},[1]],"ನ":[{},[1]],"ಪ":[{},[1]],"ಫ":[{},[1]],"ಬ":[{},[1]],"ಭ":[{},[1]],"ಮ":[{},[1]],"ಯ":[{},[1]],"ರ":[{},[1]],"ಱ":[{},[1]],"ಲ":[{},[1]],"ಳ":[{},[1]],"ೞ":[{},[1]],"ವ":[{},[1]],"ಶ":[{},[1]],"ಷ":[{},[1]],"ಸ":[{},[1]],"ಹ":[{},[1]],"ಂ":[{},[2,1]],"ಃ":[{},[2,1]],"ಽ":[{},[2,1]],"ೕ":[{},[2,1]],"ೖ":[{},[2,1]],"್":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
