(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsPa = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"ਅ":[{},[0,1]],"ਆ":[{},[0,1]],"ਇ":[{},[0,1]],"ਈ":[{},[0,1]],"ਉ":[{},[0,1]],"ਊ":[{},[0,1]],"ਏ":[{},[0,1]],"ਐ":[{},[0,1]],"ਓ":[{},[0,1]],"ਔ":[{},[0,1]],"ਾ":[{},[0,1]],"ਿ":[{},[0,1]],"ੀ":[{},[0,1]],"ੁ":[{},[0,1]],"ੂ":[{},[0,1]],"ੇ":[{},[0,1]],"ੈ":[{},[0,1]],"ੋ":[{},[0,1]],"ੌ":[{},[0,1]],"ਕ":[{},[1]],"ਖ":[{},[1]],"ਗ":[{},[1]],"ਘ":[{},[1]],"ਙ":[{},[1]],"ਚ":[{},[1]],"ਛ":[{},[1]],"ਜ":[{},[1]],"ਝ":[{},[1]],"ਞ":[{},[1]],"ਟ":[{},[1]],"ਠ":[{},[1]],"ਡ":[{},[1]],"ਢ":[{},[1]],"ਣ":[{},[1]],"ਤ":[{},[1]],"ਥ":[{},[1]],"ਦ":[{},[1]],"ਧ":[{},[1]],"ਨ":[{},[1]],"ਪ":[{},[1]],"ਫ":[{},[1]],"ਬ":[{},[1]],"ਭ":[{},[1]],"ਮ":[{},[1]],"ਯ":[{},[1]],"ਰ":[{},[1]],"ਲ":[{},[1]],"ਲ਼":[{},[1]],"ਵ":[{},[1]],"ਸ਼":[{},[1]],"ਸ":[{},[1]],"ਹ":[{},[1]],"ਁ":[{},[2,1]],"ਂ":[{},[2,1]],"ਃ":[{},[2,1]],"੍":[{},[2,2]],"ੰ":[{},[2,2]],"ੱ":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
