(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsPt = factory();
  }
})(this, function () {
  var patterns =
    '{"b":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"c":[{"h":[{},[1,2]],"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]],"c":[{},[0,3]]}],"ç":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"d":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"f":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"g":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{"a":[{},[1,0,4]],"e":[{},[1,0,4]],"i":[{},[1,0,4]],"o":[{},[1,0,4]]},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"j":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"k":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"l":[{"h":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"m":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"n":[{"h":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"p":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"q":[{"u":[{"a":[{},[1,0,4]],"e":[{},[1,0,4]],"i":[{},[1,0,4]],"o":[{},[1,0,4]]}]}],"r":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]],"r":[{},[0,3]]}],"s":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]],"s":[{},[0,3]]}],"t":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"v":[{"l":[{},[1,2]],"r":[{},[1,2]],"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"w":[{"l":[{},[1,2]],"r":[{},[1,2]]}],"x":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"z":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"á":[{},[1]],"â":[{},[1]],"ã":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"ê":[{},[1]],"õ":[{},[1]]}],"a":[{"a":[{},[0,3]],"e":[{},[0,3]],"o":[{},[0,3]]}],"e":[{"a":[{},[0,3]],"e":[{},[0,3]],"o":[{},[0,3]]}],"i":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"â":[{},[0,3]],"ê":[{},[0,3]],"ô":[{},[0,3]]}],"o":[{"a":[{},[0,3]],"e":[{},[0,3]],"o":[{},[0,3]]}],"u":[{"a":[{},[0,3]],"e":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]}],"-":[{},[1]]}';
  var hyphenation = ["hard-ware", "soft-ware", ""];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
