(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsShLatn = factory();
  }
})(this, function () {
  var patterns =
    '{"t":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{"a":[{"s":[{"t":[{},[3,2]]}]}],"u":[{"l":[{"j":[{},[3,2]]},[3,2]],"o":[{},[3,2]],"r":[{},[3,2]]}]},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"d":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]]},[0,2]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]],"ž":[{"ž":[{},[2,0,1]],"b":[{},[2,0,1]],"c":[{},[2,0,1]],"d":[{"ž":[{},[2,0,1]]},[2,0,1]],"f":[{},[2,0,1]],"g":[{},[2,0,1]],"h":[{},[2,0,1]],"j":[{},[2,0,1]],"k":[{},[2,0,1]],"l":[{"j":[{},[2,0,1]]},[2,0,1]],"m":[{},[2,0,1]],"n":[{"j":[{},[2,0,1]]},[2,0,1]],"p":[{},[2,0,1]],"r":[{},[2,0,1]],"s":[{},[2,0,1]],"t":[{},[2,0,1]],"v":[{},[2,0,1]],"z":[{},[2,0,1]],"š":[{},[2,0,1]],"đ":[{},[2,0,1]],"ć":[{},[2,0,1]],"č":[{},[2,0,1]],".":[{},[2]]},[0,2]]}],"g":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]],"e":[{"g":[{"o":[{"d":[{".":[{},[3,2]]}]}]}],"k":[{"a":[{"k":[{},[3,2]],"d":[{},[3,2]]}]}]}],"j":[{"e":[{"g":[{"o":[{"d":[{".":[{},[3,2]]}]}]}],"k":[{"a":[{"k":[{},[3,2]],"d":[{},[3,2]]}]}]}]}]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{"i":[{"l":[{"j":[{},[3,2]]},[3,2]],"z":[{},[3,2]]}]},[2,1]],"n":[{"j":[{"e":[{"v":[{},[3,2]],"s":[{},[3,2]],"t":[{},[3,2]],"č":[{},[3,2]]}],"a":[{"v":[{},[3,2]]}],"i":[{"l":[{"j":[{},[3,2]]},[3,2]],"o":[{},[3,2]],"t":[{},[3,2]]}],"u":[{"r":[{},[3,2]]}]},[2,1]],"o":[{"s":[{},[3,2]],"z":[{},[3,2]],"j":[{},[3,2]]}],"a":[{"j":[{},[3,2]]}],"e":[{"z":[{"d":[{},[3,2]]}],"ž":[{"đ":[{},[3,2]]}],"v":[{},[3,2]]}],"i":[{"j":[{"e":[{"z":[{"d":[{},[3,2]]}],"ž":[{"đ":[{},[3,2]]}]}]}]}]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"h":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{"e":[{"t":[{"i":[{},[3,2]]}],"l":[{},[3,2]],"v":[{},[3,2]],"n":[{"j":[{},[3,2]]}]}],"j":[{"e":[{"t":[{"i":[{},[3,2]]}],"l":[{},[3,2]],"v":[{},[3,2]],"n":[{"j":[{},[3,2]]}]}]}]},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"k":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{"i":[{"ž":[{},[3,2]],"g":[{},[3,2]]}]},[2,1]],"e":[{"z":[{},[3,2]],"ž":[{},[3,2]]}]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"p":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{"i":[{"k":[{},[3,2]],"č":[{},[3,2]]}],"o":[{"v":[{},[3,2]]}],"u":[{"j":[{},[3,2]]}]},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"v":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"b":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]],"e":[{"t":[{},[3,2]],"n":[{"j":[{},[3,2]]}]}],"j":[{"e":[{"t":[{},[3,2]],"n":[{"j":[{},[3,2]]}]}]}]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"f":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"m":[{"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]],"o":[{"ž":[{},[3,2]],"g":[{},[3,2]]}],"a":[{"ž":[{},[3,2]]}]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"s":[{"c":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{"j":[{},[2]]},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]]},[0,2]],"j":[{".":[{},[2]]},[0,2]],"k":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]}]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"m":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]]},[0,2]],"n":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"p":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"t":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{},[2,3]]},[0,2]],"v":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{"j":[{},[2,3]]}]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{"e":[{"r":[{},[3,2]]}]},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"s":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"z":[{"b":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{"j":[{},[2,3]]}]},[0,2]],"d":[{"ž":[{},[2,1]],".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]],"v":[{},[2,3]]},[0,2]],"g":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]}]},[0,2]],"j":[{".":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"m":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{},[2,3]],"r":[{},[2,3]]},[0,2]],"n":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"ž":[{},[2,1]],"c":[{},[2,1]],"f":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"š":[{"c":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{"j":[{},[2]]},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"v":[{},[2,3]]},[0,2]],"k":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"m":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"n":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"p":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"t":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"v":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"ć":[{".":[{},[2]]},[0,2]],"č":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"j":[{},[2]],"k":[{},[2]],"l":[{"j":[{},[2]]},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"v":[{},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"s":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"j":[{},[2,1]],"r":[{},[2,1]]}],"ž":[{"b":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]]},[0,2]],"d":[{"ž":[{},[2,1]],".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"v":[{},[2,3]]},[0,2]],"g":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]],"v":[{},[2,3]]},[0,2]],"l":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"m":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"j":[{},[2,3]],"l":[{"j":[{},[2,3]]},[2,3]],"r":[{},[2,3]]},[0,2]],"n":[{"j":[{".":[{},[2]]},[0,2]],".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"ž":[{},[2]]},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{"j":[{},[2]]},[2]],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]],"š":[{},[2]],"đ":[{},[2]],"ć":[{},[2]],"č":[{},[2]],"ž":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"đ":[{".":[{},[2]]},[0,2]],"ž":[{},[2,1]],"c":[{},[2,1]],"f":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]],"j":[{},[2,1]],"r":[{},[2,1]]}],"c":[{"j":[{".":[{},[2]]},[0,2]],"r":[{".":[{},[2]]},[0,2]],"v":[{".":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{"i":[{"z":[{},[3,2]]}],"a":[{"k":[{},[3,2]],"č":[{},[3,2]]}],"o":[{"k":[{},[3,2]]}]},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"č":[{"v":[{".":[{},[2]],"l":[{"j":[{},[2,3]]},[2,3]],"j":[{},[2,3]]},[0,2]],"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]],"a":[{"n":[{"j":[{},[3,2]]},[3,2]]}]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"j":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"l":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]],"j":[{"ž":[{},[2,0,1]],"b":[{},[2,0,1]],"c":[{},[2,0,1]],"d":[{"ž":[{},[2,0,1]]},[2,0,1]],"f":[{},[2,0,1]],"g":[{},[2,0,1]],"h":[{},[2,0,1]],"j":[{},[2,0,1]],"k":[{},[2,0,1]],"l":[{"j":[{},[2,0,1]]},[2,0,1]],"m":[{},[2,0,1]],"n":[{"j":[{},[2,0,1]]},[2,0,1]],"p":[{},[2,0,1]],"r":[{},[2,0,1]],"s":[{},[2,0,1]],"t":[{},[2,0,1]],"v":[{},[2,0,1]],"z":[{},[2,0,1]],"š":[{},[2,0,1]],"đ":[{},[2,0,1]],"ć":[{},[2,0,1]],"č":[{},[2,0,1]]},[0,2]]}],"n":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]],"j":[{"ž":[{},[2,0,1]],"b":[{},[2,0,1]],"c":[{},[2,0,1]],"d":[{"ž":[{},[2,0,1]]},[2,0,1]],"f":[{},[2,0,1]],"g":[{},[2,0,1]],"h":[{},[2,0,1]],"j":[{},[2,0,1]],"k":[{},[2,0,1]],"l":[{"j":[{},[2,0,1]]},[2,0,1]],"m":[{},[2,0,1]],"n":[{"j":[{},[2,0,1]]},[2,0,1]],"p":[{},[2,0,1]],"r":[{},[2,0,1]],"s":[{},[2,0,1]],"t":[{},[2,0,1]],"v":[{},[2,0,1]],"z":[{},[2,0,1]],"š":[{},[2,0,1]],"đ":[{},[2,0,1]],"ć":[{},[2,0,1]],"č":[{},[2,0,1]]},[0,2]],"i":[{"g":[{"d":[{"e":[{".":[{},[0,0,3,2]]}],"j":[{"e":[{".":[{},[0,0,3,2]]}]}]}]}]}],"e":[{"g":[{"d":[{"e":[{".":[{},[0,0,3,2]]}],"j":[{"e":[{".":[{},[0,0,3,2]]}]}]}]}]}]}],"r":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{"e":[{"m":[{},[4,3]],".":[{},[4,3]]},[3,2]]},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{"a":[{},[3,2]]},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"đ":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],"ć":[{"ž":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"ž":[{},[2,1]]},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{"j":[{},[2,1]]},[2,1]],"m":[{},[2,1]],"n":[{"j":[{},[2,1]]},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]],"š":[{},[2,1]],"đ":[{},[2,1]],"ć":[{},[2,1]],"č":[{},[2,1]]}],".":[{"h":[{},[0,2]],"j":[{"u":[{"r":[{"i":[{"s":[{"k":[{},[0,0,0,0,2,3]],"p":[{},[0,0,0,0,2,3]]}]}]}]}]},[0,2]],"k":[{},[0,2]],"l":[{"j":[{},[0,0,2]]},[0,2]],"m":[{},[0,2]],"n":[{"j":[{},[0,0,2]],"a":[{"g":[{"n":[{"j":[{},[0,0,0,2]]},[0,0,0,2]]}],"d":[{"n":[{"e":[{"v":[{},[0,0,3,2]]}],"i":[{"č":[{},[0,0,3,2]],"c":[{},[0,0,3,2]]}]}],"l":[{"j":[{},[0,0,2,3]],"a":[{"n":[{},[0,0,3,4]]}],"e":[{"š":[{},[0,0,3,4]],"ž":[{},[0,0,3,4]]}]},[0,0,2,3]],"v":[{"a":[{"l":[{},[0,0,3,4]]}],"e":[{"s":[{"i":[{},[0,0,3,4]],"t":[{},[0,0,3,4]]}]}],"i":[{"j":[{},[0,0,3,4]],"t":[{},[0,0,3,4]]}],"l":[{"a":[{},[0,0,3,4]]}],"o":[{"j":[{"e":[{},[0,0,3,4]]}],"r":[{},[0,0,3,4]]}]},[0,0,2,3]],"i":[{"g":[{"r":[{},[0,0,2,3]]}],"n":[{"ž":[{},[0,0,2,3]],"a":[{},[0,0,2,3]]}],"s":[{"k":[{},[0,0,2,3]]}]}],"j":[{"a":[{"h":[{},[0,0,2,3]],"č":[{},[0,0,2,3]]}],"e":[{"k":[{},[0,0,2,3]],"z":[{},[0,0,2,3]],"č":[{},[0,0,2,3]]}],"u":[{"n":[{},[0,0,2,3]]}]}],"o":[{"r":[{"a":[{},[0,0,2,3]]}],"s":[{"o":[{},[0,0,2,3]],"e":[{},[0,0,2,3]],"j":[{"e":[{},[0,0,2,3]]}]}],"f":[{"i":[{},[0,0,2,3]]}],"č":[{},[0,0,2,3]]}],"r":[{"a":[{"n":[{},[0,0,2,3]],"č":[{},[0,0,2,3]],"s":[{"t":[{},[0,0,2,3]]}],"š":[{"ć":[{},[0,0,2,3]]}]}],"e":[{"a":[{"l":[{},[0,0,2,3]]}],"p":[{},[0,0,2,3]]}],"u":[{"k":[{},[0,0,2,3]],"č":[{},[0,0,2,3]],"g":[{},[0,0,2,3]]}]}],"u":[{"d":[{"a":[{"r":[{},[0,0,2,3]]}]}],"m":[{},[0,0,2,3]],"č":[{},[0,0,2,3]]}],"ž":[{"d":[{"r":[{},[0,0,2,3]]}],"n":[{"j":[{},[0,0,2,3]]}],"e":[{},[0,0,2,3]],"a":[{"n":[{"j":[{},[0,0,2,3]]}]}],"i":[{"r":[{},[0,0,2,3]],"v":[{},[0,0,2,3]]}],"u":[{"p":[{},[0,0,2,3]]}]}]}],"t":[{"k":[{"a":[{"h":[{},[0,0,3,2]],"m":[{},[0,0,3,2]],"s":[{"m":[{},[0,0,3,2]],"t":[{},[0,0,3,2]]}]}]}]}],"j":[{"a":[{"v":[{"i":[{},[0,0,3,4]],"l":[{"j":[{},[0,0,3,4]]}],"a":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}],"d":[{"i":[{},[0,0,3,4]],"a":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}],"ž":[{"i":[{},[0,0,3,4]]}],"z":[{"i":[{},[0,0,3,4]]}],"k":[{"o":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}],"l":[{"o":[{},[0,0,3,4]]}],"m":[{"i":[{},[0,0,3,4]],"l":[{},[0,0,3,4]],"n":[{},[0,0,3,4]]}],"r":[{"i":[{},[0,0,3,4]],"m":[{},[0,0,3,4]],"c":[{},[0,0,3,4]]}],"t":[{"i":[{},[0,0,3,4]]}],"u":[{"k":[{},[0,0,3,4]]}],"h":[{},[0,0,3,4]],"š":[{},[0,0,3,4]]},[0,0,2,3]],"e":[{"d":[{"i":[{},[0,0,3,4]],"n":[{},[0,0,3,4]],"r":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}],"ž":[{"i":[{},[0,0,3,4]],"u":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}],"z":[{"n":[{},[0,0,3,4]],"d":[{},[0,0,3,4]]}],"s":[{"t":[{"i":[{},[0,0,3,4]]}]}],"t":[{"k":[{},[0,0,3,4]]}],"c":[{},[0,0,3,4]]},[0,0,2,3]],"i":[{},[0,0,2,3]],"o":[{},[0,0,2,3]],"u":[{"r":[{"i":[{},[0,0,3,4]],"e":[{"n":[{},[0,0,3,4]]}]}]},[0,0,2,3]]}]}],"u":[{"z":[{"b":[{"e":[{"l":[{},[0,0,2,3]]}],"i":[{"l":[{"j":[{},[0,0,2,3]]}]}]}],"l":[{"j":[{"u":[{"b":[{},[0,0,2,3]]}]}]}],"r":[{"e":[{},[0,0,2,3]],"j":[{"e":[{},[0,0,2,3]]}]}],"u":[{"ž":[{},[0,0,2,3]]}]}],"s":[{"p":[{"o":[{"s":[{},[0,0,2,3]]}],"r":[{"o":[{},[0,0,2,3]]}]}]}]}]},[0,2]],"p":[{"o":[{"g":[{"n":[{},[0,0,3,2]]}],"d":[{"n":[{"e":[{"v":[{},[0,0,3,2]]}]}],"a":[{"d":[{"m":[{},[0,0,2,3]]}]}],"v":[{"a":[{"r":[{"i":[{"j":[{},[0,0,2,3]]}]}]}],"e":[{"z":[{},[0,0,2,3]],"č":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]]}],"i":[{"k":[{},[0,0,2,3]],"l":[{},[0,0,2,3]],"r":[{},[0,0,2,3]],"n":[{"j":[{},[0,0,2,3]]}]}],"l":[{"a":[{"s":[{},[0,0,2,3]],"š":[{},[0,0,2,3]]}]}],"o":[{"z":[{},[0,0,2,3]],"đ":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]],"d":[{},[0,0,2,3]]}],"r":[{"a":[{"t":[{},[0,0,2,3]],"ć":[{},[0,0,2,3]]}],"ć":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]],"g":[{},[0,0,2,3]],"i":[{"s":[{},[0,0,2,3]]}],"s":[{},[0,0,2,3]]}],"u":[{"ć":[{},[0,0,2,3]]}]}],"i":[{"g":[{"r":[{},[0,0,2,3]]}],"z":[{"v":[{},[0,0,2,3]]}]}],"j":[{"e":[{"n":[{},[0,0,3,4]],"č":[{},[0,0,3,4]]}]},[0,0,2,3]],"l":[{"a":[{"k":[{"a":[{"t":[{},[0,0,2,3]]}],"t":[{},[0,0,2,3]]}]}],"e":[{"p":[{},[0,0,2,3]],"t":[{},[0,0,2,3]],"ć":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]],"g":[{},[0,0,2,3]]}],"i":[{"z":[{},[0,0,2,3]],"j":[{"e":[{"p":[{},[0,0,2,3]],"t":[{},[0,0,2,3]],"ć":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]],"g":[{},[0,0,2,3]]}]}],"s":[{"t":[{},[0,0,2,3]]}]}],"o":[{"k":[{},[0,0,2,3]],"m":[{},[0,0,2,3]]}],"u":[{"p":[{},[0,0,2,3]],"č":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]]}],"j":[{"u":[{"t":[{},[0,0,2,3]]}]}]}],"o":[{"k":[{"n":[{},[0,0,2,3]]}],"š":[{},[0,0,2,3]],"č":[{},[0,0,2,3]],"f":[{},[0,0,2,3]]}],"r":[{"a":[{"v":[{"n":[{"j":[{},[0,0,2,3]]},[0,0,2,3]]}],"d":[{},[0,0,2,3]],"z":[{"d":[{},[0,0,2,3,0,2,3]],"r":[{},[0,0,2,3]],"u":[{},[0,0,2,3]]}],"m":[{},[0,0,2,3]],"n":[{"j":[{},[0,0,2,3]]},[0,0,2,3]],"s":[{},[0,0,2,3]]}],"e":[{"p":[{},[0,0,2,3]],"s":[{},[0,0,2,3]],"z":[{},[0,0,2,3]]}],"i":[{"k":[{},[0,0,2,3]],"t":[{},[0,0,2,3]]}],"o":[{"n":[{},[0,0,2,3]],"v":[{},[0,0,2,3]],"ž":[{},[0,0,2,3]]}],"u":[{"k":[{},[0,0,2,3]],"b":[{},[0,0,2,3]],"č":[{"i":[{},[0,0,2,3]],"n":[{},[0,0,2,3]],"a":[{},[0,0,2,3]]}]}]}],"u":[{"p":[{"l":[{"a":[{},[0,0,2,3]]}]}],"s":[{"m":[{},[0,0,2,3]],"n":[{},[0,0,2,3]]}]}]}],"m":[{"n":[{"j":[{},[0,0,3,2]]},[0,0,3,2]]}],"r":[{"v":[{},[0,0,3,2]],"đ":[{},[0,0,3,2]]}],"t":[{"k":[{"a":[{"h":[{},[0,0,3,2]],"m":[{},[0,0,3,2]],"t":[{},[0,0,3,2]],"v":[{},[0,0,3,2]]}]}]}],"s":[{"t":[{"e":[{"g":[{"z":[{},[0,0,2,0,3]]}]}],"i":[{"n":[{"d":[{"u":[{},[0,0,2,0,3]]}]}]}],"l":[{"i":[{"m":[{},[0,0,2,0,3]]}]}],"o":[{"n":[{"k":[{},[0,0,2,0,3]]}],"p":[{"e":[{"r":[{},[0,0,2,0,3]]}]}]}]}]}]}],"r":[{"e":[{"d":[{"m":[{"n":[{"j":[{},[0,0,0,0,3,2]]},[0,0,0,0,3,2]]}],"j":[{"e":[{"n":[{},[0,0,0,3,4]]}]},[0,0,0,2,3]],"v":[{"a":[{"j":[{},[0,0,0,3,4]],"r":[{},[0,0,0,3,4]]}],"e":[{"s":[{"t":[{},[0,0,0,3,4]]}]}],"o":[{"j":[{"i":[{},[0,0,0,3,4]],"a":[{},[0,0,0,3,4]],"e":[{},[0,0,0,3,4]]}],"r":[{},[0,0,0,3,4]],"s":[{},[0,0,0,3,4]]}]},[0,0,0,2,3]],"i":[{"g":[{"r":[{},[0,0,0,2,3]]}],"d":[{},[0,0,0,2,3]],"z":[{"b":[{},[0,0,0,2,3]]}],"s":[{"p":[{"i":[{},[0,0,0,2,3]]}],"t":[{"o":[{},[0,0,0,2,3]],"r":[{},[0,0,0,2,3]]}]}]}],"o":[{"b":[{"j":[{},[0,0,0,2,3]]}],"d":[{"r":[{"e":[{},[0,0,0,2,3]]}]}],"k":[{"u":[{"s":[{},[0,0,0,2,3]]}]}],"s":[{"v":[{},[0,0,0,2,3]],"e":[{},[0,0,0,2,3]],"j":[{"e":[{},[0,0,0,2,3]]}]}]}],"r":[{"a":[{"t":[{},[0,0,0,2,3]],"č":[{},[0,0,0,2,3]],"d":[{},[0,0,0,2,3]]}],"u":[{"č":[{},[0,0,0,2,3]]}]}],"u":[{"b":[{"e":[{"đ":[{},[0,0,0,2,3]]}],"i":[{"j":[{"e":[{"đ":[{},[0,0,0,2,3]]}]}]}],"j":[{"e":[{"đ":[{},[0,0,0,2,3]]}]}]}],"v":[{"e":[{"r":[{},[0,0,0,2,3]]}],"j":[{"e":[{"r":[{},[0,0,0,2,3]],"t":[{},[0,0,0,2,3]]}]}]}],"g":[{"o":[{"v":[{},[0,0,0,2,3]]}]}],"d":[{"a":[{"r":[{},[0,0,0,2,3]]}]}],"p":[{"i":[{"s":[{},[0,0,0,2,3]]}]}],"s":[{"l":[{"o":[{},[0,0,0,2,3]]}]}]}],"ž":[{"i":[{},[0,0,0,2,3]],"e":[{},[0,0,0,2,3]]}]}],"t":[{"k":[{"a":[{"h":[{},[0,0,0,3,2]],"m":[{},[0,0,0,3,2]],"t":[{},[0,0,0,3,2]]}]}]}]}],"o":[{"g":[{"n":[{},[0,0,0,3,2]]}],"t":[{"k":[{"i":[{},[0,0,0,3,2]],"a":[{},[0,0,0,3,2]]}],"i":[{"v":[{"a":[{"k":[{"c":[{},[0,0,0,0,0,2,3]]}]}],"o":[{"t":[{"r":[{},[0,0,0,0,0,2,3]]}],"f":[{},[0,0,0,0,0,2,3]]}],"r":[{},[0,0,0,0,0,2,3]],"u":[{"s":[{},[0,0,0,0,0,2,3]],"d":[{},[0,0,0,0,0,2,3]]}]}]}]}]}]}]},[0,2]],"r":[{"a":[{"z":[{"a":[{"g":[{"n":[{},[0,0,0,0,3,2]]}],"t":[{"k":[{"a":[{},[0,0,0,0,3,2]]}]}],"n":[{"a":[{"l":[{},[0,0,2,3]]}]}]}],"g":[{"n":[{},[0,0,0,3,2]],"a":[{"đ":[{},[0,0,3,4]]}],"r":[{"t":[{},[0,0,3,4]]}]},[0,0,2,3]],"d":[{"n":[{"i":[{},[0,0,0,3,2]]}]},[0,0,2,3]],"b":[{"a":[{"n":[{},[0,0,3,4]],"r":[{},[0,0,3,4]],"u":[{},[0,0,3,4]],"d":[{},[0,0,3,4]],"š":[{"u":[{"r":[{},[0,0,3,4]]}]}]}],"o":[{"j":[{},[0,0,3,4]],"r":[{},[0,0,3,4]]}]},[0,0,2,3]],"e":[{"v":[{},[0,0,3,4]]},[0,0,2,3]],"i":[{"j":[{},[0,0,3,4]],"l":[{},[0,0,3,4]],"n":[{},[0,0,3,4]],"r":[{},[0,0,3,4]],"t":[{},[0,0,3,4]],"z":[{},[0,0,3,4]],"đ":[{},[0,0,3,4]],"ć":[{},[0,0,3,4]],"d":[{},[0,0,3,4]]},[0,0,2,3]],"j":[{},[0,0,2,3]],"l":[{"j":[{},[0,0,2,3]],"a":[{"z":[{},[0,0,3,4]],"g":[{},[0,0,3,4]]}],"i":[{"k":[{},[0,0,3,4]],"č":[{},[0,0,3,4]]}],"o":[{"z":[{},[0,0,3,4]],"ž":[{},[0,0,3,4]],"g":[{},[0,0,3,4]]}]},[0,0,2,3]],"m":[{"e":[{"t":[{},[0,0,3,4]],"ć":[{},[0,0,3,4]]}],"r":[{"s":[{"k":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"n":[{"j":[{},[0,0,2,3]],"a":[{"t":[{},[0,0,3,4]]}]},[0,0,2,3]],"r":[{"e":[{"d":[{},[0,0,3,4]]}],"o":[{"k":[{},[0,0,3,4]],"č":[{},[0,0,3,4]]}]},[0,0,2,3]],"v":[{"a":[{"l":[{},[0,0,3,4]]}],"e":[{"d":[{"e":[{},[0,0,3,4]]}],"s":[{"t":[{},[0,0,3,4]]}]}],"i":[{"g":[{"o":[{},[0,0,3,4]]}],"j":[{"u":[{},[0,0,3,4]],"a":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}],"t":[{},[0,0,3,4]],"ć":[{},[0,0,3,4]]}],"o":[{"j":[{},[0,0,3,4]],"n":[{},[0,0,3,4]]}],"r":[{"a":[{"t":[{},[0,0,3,4]],"ć":[{},[0,0,3,4]]}],"t":[{},[0,0,3,4]],"ć":[{},[0,0,3,4]]}]},[0,0,2,3]],"o":[{"b":[{"l":[{},[0,0,2,3]],"r":[{},[0,0,2,3]],"a":[{},[0,0,2,3]]}],"d":[{},[0,0,2,3]],"r":[{"a":[{"t":[{},[0,0,2,3]],"v":[{},[0,0,2,3]]}],"t":[{},[0,0,2,3]],"u":[{},[0,0,2,3]]}],"t":[{},[0,0,2,3]]}],"u":[{"v":[{"e":[{},[0,0,2,3]]}],"d":[{"i":[{},[0,0,2,3]],"a":[{},[0,0,2,3]],"b":[{},[0,0,2,3]]}],"z":[{"i":[{},[0,0,2,3]],"d":[{},[0,0,2,3]],"e":[{},[0,0,2,3]]}],"l":[{"a":[{"r":[{},[0,0,2,3]]}]}],"m":[{"r":[{},[0,0,2,3]]}]}]}],"ž":[{"đ":[{},[0,0,2,3]]}],"s":[{"c":[{},[0,0,2,3]],"k":[{"a":[{"k":[{},[0,0,3,4]],"n":[{"d":[{},[0,0,3,4]]}]}],"i":[{"n":[{},[0,0,3,4]]}],"l":[{"a":[{"p":[{},[0,0,3,4]],"n":[{"j":[{},[0,0,3,4]]}],"d":[{},[0,0,3,4]]}],"o":[{"n":[{},[0,0,3,4]],"p":[{"i":[{},[0,0,3,4]],"l":[{"j":[{},[0,0,3,4]]}],"a":[{},[0,0,3,4]]}]}]}],"o":[{"š":[{},[0,0,3,4]]}],"r":[{"o":[{"p":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"p":[{"a":[{"j":[{},[0,0,3,4]],"v":[{},[0,0,3,4]]}],"e":[{"t":[{"i":[{},[0,0,3,4]],"o":[{},[0,0,3,4]],"a":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}]}],"i":[{"k":[{"u":[{},[0,0,3,4]]}],"n":[{"j":[{},[0,0,3,4]]}]}],"l":[{"i":[{"n":[{"j":[{},[0,0,3,4]]},[0,0,3,4]]}]}],"n":[{},[0,0,3,4]],"o":[{"l":[{"o":[{"ž":[{},[0,0,3,4]]}]}],"n":[{},[0,0,3,4]],"r":[{},[0,0,3,4]]}],"r":[{"a":[{"v":[{},[0,0,3,4]]}],"e":[{"m":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"t":[{"a":[{"j":[{},[0,0,3,4]],"n":[{},[0,0,3,4]],"t":[{},[0,0,3,4]],"v":[{},[0,0,3,4]]}],"e":[{"n":[{"j":[{},[0,0,3,4]]}]}],"i":[{"l":[{},[0,0,3,4]],"r":[{},[0,0,3,4]],"s":[{},[0,0,3,4]],"t":[{},[0,0,3,4]],"n":[{"j":[{},[0,0,3,4]]}]}],"o":[{"j":[{},[0,0,3,4]]}],"r":[{"e":[{"l":[{},[0,0,3,4]],"t":[{},[0,0,3,4]]}],"o":[{"j":[{},[0,0,3,4]]}],"t":[{},[0,0,3,4]]}],"u":[{"p":[{},[0,0,3,4]],"r":[{"č":[{},[0,0,4,5]]},[0,0,3,4]],"ć":[{},[0,0,3,4]]}]},[0,0,2,3]],"r":[{"đ":[{},[0,0,3,4]],"d":[{},[0,0,3,4]],"e":[{},[0,0,3,4]]}]}],"š":[{"ć":[{"e":[{"n":[{"j":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"č":[{"i":[{"ć":[{},[0,0,3,4]]}]},[0,0,2,3]]}]}]},[0,2]],"s":[{"u":[{"b":[{"a":[{"š":[{},[0,0,3,4]]},[0,0,2,3]],"l":[{},[0,0,2,3]],"i":[{"n":[{"v":[{},[0,0,2,3]]}]}],"j":[{"u":[{"n":[{"k":[{},[0,0,2,3]]}]}]}],"o":[{"k":[{"s":[{},[0,0,2,3]]}],"r":[{"d":[{},[0,0,2,3]]}]}],"r":[{"e":[{"p":[{},[0,0,2,3]]}],"o":[{"g":[{},[0,0,2,3]]}]}]}],"p":[{"e":[{"r":[{"i":[{"o":[{"r":[{},[0,0,0,0,3,4]]}]},[0,0,0,0,2,3]],"o":[{},[0,0,0,0,2,3]],"u":[{},[0,0,0,0,2,3]],"a":[{},[0,0,0,0,2,3]],"e":[{},[0,0,0,0,2,3]]}]}]}]}]},[0,2]],"t":[{"r":[{"a":[{"n":[{"s":[{"a":[{},[0,0,0,0,2,3]],"c":[{},[0,0,0,0,2,3]],"e":[{"p":[{},[0,0,0,0,3,4]]},[0,0,0,0,2,3]],"k":[{"r":[{"i":[{},[0,0,0,0,3,4]]}]},[0,0,0,0,2,3]],"l":[{},[0,0,0,0,2,3]],"m":[{},[0,0,0,0,2,3]],"n":[{"j":[{},[0,0,0,0,2,3]]},[0,0,0,0,2,3]],"o":[{},[0,0,0,0,2,3]],"p":[{},[0,0,0,0,2,3]],"t":[{},[0,0,0,0,2,3]],"u":[{"m":[{},[0,0,0,0,3,4]],"d":[{},[0,0,0,0,3,4]]},[0,0,0,0,2,3]],"v":[{},[0,0,0,0,2,3]]}]}]}]}]},[0,2]],"v":[{"a":[{"n":[{"e":[{"v":[{"r":[{},[0,0,2,3]]}]}],"u":[{"s":[{"t":[{"a":[{"v":[{},[0,0,2,3]]}]}]}]}]}]}]},[0,2]],"d":[{"ž":[{},[0,0,2]],"i":[{"s":[{"a":[{"k":[{"o":[{"r":[{},[0,0,2,3]]}]}]}],"j":[{"u":[{"n":[{"k":[{},[0,0,2,3]]}]}]}],"k":[{"v":[{"a":[{"l":[{},[0,0,2,3]]}]}],"o":[{"n":[{"t":[{},[0,0,2,3]]}],"r":[{"d":[{},[0,0,2,3]]}]}],"r":[{"e":[{},[0,0,2,3]],"i":[{},[0,0,2,3]]}],"u":[{"r":[{},[0,0,2,3]]}]}],"l":[{"o":[{},[0,0,2,3]]}],"o":[{"r":[{"i":[{"j":[{},[0,0,2,3]]}]}]}],"p":[{"a":[{"r":[{"i":[{"t":[{},[0,0,2,3]]}]}]}],"o":[{"z":[{},[0,0,2,3]],"n":[{},[0,0,2,3]]}],"r":[{"o":[{"p":[{},[0,0,2,3]]}]}]}],"t":[{"o":[{"n":[{},[0,0,2,3]]}],"r":[{"a":[{"k":[{},[0,0,2,3]]}]}]}]}]}]},[0,2]],"z":[{"a":[{"g":[{"n":[{},[0,0,3,2]]}],"t":[{"k":[{"a":[{},[0,0,3,2]]}]}]}]},[0,2]],"š":[{},[0,2]],"đ":[{},[0,2]],"ć":[{},[0,2]],"č":[{},[0,2]],"ž":[{},[0,2]],"b":[{"e":[{"o":[{},[0,0,4]],"z":[{"j":[{"a":[{"k":[{},[0,0,3,4]],"č":[{},[0,0,3,4]]}]},[0,0,2,3]],"l":[{"j":[{},[0,0,2,3]],"o":[{"b":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"m":[{},[0,0,2,3]],"n":[{"j":[{},[0,0,2,3]],"a":[{"č":[{"a":[{"j":[{},[0,0,3,4]]}]}]}]},[0,0,2,3]],"r":[{"a":[{"č":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"v":[{"u":[{"č":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"b":[{"e":[{"d":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}],"l":[{"i":[{},[0,0,3,4]]}]}],"j":[{"e":[{"d":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]}],"o":[{"l":[{},[0,0,3,4]]}]},[0,0,2,3]],"d":[{},[0,0,2,3]],"g":[{},[0,0,2,3]],"i":[{"s":[{"t":[{"a":[{"n":[{},[0,0,3,4]]}],"e":[{"n":[{},[0,0,3,4]]}]}]}]},[0,0,2,3]],"o":[{},[0,0,2,3]],"u":[{"p":[{},[0,0,3,4]],"b":[{},[0,0,3,4]]},[0,0,2,3]],"a":[{"l":[{"k":[{"o":[{"h":[{"o":[{"l":[{},[0,0,2,3]]}]}]}]}]}],"t":[{"o":[{"m":[{"s":[{"k":[{},[0,0,2,3]]}]}]}]}]}]}],"s":[{"c":[{},[0,0,2,3]],"k":[{"r":[{"u":[{"p":[{"u":[{"l":[{},[0,0,3,4]]}]}]}]}]},[0,0,2,3]],"p":[{"o":[{"k":[{"o":[{"j":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]}],"r":[{"n":[{},[0,0,3,4]],"a":[{},[0,0,3,4]]}]}]},[0,0,2,3]],"t":[{"v":[{"a":[{"r":[{},[0,0,3,4]]}]}],"i":[{"d":[{},[0,0,3,4]],"j":[{"a":[{},[0,0,3,4]]}],"l":[{"u":[{},[0,0,3,4]],"j":[{},[0,0,3,4]]}]}],"r":[{"a":[{"n":[{"a":[{},[0,0,3,4]]}],"s":[{},[0,0,3,4]]}]}],"s":[{"e":[{"l":[{"e":[{"r":[{},[0,0,0,4]]}]}]}]}]},[0,0,2,3]]}],"š":[{"ć":[{},[0,0,2,3]],"č":[{},[0,0,2,3]]}]}],"i":[{"o":[{},[0,0,4]]}]},[0,2]],"c":[{},[0,2]],"f":[{},[0,2]],"g":[{"e":[{"o":[{},[0,0,4]]}]},[0,2]],"a":[{"e":[{"r":[{"o":[{},[0,4,2]]}]}],"b":[{"a":[{"l":[{"i":[{"j":[{},[0,2,3]]}]}],"n":[{"a":[{"c":[{},[0,2,3]]}]}]}],"e":[{"v":[{"a":[{"k":[{},[0,2,3]]}]}],"r":[{"a":[{"c":[{},[0,2,3]]}],"i":[{"r":[{},[0,2,3]]}]}]}],"i":[{"r":[{"i":[{"t":[{},[0,2,3]]}]}]}],"j":[{"u":[{},[0,2,3]]}],"l":[{"a":[{},[0,2,3]],"e":[{"g":[{},[0,2,3]],"p":[{},[0,2,3]]}],"o":[{"k":[{},[0,2,3]]}],"u":[{},[0,2,3]]}],"o":[{"r":[{"i":[{"g":[{},[0,2,3]]}]}]}],"r":[{"e":[{"a":[{"k":[{},[0,2,3]]}]}],"o":[{"g":[{},[0,2,3]]}]}],"u":[{"z":[{"u":[{"s":[{},[0,2,3]]}]}]}]}],"d":[{"e":[{"r":[{"a":[{"c":[{},[0,2,3]]}]}]}],"v":[{"e":[{"r":[{"b":[{},[0,2,3]]}]}]}],"j":[{},[0,2,3]],"l":[{"a":[{"t":[{},[0,2,3]]}]}],"r":[{"e":[{"n":[{},[0,2,3]]}],"o":[{"g":[{},[0,2,3]]}]}]}],"g":[{"n":[{"o":[{"s":[{},[0,3,2]],"z":[{},[0,3,2]]}]}]}],"n":[{"a":[{"b":[{"a":[{"p":[{},[0,2]],"z":[{},[0,2]],"t":[{},[0,2]]}],"i":[{"o":[{},[0,2]]}],"o":[{"l":[{},[0,2]]}]}],"g":[{"e":[{"n":[{},[0,2]]}],"n":[{"o":[{},[0,2]]}],"o":[{},[0,2,3]],"r":[{"a":[{},[0,2]]}]}],"d":[{"e":[{"m":[{},[0,2]]}],"i":[{"p":[{"l":[{},[0,2]]}]}],"o":[{"z":[{},[0,2]]}]}],"e":[{"r":[{"o":[{},[0,2,3,4,2]]}]}],"k":[{"a":[{"l":[{},[0,2]],"m":[{},[0,2]],"t":[{},[0,2]]}],"e":[{"f":[{},[0,2]]}],"l":[{"a":[{},[0,2]],"i":[{},[0,2]]}],"o":[{"j":[{},[0,2]],"l":[{},[0,2]]}],"u":[{"z":[{},[0,2,3]]}],"r":[{"o":[{"n":[{},[0,2]]}],"u":[{},[0,2]]}]}],"l":[{"g":[{},[0,2,3]],"d":[{},[0,2,3]],"e":[{"p":[{},[0,2]]}],"i":[{"z":[{},[0,2]],"s":[{},[0,2]],"t":[{},[0,2]]}],"f":[{"a":[{},[0,2,3]]}]}],"m":[{"e":[{"r":[{"t":[{},[0,2,3]]}]}],"n":[{"e":[{},[0,2]]}]}],"n":[{"d":[{"r":[{},[0,2,3]]}],"e":[{"o":[{},[0,2]]}],"t":[{},[0,2,3]]}],"p":[{"l":[{"a":[{},[0,2]],"e":[{},[0,2]]}],"n":[{"e":[{},[0,2]],"o":[{},[0,2]]}],"r":[{"o":[{},[0,2]]}],"t":[{"i":[{},[0,2]],"o":[{},[0,2,3]]}]}],"r":[{"t":[{},[0,2]],"h":[{},[0,2,3]]}],"s":[{"a":[{"r":[{},[0,2]]}],"e":[{"i":[{},[0,2]]}],"p":[{"a":[{"z":[{},[0,2]]}]}],"t":[{"a":[{},[0,2]],"i":[{"g":[{},[0,2]]}],"o":[{"m":[{},[0,2]]}]}]}],"t":[{"i":[{"m":[{},[0,2]]}],"o":[{"m":[{},[0,2]],"c":[{},[0,2]]}],"r":[{"e":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]]}]}],"f":[{"a":[{"z":[{},[0,2]]}],"i":[{"j":[{},[0,2,3]],"l":[{"a":[{},[0,2]]}]}],"o":[{"n":[{},[0,2]],"r":[{},[0,2]]}],"r":[{"o":[{"d":[{},[0,2,3]]}]}]}],"h":[{"o":[{"r":[{},[0,2]]}],"r":[{"o":[{},[0,2]]}]}]}],"e":[{"g":[{"e":[{"r":[{},[0,2,3]]}]}],"k":[{"l":[{},[0,2,3]],"u":[{"m":[{},[0,2,3]]}]}],"l":[{"e":[{"k":[{},[0,2,3]]}]}],"n":[{"e":[{"r":[{},[0,2,3]]}]}],"p":[{"i":[{},[0,2,3]]}],"o":[{"r":[{},[0,2]]}],"r":[{"g":[{},[0,2,3]],"i":[{"t":[{},[0,2,3]]}]}],"s":[{"t":[{"e":[{},[0,2,3]]}]}]}],"i":[{"d":[{"r":[{},[0,2,3]]}],"z":[{"o":[{"g":[{},[0,2,3]],"m":[{},[0,2,3]]}],"u":[{"r":[{},[0,2,3]]}]}],"r":[{"i":[{"d":[{},[0,2,3]]}]}]}],"o":[{"v":[{"a":[{"r":[{},[0,2,3]]}]}],"k":[{"s":[{},[0,2,3]]}],"p":[{"i":[{"s":[{},[0,2,3]]}]}],"r":[{"h":[{},[0,2,3]],"g":[{},[0,2,3]]}],"f":[{"t":[{},[0,2,3]]}]}],"j":[{"o":[{"n":[{},[0,2,3]]}]}]}]}],"i":[{"z":[{"a":[{"g":[{"n":[{},[0,0,0,3,2]]}],"t":[{"k":[{},[0,0,0,3,2]]}],"b":[{"a":[{},[0,2,3]]}],"k":[{"a":[{},[0,2,3]]}],"n":[{"a":[{"l":[{},[0,2,3]]}]}]}],"g":[{"n":[{},[0,0,3,2]],"o":[{"m":[{"e":[{"t":[{},[0,3,4]]}]}]}],"r":[{"e":[{"d":[{},[0,3,4]]}],"n":[{},[0,3,4]],"t":[{},[0,3,4]]}]},[0,2,3]],"d":[{"n":[{"o":[{},[0,0,0,2]],"u":[{},[0,0,0,2]],"a":[{},[0,0,0,2]]}],"a":[{"j":[{},[0,2,3]]}],"r":[{"a":[{"v":[{},[0,3,4]]}]}]},[0,2,3]],"r":[{"k":[{},[0,0,0,2]],"a":[{"e":[{"l":[{},[0,3,4]]}],"i":[{"l":[{"j":[{},[0,3,4]]}]}],"č":[{"i":[{},[0,3,4]]}]}]},[0,2,3]],"b":[{"i":[{"j":[{"a":[{},[0,2,3]]}],"v":[{"a":[{},[0,2,3]]}],"č":[{"k":[{"a":[{"v":[{"a":[{},[0,3,4]]}]}]}]}]}],"a":[{"v":[{},[0,3,4]]}],"l":[{"e":[{"u":[{"š":[{"a":[{"n":[{},[0,3,4]]}]}]}]}]}],"o":[{"j":[{"a":[{"k":[{},[0,3,4]]}],"k":[{},[0,3,4]]}]}],"e":[{"z":[{"o":[{"b":[{"r":[{},[0,0,3,0,2,3]]}]}],"u":[{"m":[{},[0,0,3,0,2,3]]}]}]}]},[0,2,3]],"j":[{"e":[{"ž":[{"l":[{"j":[{},[0,3,4]]}]}]}]},[0,2,3]],"l":[{"j":[{},[0,2,3]],"o":[{"z":[{},[0,3,4]],"ž":[{},[0,3,4]],"g":[{},[0,3,4]],"p":[{"a":[{"ć":[{},[0,3,4]]}]}]}]},[0,2,3]],"m":[{},[0,2,3]],"n":[{"j":[{},[0,2,3]],"i":[{"m":[{},[0,3,4]]}],"o":[{"j":[{},[0,3,4]]}]},[0,2,3]],"v":[{"e":[{"d":[{"i":[{},[0,2,3]],"n":[{},[0,2,3]],"b":[{},[0,2,3]],"e":[{},[0,2,3]]}]}],"a":[{"l":[{"i":[{},[0,3,4]],"u":[{},[0,3,4]],"a":[{},[0,3,4]],"e":[{},[0,3,4]],"j":[{"i":[{},[0,3,4]]}]}],"n":[{"e":[{"v":[{"r":[{},[0,0,3,0,2,3]]}]}]}]}],"i":[{"ž":[{"d":[{},[0,3,4]]}],"i":[{"s":[{"k":[{"r":[{},[0,3,4]]}]}]}],"j":[{"a":[{},[0,3,4]],"e":[{"n":[{},[0,3,4]]}]}],"n":[{"j":[{},[0,3,4]]},[0,3,4]],"r":[{},[0,3,4]],"t":[{"o":[{"p":[{},[0,3,4]]}]}]}],"j":[{"e":[{"d":[{},[0,3,4]]}]}],"o":[{"j":[{"a":[{"c":[{},[0,3,4]]}],"c":[{},[0,3,4]]}],"r":[{},[0,3,4]]}]},[0,2,3]],"i":[{"đ":[{},[0,3,4]],"d":[{},[0,3,4]],"m":[{"i":[{},[0,3,4]]}]},[0,2,3]],"o":[{"a":[{"n":[{"e":[{"m":[{},[0,0,4]]}],"o":[{"m":[{},[0,0,4]]}]}]}],"b":[{"a":[{"t":[{},[0,0,4]]}],"r":[{"o":[{"n":[{},[0,0,4]]}]}]}],"g":[{"a":[{"m":[{},[0,0,4]]}],"e":[{"o":[{},[0,0,4]]}],"l":[{"o":[{"s":[{},[0,0,4]]}]}],"o":[{"n":[{},[0,0,4]]}],"r":[{"a":[{"f":[{},[0,0,4]]}]}]}],"d":[{"i":[{"m":[{},[0,0,4]],"n":[{},[0,0,4]]}],"o":[{"z":[{},[0,0,4]]}]}],"k":[{"l":[{"i":[{"n":[{},[0,0,4]]}]}],"o":[{"l":[{"o":[{"n":[{},[0,0,4]]}]}]}]}],"l":[{"a":[{"t":[{},[0,3,4]],"c":[{},[0,3,4]]}],"i":[{"r":[{},[0,3,4]]}],"o":[{"v":[{},[0,3,4]]}],"e":[{"k":[{"s":[{},[0,0,4]]}]}],"u":[{"k":[{"s":[{},[0,0,4]]}]}]}],"m":[{"e":[{"r":[{},[0,0,4]],"t":[{"r":[{},[0,0,4]]}]}],"o":[{"r":[{"f":[{},[0,0,4]]}]}]}],"n":[{"e":[{"f":[{},[0,0,4]]}],"o":[{"m":[{},[0,0,4]]}]}],"p":[{"a":[{"t":[{},[0,0,4]]}],"e":[{"r":[{},[0,0,4]]}],"l":[{"e":[{},[0,0,4]]}],"o":[{"l":[{},[0,0,4]]}],"s":[{"e":[{"f":[{},[0,0,4]]}]}]}],"r":[{"a":[{"h":[{},[0,0,4]]}]}],"s":[{"e":[{"i":[{},[0,0,4]]}],"i":[{"n":[{"t":[{},[0,0,4]]}],"s":[{"t":[{},[0,0,4]]}]}],"k":[{"e":[{"l":[{},[0,0,4]]}],"o":[{"p":[{},[0,0,4]]}]}],"t":[{"a":[{"z":[{},[0,0,4]]}],"e":[{},[0,0,4]]}]}],"t":[{"a":[{"h":[{},[0,0,4]],"l":[{},[0,0,4]]}],"e":[{"r":[{},[0,0,4]]}],"o":[{"n":[{},[0,0,4]],"p":[{},[0,0,4]]}],"r":[{"o":[{},[0,0,4]]}]}],"f":[{"o":[{"n":[{},[0,0,4]],"t":[{},[0,0,4]]}]}],"h":[{"a":[{"l":[{},[0,0,4]],"z":[{},[0,0,4]]}],"e":[{"l":[{},[0,0,4]]}],"i":[{"j":[{},[0,0,4]],"m":[{},[0,0,4]],"t":[{},[0,0,4]],"p":[{"s":[{},[0,0,4]]}]}],"o":[{"r":[{},[0,0,4]]}],"r":[{"o":[{},[0,0,4]]}]}]},[0,2,3]],"u":[{"n":[{},[0,3,4]],"p":[{"č":[{},[0,3,4]]}]},[0,2,3]]}],"s":[{"t":[{"k":[{},[0,0,0,2]],"a":[{"v":[{"i":[{},[0,3,4]],"l":[{"j":[{},[0,3,4]]}]}],"k":[{"n":[{},[0,3,4]]}],"m":[{},[0,3,4]],"r":[{},[0,3,4]],"s":[{},[0,3,4]],"ć":[{},[0,3,4]]}],"i":[{"n":[{},[0,3,4]],"r":[{},[0,3,4]],"c":[{},[0,3,4]],"f":[{"a":[{"n":[{},[0,3,4]]}]}]}],"o":[{"k":[{},[0,3,4]],"r":[{"i":[{},[0,3,4]]}],"č":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]],"a":[{},[0,3,4]]}]}],"r":[{"a":[{"v":[{},[0,3,4]],"d":[{},[0,3,4]],"n":[{},[0,3,4]]}],"i":[{"ć":[{},[0,3,4]],"ž":[{},[0,3,4]],"c":[{},[0,3,4]]}],"u":[{"g":[{},[0,3,4]]}]}],"u":[{"p":[{},[0,3,4]]}]},[0,2,3]],"c":[{},[0,2,3]],"k":[{"a":[{"k":[{},[0,3,4]],"t":[{},[0,3,4]],"n":[{"j":[{},[0,3,4]]}],"r":[{"i":[{"o":[{"t":[{},[0,3,4]]}]}]}]}],"v":[{"a":[{"s":[{},[0,3,4]]}],"r":[{"č":[{},[0,3,4]]}]}],"i":[{"n":[{},[0,3,4]],"t":[{"a":[{},[0,3,4]]}]}],"o":[{"n":[{"s":[{"k":[{},[0,3,4]]}]}],"č":[{},[0,3,4]]}],"r":[{"a":[{"m":[{},[0,3,4]],"t":[{},[0,3,4]]}],"i":[{"t":[{},[0,3,4]],"š":[{},[0,3,4]],"č":[{},[0,3,4]],"c":[{},[0,3,4]]}],"e":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]]}],"o":[{"j":[{},[0,3,4]]}],"s":[{"n":[{},[0,3,4]],"a":[{},[0,3,4]]}]}],"u":[{"p":[{"l":[{"j":[{"a":[{},[0,3,4]]}]}]}]}]},[0,2,3]],"p":[{"a":[{"v":[{},[0,3,4]],"l":[{"j":[{"i":[{"v":[{},[0,3,4]]}]}]}]}],"i":[{"r":[{"a":[{},[0,3,4]]}]}],"l":[{"i":[{"t":[{},[0,3,4]],"ć":[{},[0,3,4]]}]}],"o":[{"k":[{"o":[{"j":[{},[0,3,4]]}]}],"l":[{"i":[{"n":[{},[0,3,4]]}]}],"n":[{},[0,3,4]],"r":[{"a":[{"v":[{},[0,3,4]]}]}]}],"r":[{"a":[{"v":[{"i":[{},[0,3,4]],"k":[{},[0,3,4]],"n":[{},[0,3,4]],"l":[{"j":[{},[0,3,4]]}],"a":[{},[0,3,4]]}]}]}],"u":[{"p":[{"č":[{},[0,3,4]]}],"r":[{},[0,3,4]]}]},[0,2,3]],"l":[{"a":[{"m":[{},[0,3,4]],"b":[{},[0,3,4]]}],"e":[{"đ":[{},[0,3,4]],"d":[{},[0,3,4]]}],"i":[{"j":[{"e":[{"đ":[{},[0,3,4]],"d":[{},[0,3,4]]}]}],"k":[{},[0,3,4]],"n":[{},[0,3,4]]}],"j":[{"e":[{"đ":[{},[0,3,4]],"d":[{},[0,3,4]]}]}],"o":[{"v":[{},[0,3,4]]}],"u":[{"š":[{},[0,3,4]],"ž":[{},[0,3,4]]}]}],"m":[{"e":[{},[0,3,4]],"i":[{"j":[{"e":[{},[0,3,4]]}]}],"j":[{"e":[{},[0,3,4]]}]}],"r":[{"e":[{"d":[{},[0,3,4]]}],"k":[{},[0,3,4]]}],"u":[{"k":[{},[0,3,4]],"s":[{},[0,3,4]],"t":[{},[0,3,4]],"š":[{},[0,3,4]]}]}],"ž":[{"đ":[{},[0,2,3]]}],"š":[{"ć":[{},[0,2,3]],"č":[{},[0,2,3]]}],"n":[{"a":[{"b":[{"r":[{"u":[{"p":[{},[0,2,3]]}]}]}],"d":[{"e":[{"k":[{},[0,2,3]]}]}],"k":[{"u":[{"r":[{},[0,2,3]]}],"c":[{"e":[{},[0,2,3]]}]}],"m":[{"o":[{"r":[{},[0,2,3]]}]}],"n":[{"i":[{"c":[{},[0,2,3]]}]}],"p":[{"l":[{"i":[{"k":[{},[0,2,3]]}]}],"s":[{"t":[{},[0,2,3]]}]}],"r":[{"t":[{},[0,2,3]]}],"u":[{"g":[{"u":[{"r":[{},[0,2,3]]}]}],"r":[{"a":[{},[0,2,3]]}]}],"f":[{"e":[{"k":[{},[0,2,3]]}]}]}],"e":[{"v":[{"i":[{"d":[{},[0,2,3]]}]}],"g":[{},[0,2,3]],"d":[{},[0,2,3]],"k":[{"v":[{},[0,2,3]],"s":[{},[0,2,3]]}],"l":[{"i":[{"g":[{},[0,2,3]]}]}],"p":[{"c":[{},[0,2,3]]}],"f":[{"e":[{"k":[{},[0,2,3]]}]}]}],"o":[{"b":[{"l":[{},[0,2,3]]}],"g":[{"e":[{"n":[{},[0,2]]}]}],"k":[{"o":[{"r":[{},[0,2]]}],"u":[{"p":[{},[0,2,3]]}]}],"p":[{"e":[{"r":[{},[0,2,3]]}],"o":[{"r":[{},[0,2,3]]}],"s":[{"e":[{},[0,2,3]]}]}],"f":[{"i":[{"c":[{},[0,2,3]]}]}]}],"u":[{"m":[{"b":[{"r":[{},[0,2,3]]}]}],"n":[{"d":[{"a":[{},[0,2,3]]}],"k":[{},[0,2,3]]}],"t":[{"i":[{"l":[{},[0,2,3]]}]}]}],"t":[{"e":[{"r":[{"i":[{"j":[{"e":[{},[0,0,0,0,3,4]]}]},[0,0,0,0,2,3]],"o":[{"g":[{"a":[{"t":[{},[0,0,0,0,3,4]]}]}]},[0,0,0,0,2,3]],"u":[{},[0,0,0,0,2,3]],"a":[{},[0,0,0,0,2,3]],"e":[{"g":[{"n":[{},[0,0,0,0,3,4]]}],"s":[{"i":[{},[0,0,0,0,3,4]],"n":[{},[0,0,0,0,3,4]],"o":[{},[0,0,0,0,3,4]],"u":[{},[0,0,0,0,3,4]],"a":[{},[0,0,0,0,3,4]],"e":[{},[0,0,0,0,3,4]]}],"ž":[{"d":[{"ž":[{},[0,0,0,0,3,4]]}]}]},[0,0,0,0,2,3]],"j":[{"e":[{},[0,0,0,0,2,3]]}]}]}]}],"j":[{"e":[{"k":[{},[0,2,3]]}],"u":[{"r":[{},[0,2,3]],"s":[{"t":[{},[0,2,3]]}]}]}]}]}],"o":[{"d":[{"a":[{"g":[{"n":[{},[0,0,0,3,2]]}],"d":[{"n":[{},[0,0,0,3,2]]}],"r":[{"g":[{},[0,2,3]]}]}],"g":[{"n":[{},[0,0,3,2]]}],"m":[{"n":[{},[0,0,3,2]]}],"j":[{"e":[{"l":[{},[0,3,4]],"n":[{},[0,3,4]],"v":[{},[0,3,4]],"ć":[{},[0,3,4]]}]},[0,2,3]],"l":[{"j":[{},[0,2,3]],"a":[{"z":[{},[0,3,4]],"ž":[{},[0,3,4]],"g":[{},[0,3,4]],"k":[{"a":[{},[0,3,4]]}]}],"u":[{"k":[{},[0,3,4]],"č":[{},[0,3,4]]}]},[0,2,3]],"r":[{"a":[{"n":[{"i":[{},[0,3,4]],"o":[{},[0,3,4]],"u":[{},[0,3,4]],"a":[{},[0,3,4]],"e":[{},[0,3,4]]}],"z":[{},[0,3,4]],"ć":[{},[0,3,4]],"ž":[{},[0,3,4]],"p":[{"i":[{},[0,3,4]],"l":[{"j":[{},[0,3,4]]}],"a":[{},[0,3,4]]}],"č":[{"i":[{},[0,3,4]]}]}],"v":[{"e":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]],"č":[{},[0,3,4]]}]}],"e":[{"m":[{},[0,3,4]],"n":[{},[0,3,4]],"t":[{},[0,3,4]],"đ":[{},[0,3,4]],"d":[{},[0,3,4]]}],"l":[{"j":[{},[0,3,4]]},[0,3,4]],"n":[{},[0,3,4]],"p":[{},[0,3,4]],"t":[{},[0,3,4]],"ž":[{},[0,3,4]],"i":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]],"š":[{},[0,3,4]],"č":[{},[0,3,4]],"b":[{},[0,3,4]],"c":[{},[0,3,4]]}],"o":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]]}],"u":[{"ž":[{},[0,3,4]],"g":[{},[0,3,4]]}]},[0,2,3]],"v":[{"a":[{"j":[{},[0,3,4]],"ž":[{},[0,3,4]]}],"e":[{"s":[{"n":[{},[0,3,4]],"t":[{},[0,3,4]],"a":[{},[0,3,4]]}]}],"i":[{"k":[{"a":[{"v":[{},[0,3,4]]}],"n":[{},[0,3,4]]}],"s":[{},[0,3,4]],"ć":[{},[0,3,4]]}],"o":[{"j":[{},[0,3,4]]}]},[0,2,3]],"i":[{"g":[{"r":[{},[0,2,3]]}],"z":[{"v":[{},[0,2,3,2,3]],"d":[{},[0,2,3,2,3]]}],"s":[{"k":[{},[0,2,3]],"t":[{"i":[{},[0,2,3]]}]}]}],"o":[{"z":[{"d":[{},[0,2,3]],"g":[{},[0,2,3]]}],"k":[{},[0,2,3]],"n":[{"l":[{},[0,2,3]],"o":[{},[0,2,3]],"u":[{},[0,2,3]],"d":[{},[0,2,3]]}]}],"u":[{"v":[{"i":[{},[0,2,3]],"e":[{},[0,2,3]]}],"z":[{"i":[{},[0,2,3]],"l":[{},[0,2,3]],"d":[{},[0,2,3]],"e":[{},[0,2,3]]}],"k":[{},[0,2,3]],"l":[{},[0,2,3]],"m":[{},[0,2,3]],"č":[{},[0,2,3]]}],"ž":[{"a":[{"l":[{"j":[{},[0,2,3]]},[0,2,3]]}],"i":[{},[0,2,3]],"v":[{},[0,2,3]],"e":[{},[0,2,3]]}]}],"t":[{"k":[{"a":[{"h":[{},[0,3,2]],"m":[{},[0,3,2]],"s":[{"m":[{},[0,3,2]],"t":[{},[0,3,2]]}]}]}]}],"b":[{"j":[{"e":[{"k":[{},[0,3,4]],"r":[{},[0,3,4]],"s":[{"i":[{},[0,3,4]]}],"t":[{},[0,3,4]],"š":[{},[0,3,4]]}]},[0,2,3]],"l":[{"j":[{"a":[{"n":[{},[0,3,4]]}],"u":[{"t":[{},[0,3,4]],"z":[{},[0,3,4]]}]},[0,2,3]],"a":[{"j":[{},[0,2,3]],"m":[{},[0,2,3]],"k":[{"š":[{},[0,2,3]]}],"s":[{"k":[{},[0,2,3]]}]}],"e":[{"p":[{},[0,2,3]],"t":[{},[0,2,3]],"ć":[{},[0,2,3]],"ž":[{},[0,2,3]],"g":[{},[0,2,3]],"d":[{"e":[{"n":[{},[0,2,3]]}]}]}],"i":[{"j":[{"e":[{"p":[{},[0,2,3]],"t":[{},[0,2,3]],"ž":[{},[0,2,3]],"g":[{},[0,2,3]]}]}],"v":[{},[0,2,3]],"z":[{"a":[{"t":[{},[0,2,3]],"v":[{},[0,2,3]]}],"i":[{},[0,2,3]]}],"s":[{"t":[{},[0,2,3]]}]}],"o":[{"k":[{"a":[{},[0,2,3]]}]}],"u":[{"k":[{},[0,2,3]],"č":[{},[0,2,3]]}]}],"r":[{"a":[{"ž":[{"e":[{},[0,3,4]]}],"z":[{"i":[{},[0,3,4]],"n":[{},[0,3,4]],"o":[{},[0,3,4]],"u":[{},[0,3,4]],"a":[{},[0,3,4]],"d":[{},[0,3,4]]}],"m":[{"b":[{},[0,3,4]]}],"n":[{"j":[{},[0,3,4]]},[0,3,4]],"t":[{},[0,3,4]],"ć":[{},[0,3,4]],"š":[{"n":[{},[0,3,4]],"č":[{},[0,3,4]]}]}],"v":[{},[0,3,4]],"đ":[{},[0,3,4]],"e":[{"m":[{},[0,3,4]],"s":[{},[0,3,4]],"đ":[{},[0,3,4]],"č":[{},[0,3,4]],"ž":[{},[0,3,4]],"c":[{},[0,3,4]],"d":[{},[0,3,4]],"t":[{"i":[{},[0,3,4]],"n":[{},[0,3,4]]}]}],"i":[{"j":[{},[0,3,4]],"s":[{},[0,3,4]],"t":[{},[0,3,4]],"v":[{},[0,3,4]],"č":[{},[0,3,4]],"c":[{},[0,3,4]]}],"k":[{},[0,3,4]],"l":[{"j":[{},[0,3,4]]},[0,3,4]],"n":[{},[0,3,4]],"s":[{},[0,3,4]],"t":[{},[0,3,4]],"š":[{},[0,3,4]],"č":[{},[0,3,4]],"o":[{"k":[{},[0,3,4]],"n":[{"j":[{},[0,3,4]]},[0,3,4]],"ć":[{},[0,3,4]],"č":[{},[0,3,4]],"v":[{"a":[{},[0,3,4]],"c":[{},[0,3,4]]}]}],"u":[{"k":[{},[0,3,4]],"n":[{"j":[{},[0,3,4]]},[0,3,4]],"s":[{},[0,3,4]],"š":[{},[0,3,4]],"č":[{},[0,3,4]]}]},[0,2,3]],"e":[{"z":[{"b":[{},[0,0,0,2,3]],"d":[{},[0,0,0,2,3]],"g":[{},[0,0,0,2,3]],"j":[{},[0,0,0,2,3]],"l":[{"j":[{},[0,0,0,2,3]]},[0,0,0,2,3]],"m":[{},[0,0,0,2,3]],"n":[{"a":[{"n":[{"j":[{},[0,0,0,3,4]]},[0,0,0,3,4]],"č":[{},[0,0,0,3,4]]}]},[0,0,0,2,3]],"o":[{},[0,0,0,2,3]],"r":[{},[0,0,0,2,3]],"u":[{"b":[{},[0,0,0,3,4]]},[0,0,0,2,3]],"v":[{"i":[{"j":[{},[0,0,0,3,4]]}]},[0,0,0,2,3]]}],"s":[{"c":[{},[0,0,0,2,3]],"k":[{},[0,0,0,2,3]],"p":[{},[0,0,0,2,3]],"t":[{"a":[{"n":[{},[0,0,0,3,4]]}],"i":[{"j":[{},[0,0,0,3,4]]}],"r":[{"a":[{"n":[{},[0,0,0,3,4]]}]}]},[0,0,0,2,3]]}],"š":[{"ć":[{},[0,0,0,2,3]],"č":[{},[0,0,0,2,3]]}]}],"i":[{"g":[{"r":[{},[0,2,3]]}],"s":[{"t":[{"i":[{"n":[{"j":[{},[0,2,3]]},[0,2,3]]}]}]}]}],"o":[{"r":[{"u":[{},[0,2,3]]}]}],"u":[{"b":[{"o":[{"ž":[{},[0,2,3]]}]}],"z":[{},[0,2,3]],"ž":[{},[0,2,3]],"d":[{},[0,2,3]],"m":[{"i":[{},[0,2,3]],"j":[{},[0,2,3]],"r":[{},[0,2,3]],"e":[{},[0,2,3]]}]}]}]}],"u":[{"g":[{"m":[{"i":[{},[0,3,2]]}],"n":[{},[0,3,2]]}],"z":[{"a":[{"t":[{"k":[{"a":[{},[0,0,0,3,2]]}]}]}],"b":[{"o":[{"r":[{},[0,3,4]]}]},[0,2,3]],"d":[{"i":[{"c":[{},[0,3,4]]}]},[0,2,3]],"g":[{},[0,2,3]],"i":[{"g":[{"r":[{},[0,2,3]]}],"n":[{"a":[{"t":[{},[0,2,3]]}]}],"s":[{"k":[{"r":[{},[0,2,3]]}]}]},[0,2,3]],"j":[{},[0,2,3]],"l":[{"j":[{},[0,2,3]],"a":[{"n":[{},[0,3,4]],"t":[{},[0,3,4]]}],"i":[{"m":[{},[0,3,4]],"t":[{},[0,3,4]],"ć":[{},[0,3,4]],"c":[{},[0,3,4]]}],"o":[{"v":[{},[0,3,4]]}],"u":[{"d":[{"o":[{"b":[{},[0,3,4]]}]}]}]},[0,2,3]],"m":[{},[0,2,3]],"n":[{"j":[{},[0,2,3]],"a":[{"k":[{},[0,3,4]],"č":[{},[0,3,4]]}],"e":[{"v":[{"e":[{},[0,3,4]],"j":[{"e":[{},[0,3,4]]}]}]}],"i":[{"č":[{},[0,3,4]],"c":[{},[0,3,4]]}],"o":[{"j":[{},[0,3,4]]}]},[0,2,3]],"r":[{"e":[{"t":[{},[0,3,4]],"v":[{},[0,3,4]]}],"i":[{"j":[{"e":[{"t":[{},[0,3,4]],"v":[{},[0,3,4]]}]}]}],"n":[{"j":[{},[0,3,4]]},[0,3,4]],"o":[{"k":[{"o":[{},[0,3,4]],"u":[{},[0,3,4]],"a":[{},[0,3,4]]}],"č":[{},[0,3,4]]}],"u":[{"j":[{},[0,3,4]]}]},[0,2,3]],"v":[{"a":[{"n":[{},[0,3,4]],"t":[{},[0,3,4]]}],"i":[{"ž":[{},[0,3,4]],"j":[{"o":[{},[0,3,4]],"u":[{},[0,3,4]],"a":[{},[0,3,4]],"e":[{},[0,3,4]]}]}],"o":[{"j":[{},[0,3,4]]}]},[0,2,3]],"o":[{"b":[{"e":[{"s":[{"t":[{},[0,2,3]]}]}],"i":[{"j":[{"e":[{"s":[{"t":[{},[0,2,3]]}]}]}]}]}],"r":[{"a":[{"t":[{},[0,2,3]],"v":[{},[0,2,3]]}]}],"h":[{"o":[{},[0,2,3]]}]}],"u":[{"g":[{"a":[{"r":[{},[0,2,3]]}]}]}]}],"s":[{"c":[{},[0,2,3]],"k":[{"a":[{"k":[{},[0,3,4]]}],"l":[{"a":[{"đ":[{},[0,3,4]],"d":[{},[0,3,4]]}]}],"o":[{"m":[{},[0,4,5]],"v":[{},[0,4,5]],"š":[{},[0,4,5]],"k":[{"o":[{},[0,4,5]]}],"l":[{"u":[{},[0,4,5]],"e":[{},[0,4,5]]}],"p":[{"a":[{},[0,4,5]]}],"r":[{"a":[{},[0,4,5]]}],"s":[{"i":[{},[0,4,5]]}],"t":[{"r":[{},[0,4,5]]}]},[0,3,4]],"u":[{"p":[{},[0,3,4]]}]},[0,2,3]],"p":[{"a":[{"v":[{},[0,3,4]],"l":[{"o":[{},[0,3,4]]}]}],"e":[{"h":[{},[0,3,4]],"l":[{},[0,3,4]],"m":[{},[0,3,4]],"t":[{},[0,3,4]],"v":[{},[0,3,4]],"š":[{},[0,3,4]],"n":[{"t":[{},[0,3,4]]}]}],"j":[{"e":[{"h":[{},[0,3,4]],"l":[{},[0,3,4]],"m":[{},[0,3,4]],"t":[{},[0,3,4]],"v":[{},[0,3,4]],"š":[{},[0,3,4]]}]}],"i":[{"j":[{"a":[{},[0,3,4]],"e":[{},[0,3,4]],"u":[{"š":[{},[0,3,4]]}]}],"k":[{"u":[{"š":[{},[0,3,4]]}]}]}],"o":[{"n":[{},[0,3,4]],"r":[{"i":[{},[0,3,4]],"a":[{},[0,3,4]],"e":[{"n":[{"j":[{},[0,3,4]]},[0,3,4]],"č":[{},[0,3,4]]}]}],"s":[{"o":[{"b":[{},[0,3,4]]}]}]}],"r":[{"e":[{"m":[{"i":[{},[0,3,4]],"a":[{},[0,3,4]]}]}]}]},[0,2,3]],"r":[{"k":[{},[0,3,4]],"n":[{},[0,3,4]],"p":[{},[0,3,4]],"l":[{"j":[{},[0,3,4]]}],"t":[{},[0,3,4]],"đ":[{},[0,3,4]],"ž":[{},[0,3,4]],"a":[{},[0,3,4]],"d":[{},[0,3,4]],"e":[{},[0,3,4]],"i":[{"j":[{"e":[{"d":[{},[0,3,4]]}]}]}]}],"t":[{"a":[{"l":[{"a":[{"s":[{},[0,2,3]]}]}],"r":[{"a":[{},[0,2,3]]}]}],"v":[{"r":[{"đ":[{},[0,2,3]],"d":[{},[0,2,3]]}]}],"e":[{"r":[{},[0,2,3]],"ć":[{},[0,2,3]],"g":[{},[0,2,3]]}],"o":[{"v":[{},[0,2,3]]}],"r":[{"a":[{"j":[{},[0,2,3]],"l":[{},[0,2,3]]}],"g":[{},[0,2,3]],"e":[{"p":[{},[0,2,3]],"s":[{},[0,2,3]],"b":[{},[0,2,3]]}],"k":[{},[0,2,3]],"n":[{},[0,2,3]],"p":[{},[0,2,3]],"ć":[{},[0,2,3]],"č":[{},[0,2,3]]}],"u":[{"m":[{},[0,2,3]],"r":[{},[0,2,3]],"ć":[{},[0,2,3]]}]}]}],"š":[{"ć":[{},[0,2,3]],"č":[{},[0,2,3]]}]}]}],"o":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[2,1]],"u":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[2,1]],"a":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[2,1]],"e":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[2,1]],"i":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[2,1]]}';
  var hyphenation = [
    "na-dno",
    "na-tka",
    "na-tka-ti",
    "na-tka-še",
    "o-dno",
    "o-tka",
    "o-tka-ti",
    "o-tka-še",
    "po-dno",
    "po-dne",
    "po-tki",
    "po-tku",
    "po-tka",
    "po-tke",
    "u-dno",
    "i-gde",
    "i-gdje",
    "svu-gde",
    "sve-gde",
    "svu-gdje",
    "sve-gdje",
    "po-ne-gde",
    "po-ne-gdje",
    "i-zbi",
    "i-zba",
    "i-zbe",
    "i-zbi-ci",
    "i-zbi-ca",
    "i-zbi-ce",
    "i-zvit",
    "i-zim",
    "izo-ba-ri",
    "izo-ba-ru",
    "izo-ba-ra",
    "izo-ba-re",
    "i-skok",
    "i-sko-ku",
    "i-sko-ka",
    "i-skon",
    "i-sko-ni",
    "i-sko-nu",
    "i-sko-na",
    "i-skri",
    "i-skru",
    "i-skra",
    "i-skre",
    "i-skrav",
    "i-spod",
    "i-spo-da",
    "i-stri",
    "i-stro",
    "i-stru",
    "i-stra",
    "i-stre",
    "na-ji",
    "na-jo",
    "na-ju",
    "na-ja",
    "na-je",
    "na-jam",
    "na-jest",
    "o-braz",
    "o-bret",
    "o-dvi-ka",
    "o-dran",
    "o-dra-ti",
    "pre-dvoj",
    "ra-zmi",
    "ra-zmo",
    "ra-zmu",
    "ra-zma",
    "ra-zme",
    "ra-zni",
    "ra-zno",
    "ra-znu",
    "ra-zna",
    "ra-zne",
    "ra-sklop",
    "ra-spe-lo",
    "ra-spe-lu",
    "ra-spe-la",
    "ra-spe-ću",
    "ra-spe-ća",
    "ra-spe-će",
    "ra-sti",
    "ra-stu",
    "ra-sta",
    "ra-ste",
    "ra-stom",
    "ra-ster",
    "ra-šći",
    "ra-šćo",
    "ra-šću",
    "ra-šća",
    "ra-šće",
    "u-zni",
    "u-zno",
    "u-zna",
    "u-znik",
    "u-zrok",
    "u-ski",
    "u-sko",
    "u-sku",
    "u-ska",
    "u-ske",
    "us-kos",
    "u-spio",
    "u-speo",
    "u-spor",
    "u-šću",
    "u-šća",
    "u-šće",
    "in-te-res",
    "tran-su",
    "tran-sa",
    "tran-som",
    ""
  ];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
