(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsTe = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"అ":[{},[0,1]],"ఆ":[{},[0,1]],"ఇ":[{},[0,1]],"ఈ":[{},[0,1]],"ఉ":[{},[0,1]],"ఊ":[{},[0,1]],"ఋ":[{},[0,1]],"ౠ":[{},[0,1]],"ఌ":[{},[0,1]],"ౡ":[{},[0,1]],"ఎ":[{},[0,1]],"ఏ":[{},[0,1]],"ఐ":[{},[0,1]],"ఒ":[{},[0,1]],"ఓ":[{},[0,1]],"ఔ":[{},[0,1]],"ా":[{},[0,1]],"ి":[{},[0,1]],"ీ":[{},[0,1]],"ు":[{},[0,1]],"ూ":[{},[0,1]],"ృ":[{},[0,1]],"ౄ":[{},[0,1]],"ె":[{},[0,1]],"ే":[{},[0,1]],"ై":[{},[0,1]],"ొ":[{},[0,1]],"ో":[{},[0,1]],"ౌ":[{},[0,1]],"క":[{},[1]],"ఖ":[{},[1]],"గ":[{},[1]],"ఘ":[{},[1]],"ఙ":[{},[1]],"చ":[{},[1]],"ఛ":[{},[1]],"జ":[{},[1]],"ఝ":[{},[1]],"ఞ":[{},[1]],"ట":[{},[1]],"ఠ":[{},[1]],"డ":[{},[1]],"ఢ":[{},[1]],"ణ":[{},[1]],"త":[{},[1]],"థ":[{},[1]],"ద":[{},[1]],"ధ":[{},[1]],"న":[{},[1]],"ప":[{},[1]],"ఫ":[{},[1]],"బ":[{},[1]],"భ":[{},[1]],"మ":[{},[1]],"య":[{},[1]],"ర":[{},[1]],"ఱ":[{},[1]],"ల":[{},[1]],"ళ":[{},[1]],"వ":[{},[1]],"శ":[{},[1]],"ష":[{},[1]],"స":[{},[1]],"హ":[{},[1]],"ఁ":[{},[2,1]],"ం":[{},[2,1]],"ః":[{},[2,1]],"ౕ":[{},[2,1]],"ౖ":[{},[2,1]],"్":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
