export declare const VACCINE_CATEGORIES: {
    ROUTINE: string;
    CATCHUP: string;
    CAMPAIGN: string;
    OTHER: string;
};
export declare const VACCINE_CATEGORY_LABELS: {
    [x: string]: string;
};
export declare const VACCINE_CATEGORY_OPTIONS: {
    value: string;
    label: string;
}[];
export declare const VACCINE_CATEGORIES_VALUES: string[];
export declare const INJECTION_SITE_VALUES: {
    LEFT_ARM: string;
    RIGHT_ARM: string;
    LEFT_THIGH: string;
    RIGHT_THIGH: string;
    ORAL: string;
    OTHER: string;
};
export declare const INJECTION_SITE_LABELS: {
    [x: string]: string;
};
export declare const ICAO_DOCUMENT_TYPES: {
    PROOF_OF_TESTING: {
        DOCTYPE: string;
        JSON: string;
    };
    PROOF_OF_VACCINATION: {
        DOCTYPE: string;
        JSON: string;
    };
};
export declare const COVID_19_CLEARANCE_CERTIFICATE = "covid_19_clearance";
export declare const VACCINATION_CERTIFICATE = "vaccination_certificate";
export declare const EUDCC_CERTIFICATE_TYPES: {
    VACCINATION: string;
    TEST: string;
    RECOVERY: string;
};
export declare const EUDCC_SCHEMA_VERSION = "1.3.0";
export declare const X502_OIDS: {
    COMMON_NAME: string;
    COUNTRY_NAME: string;
    BASIC_CONSTRAINTS: string;
    KEY_USAGE: string;
    PRIVATE_KEY_USAGE_PERIOD: string;
    EXTENDED_KEY_USAGE: string;
    KEY_IDENTIFIER: string;
    AUTHORITY_KEY_IDENTIFIER: string;
    DOCUMENT_TYPE: string;
    EKU_VDS_NC: string;
    EKU_EU_DCC_TEST: string;
    EKU_EU_DCC_VACCINATION: string;
    EKU_EU_DCC_RECOVERY: string;
};
export declare const CERTIFICATE_NOTIFICATION_STATUSES: {
    QUEUED: string;
    PROCESSED: string;
    ERROR: string;
    IGNORE: string;
};
export declare const VACCINE_STATUS: {
    UNKNOWN: string;
    GIVEN: string;
    NOT_GIVEN: string;
    SCHEDULED: string;
    MISSED: string;
    DUE: string;
    UPCOMING: string;
    OVERDUE: string;
    RECORDED_IN_ERROR: string;
    HISTORICAL: string;
};
export declare const VACCINE_STATUS_LABELS: {
    [x: string]: string;
};
export declare const VACCINE_RECORDING_TYPES: {
    GIVEN: string;
    NOT_GIVEN: string;
};
