/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_SETTINGS = {
    'invoice.slidingFeeScale': JSON.stringify([
        [
            0,
            5700,
            10050,
            12600,
            14100,
            17500
        ],
        [
            0,
            6600,
            13500,
            16300,
            19000,
            21800
        ],
        [
            0,
            7400,
            17000,
            20500,
            23900,
            27500
        ],
        [
            0,
            8500,
            20600,
            24800,
            28900,
            32500
        ],
        [
            0,
            9700,
            24200,
            29000,
            33800,
            38700
        ],
        [
            0,
            10700,
            27700,
            33200,
            37500,
            43000
        ],
        [
            0,
            11500,
            31200,
            37400,
            43700,
            46000
        ],
        [
            0,
            12600,
            34700,
            41600,
            48600,
            55600
        ],
        [
            0,
            14800,
            38300,
            45900,
            53600,
            65000
        ],
        [
            0,
            16600,
            41800,
            50200,
            58500,
            70000
        ],
        [
            0,
            18900,
            45300,
            54400,
            63400,
            75000
        ],
        [
            0,
            23500,
            48800,
            58600,
            68400,
            85000
        ]
    ])
};
async function up(query) {
    if (_config.default.serverFacilityId) return;
    await query.bulkInsert('settings', Object.entries(DEFAULT_SETTINGS).map(([key, value])=>({
            key,
            value
        })));
}
async function down(query) {
    if (_config.default.serverFacilityId) return;
    await query.bulkDelete('settings', {
        key: {
            [_sequelize.Op.in]: Object.keys(DEFAULT_SETTINGS)
        }
    });
}

//# sourceMappingURL=1717088025227-addInvoiceSlidingFeeScaleConfigSetting.js.map