"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientVRSData", {
    enumerable: true,
    get: function() {
        return PatientVRSData;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let PatientVRSData = class PatientVRSData extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            idType: _sequelize.Sequelize.STRING,
            identifier: _sequelize.Sequelize.STRING,
            // if we don't have a matching village, persist the unmatched name here
            unmatchedVillageName: _sequelize.Sequelize.STRING,
            isDeletedByRemote: {
                type: _sequelize.Sequelize.BOOLEAN,
                defaultValue: false,
                allowNull: false
            }
        }, {
            ...options,
            tableName: 'patient_vrs_data',
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
    }
};

//# sourceMappingURL=PatientVRSData.js.map