"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dateTimeType: function() {
        return dateTimeType;
    },
    dateType: function() {
        return dateType;
    }
});
const _sequelize = require("sequelize");
const _dateTime = require("../utils/dateTime");
function dateTimeType(fieldName, config = {}) {
    return {
        type: _sequelize.DataTypes.DATETIMESTRING,
        set (value) {
            this.setDataValue(fieldName, (0, _dateTime.toDateTimeString)(value));
        },
        ...config
    };
}
function dateType(fieldName, config = {}) {
    return {
        type: _sequelize.DataTypes.DATESTRING,
        set (value) {
            this.setDataValue(fieldName, (0, _dateTime.toDateString)(value));
        },
        ...config
    };
}

//# sourceMappingURL=dateTimeTypes.js.map