"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CovidVaccineCertificate", {
    enumerable: true,
    get: function() {
        return CovidVaccineCertificate;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _uvci = require("../uvci");
const _Table = require("./Table");
const _Layout = require("./Layout");
const _CovidPatientDetailsSection = require("./CovidPatientDetailsSection");
const _SigningSection = require("./SigningSection");
const _Typography = require("./Typography");
const _CovidLetterheadSection = require("./CovidLetterheadSection");
const _getDisplayDate = require("./getDisplayDate");
const _dateTime = require("../dateTime");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const columns = [
    {
        key: 'vaccine',
        title: 'Vaccine',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ scheduledVaccine })=>(scheduledVaccine || {}).label
    },
    {
        key: 'vaccineBrand',
        title: 'Vaccine brand',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ scheduledVaccine })=>((scheduledVaccine || {}).vaccine || {}).name
    },
    {
        key: 'schedule',
        title: 'Schedule',
        accessor: ({ scheduledVaccine })=>(scheduledVaccine || {}).doseLabel
    },
    {
        key: 'countryName',
        title: 'Country',
        accessor: ({ countryName })=>countryName
    },
    {
        key: 'healthFacility',
        title: 'Health facility',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ healthFacility })=>healthFacility
    },
    {
        key: 'date',
        title: 'Date',
        accessor: ({ date }, getLocalisation)=>date ? (0, _getDisplayDate.getDisplayDate)(date, undefined, getLocalisation) : 'Unknown'
    },
    {
        key: 'batch',
        title: 'Batch number',
        accessor: ({ batch })=>batch
    }
];
const CovidVaccineCertificateComponent = ({ patient, printedBy, vaccinations, certificateId, signingSrc, watermarkSrc, vdsSrc, logoSrc, uvci, getLocalisation, extraPatientFields, printedDate })=>{
    const contactEmail = getLocalisation('templates.vaccineCertificate.emailAddress');
    const contactNumber = getLocalisation('templates.vaccineCertificate.contactNumber');
    const healthFacility = getLocalisation('templates.vaccineCertificate.healthFacility');
    const countryCode = getLocalisation('country.alpha-2');
    const countryName = getLocalisation('country.name');
    const uvciFormat = getLocalisation('previewUvciFormat');
    const data = vaccinations.map((vaccination)=>({
            ...vaccination,
            countryName,
            healthFacility
        }));
    const vaxes = vaccinations.filter((v)=>v.certifiable).sort((0, _dateTime.compareDateStrings)('desc'));
    const actualUvci = vaccinations.length ? uvci || (0, _uvci.generateUVCI)((vaxes[0] || {}).id, {
        format: uvciFormat,
        countryCode
    }) : null;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, watermarkSrc && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermarkSrc
    }), /*#__PURE__*/ _react.default.createElement(_CovidLetterheadSection.CovidLetterheadSection, {
        getLocalisation: getLocalisation,
        logoSrc: logoSrc
    }), /*#__PURE__*/ _react.default.createElement(_Typography.H3, null, "COVID-19 Vaccine Certificate"), /*#__PURE__*/ _react.default.createElement(_CovidPatientDetailsSection.CovidPatientDetailsSection, {
        patient: patient,
        vdsSrc: vdsSrc,
        getLocalisation: getLocalisation,
        certificateId: certificateId,
        extraFields: extraPatientFields,
        uvci: actualUvci
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 20
    }, /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        data: data,
        columns: columns,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Box, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Printed by: ", printedBy)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Printing date: ", (0, _getDisplayDate.getDisplayDate)(printedDate))))), /*#__PURE__*/ _react.default.createElement(_SigningSection.SigningSection, {
        signingSrc: signingSrc
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Box, null, contactEmail ? /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Email address: ", contactEmail) : null, contactNumber ? /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Contact number: ", contactNumber) : null)));
};
const CovidVaccineCertificate = (0, _languageContext.withLanguageContext)(CovidVaccineCertificateComponent);

//# sourceMappingURL=CovidVaccineCertificate.js.map