import React from 'react';
import { CertificateLogo } from './Layout';
import { CertificateAddress, CertificateTitle } from './Typography';
export const LetterheadSection = ({ getLocalisation, logoSrc, certificateTitle, letterheadConfig })=>{
    // Give priority to letterheadConfig which is extracted from settings
    const title = letterheadConfig?.title ?? getLocalisation('templates.letterhead.title');
    const subTitle = letterheadConfig?.subTitle ?? getLocalisation('templates.letterhead.subTitle');
    return /*#__PURE__*/ React.createElement(React.Fragment, null, logoSrc && /*#__PURE__*/ React.createElement(CertificateLogo, {
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(CertificateAddress, null, `${title}\n${subTitle}`), /*#__PURE__*/ React.createElement(CertificateTitle, null, certificateTitle));
};

//# sourceMappingURL=LetterheadSection.js.map