(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsSa = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[2,2]],"a":[{"̄":[{},[0,0,1]],"i":[{"̈":[{},[0,3,0,1]]},[0,2,1]],"u":[{"̈":[{},[0,3,0,1]]},[0,2,1]],"í":[{},[0,2,1]],"ì":[{},[0,2,1]],"ú":[{},[0,2,1]],"ù":[{},[0,2,1]],"ï":[{},[0,3,1]],"ü":[{},[0,3,1]]},[0,1]],"i":[{"̈":[{},[0,0,1]],"̄":[{},[0,0,1]]},[0,1]],"u":[{"̈":[{},[0,0,1]],"̄":[{},[0,0,1]]},[0,1]],"r":[{"̥":[{"̄":[{},[0,0,0,1]]},[0,0,1]],"̣":[{"̄":[{},[0,0,0,1]]},[0,0,1]],".":[{},[2]],"k":[{".":[{},[2]]}],"g":[{".":[{},[2]]}],"t":[{"̣":[{".":[{},[2]]}],".":[{},[2]]}],"d":[{"̣":[{".":[{},[2]]}],".":[{},[2]]}],"p":[{".":[{},[2]]}],"b":[{".":[{},[2]]}],"ṭ":[{".":[{},[2]]}],"ḍ":[{".":[{},[2]]}]}],"l":[{"̥":[{"̄":[{},[0,0,0,1]]},[0,0,1]],"̣":[{"̄":[{},[0,0,0,1]],".":[{},[2]]},[0,0,1]],".":[{},[2]]}],"e":[{},[0,1]],"o":[{},[0,1]],"k":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"g":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"n":[{"̇":[{".":[{},[2]]}],"̃":[{".":[{},[2]]}],"̣":[{".":[{},[2]]}],".":[{},[2]]}],"c":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"j":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"t":[{"̣":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],".":[{},[2]],"h":[{".":[{},[2]]}]}],"d":[{"̣":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],".":[{},[2]],"h":[{".":[{},[2]]}]}],"p":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"b":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"m":[{".":[{},[2]],"̣":[{},[2,0,1]],"̇":[{},[2,0,1]],"̐":[{},[2,0,1]]}],"y":[{".":[{},[2]]}],"v":[{".":[{},[2]]}],"s":[{"́":[{".":[{},[2]]}],"̣":[{".":[{},[2]]}],".":[{},[2]]}],"h":[{".":[{},[2]],"̣":[{},[2,0,1]],"̱":[{},[2,0,1]],"̮":[{},[2,0,1]]}],"̮":[{},[2]],"̐":[{},[2]],"̄":[{},[2]],"̱":[{},[2,1]],"́":[{},[2,1]],"̀":[{},[2,1]],"̈":[{},[2]],"á":[{},[0,1]],"à":[{},[0,1]],"ā":[{},[0,1]],"í":[{},[0,1]],"ì":[{},[0,1]],"ï":[{},[0,1]],"ī":[{},[0,1]],"ú":[{},[0,1]],"ù":[{},[0,1]],"ü":[{},[0,1]],"ū":[{},[0,1]],"é":[{},[0,1]],"è":[{},[0,1]],"ó":[{},[0,1]],"ò":[{},[0,1]],"ṅ":[{".":[{},[2]]}],"ñ":[{".":[{},[2]]}],"ṭ":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"ḍ":[{".":[{},[2]],"h":[{".":[{},[2]]}]}],"ṇ":[{".":[{},[2]]}],"ḷ":[{".":[{},[2]]}],"ś":[{".":[{},[2]]}],"ṣ":[{".":[{},[2]]}],"ṃ":[{},[2,1]],"ṁ":[{},[2,1]],"ḥ":[{},[2,1]],"ẖ":[{},[2,1]],"ḫ":[{},[2,1]],"अ":[{},[1,1]],"आ":[{},[1,1]],"इ":[{},[1,1]],"ई":[{},[1,1]],"उ":[{},[1,1]],"ऊ":[{},[1,1]],"ऋ":[{},[1,1]],"ॠ":[{},[1,1]],"ऌ":[{},[1,1]],"ॡ":[{},[1,1]],"ए":[{},[1,1]],"ऐ":[{},[1,1]],"ओ":[{},[1,1]],"औ":[{},[1,1]],"ा":[{},[2,1]],"ि":[{},[2,1]],"ी":[{},[2,1]],"ु":[{},[2,1]],"ू":[{},[2,1]],"ृ":[{},[2,1]],"ॄ":[{},[2,1]],"ॢ":[{},[2,1]],"ॣ":[{},[2,1]],"े":[{},[2,1]],"ै":[{},[2,1]],"ो":[{},[2,1]],"ौ":[{},[2,1]],"क":[{"्":[{".":[{},[2]]}]},[1,1]],"ख":[{"्":[{".":[{},[2]]}]},[1,1]],"ग":[{"्":[{".":[{},[2]]}]},[1,1]],"घ":[{"्":[{".":[{},[2]]}]},[1,1]],"ङ":[{"्":[{".":[{},[2]]}]},[1,1]],"च":[{"्":[{".":[{},[2]]}]},[1,1]],"छ":[{"्":[{".":[{},[2]]}]},[1,1]],"ज":[{"्":[{".":[{},[2]]}]},[1,1]],"झ":[{"्":[{".":[{},[2]]}]},[1,1]],"ञ":[{"्":[{".":[{},[2]]}]},[1,1]],"ट":[{"्":[{".":[{},[2]]}]},[1,1]],"ठ":[{"्":[{".":[{},[2]]}]},[1,1]],"ड":[{"्":[{".":[{},[2]]}]},[1,1]],"ढ":[{"्":[{".":[{},[2]]}]},[1,1]],"ण":[{"्":[{".":[{},[2]]}]},[1,1]],"त":[{"्":[{".":[{},[2]]}]},[1,1]],"थ":[{"्":[{".":[{},[2]]}]},[1,1]],"द":[{"्":[{".":[{},[2]]}]},[1,1]],"ध":[{"्":[{".":[{},[2]]}]},[1,1]],"न":[{"्":[{".":[{},[2]]}]},[1,1]],"प":[{"्":[{".":[{},[2]]}]},[1,1]],"फ":[{"्":[{".":[{},[2]]}]},[1,1]],"ब":[{"्":[{".":[{},[2]]}]},[1,1]],"भ":[{"्":[{".":[{},[2]]}]},[1,1]],"म":[{"्":[{".":[{},[2]]}]},[1,1]],"य":[{"्":[{".":[{},[2]]}]},[1,1]],"र":[{"्":[{".":[{},[2]],"क":[{"्":[{".":[{},[2]]}]}],"ट":[{"्":[{".":[{},[2]]}]}],"त":[{"्":[{".":[{},[2]]}]}],"प":[{"्":[{".":[{},[2]]}]}]}]},[1,1]],"ल":[{"्":[{".":[{},[2]]}]},[1,1]],"ळ":[{"्":[{".":[{},[2]]}]},[1,1]],"व":[{"्":[{".":[{},[2]]}]},[1,1]],"श":[{"्":[{".":[{},[2]]}]},[1,1]],"ष":[{"्":[{".":[{},[2]]}]},[1,1]],"स":[{"्":[{".":[{},[2]]}]},[1,1]],"ह":[{"्":[{".":[{},[2]]}]},[1,1]],"ँ":[{},[2]],"ं":[{},[2]],"ः":[{},[2]],"ऽ":[{},[2,2]],"॑":[{},[2]],"॒":[{},[2]],"्":[{},[2,2]],"অ":[{},[1,1]],"আ":[{},[1,1]],"ই":[{},[1,1]],"ঈ":[{},[1,1]],"উ":[{},[1,1]],"ঊ":[{},[1,1]],"ঋ":[{},[1,1]],"ৠ":[{},[1,1]],"ঌ":[{},[1,1]],"ৡ":[{},[1,1]],"এ":[{},[1,1]],"ঐ":[{},[1,1]],"ও":[{},[1,1]],"ঔ":[{},[1,1]],"া":[{},[2,1]],"ি":[{},[2,1]],"ী":[{},[2,1]],"ু":[{},[2,1]],"ূ":[{},[2,1]],"ৃ":[{},[2,1]],"ৄ":[{},[2,1]],"ৢ":[{},[2,1]],"ৣ":[{},[2,1]],"ে":[{},[2,1]],"ৈ":[{},[2,1]],"ো":[{},[2,1]],"ৌ":[{},[2,1]],"ক":[{"্":[{".":[{},[2]]}]},[1,1]],"খ":[{"্":[{".":[{},[2]]}]},[1,1]],"গ":[{"্":[{".":[{},[2]]}]},[1,1]],"ঘ":[{"্":[{".":[{},[2]]}]},[1,1]],"ঙ":[{"্":[{".":[{},[2]]}]},[1,1]],"চ":[{"্":[{".":[{},[2]]}]},[1,1]],"ছ":[{"্":[{".":[{},[2]]}]},[1,1]],"জ":[{"্":[{".":[{},[2]]}]},[1,1]],"ঝ":[{"্":[{".":[{},[2]]}]},[1,1]],"ঞ":[{"্":[{".":[{},[2]]}]},[1,1]],"ট":[{"্":[{".":[{},[2]]}]},[1,1]],"ঠ":[{"্":[{".":[{},[2]]}]},[1,1]],"ড":[{"্":[{".":[{},[2]]}]},[1,1]],"ড়":[{"্":[{".":[{},[2]]}]},[1,1]],"ঢ":[{"্":[{".":[{},[2]]}]},[1,1]],"ঢ়":[{"্":[{".":[{},[2]]}]},[1,1]],"ণ":[{"্":[{".":[{},[2]]}]},[1,1]],"ত":[{"্":[{".":[{},[2]]}]},[1,1]],"থ":[{"্":[{".":[{},[2]]}]},[1,1]],"দ":[{"্":[{".":[{},[2]]}]},[1,1]],"ধ":[{"্":[{".":[{},[2]]}]},[1,1]],"ন":[{"্":[{".":[{},[2]]}]},[1,1]],"প":[{"্":[{".":[{},[2]]}]},[1,1]],"ফ":[{"্":[{".":[{},[2]]}]},[1,1]],"ব":[{"্":[{".":[{},[2]]}]},[1,1]],"ভ":[{"্":[{".":[{},[2]]}]},[1,1]],"ম":[{"্":[{".":[{},[2]]}]},[1,1]],"য":[{"্":[{".":[{},[2]]}]},[1,1]],"য়":[{"্":[{".":[{},[2]]}]},[1,1]],"র":[{"্":[{".":[{},[2]],"ক":[{".":[{},[2]]}],"ট":[{".":[{},[2]]}],"ত":[{".":[{},[2]]}],"প":[{".":[{},[2]]}]}]},[1,1]],"ল":[{"্":[{".":[{},[2]]}]},[1,1]],"শ":[{"্":[{".":[{},[2]]}]},[1,1]],"ষ":[{"্":[{".":[{},[2]]}]},[1,1]],"স":[{"্":[{".":[{},[2]]}]},[1,1]],"হ":[{"্":[{".":[{},[2]]}]},[1,1]],"ৎ":[{},[1,2]],"ঁ":[{},[2]],"ং":[{},[2]],"ঃ":[{},[2]],"ঽ":[{},[2,2]],"়":[{},[2]],"ৗ":[{},[2]],"্":[{},[2,2]],"અ":[{},[1,1]],"આ":[{},[1,1]],"ઇ":[{},[1,1]],"ઈ":[{},[1,1]],"ઉ":[{},[1,1]],"ઊ":[{},[1,1]],"ઋ":[{},[1,1]],"ૠ":[{},[1,1]],"ઌ":[{},[1,1]],"ૡ":[{},[1,1]],"એ":[{},[1,1]],"ઐ":[{},[1,1]],"ઓ":[{},[1,1]],"ઔ":[{},[1,1]],"ા":[{},[2,1]],"િ":[{},[2,1]],"ી":[{},[2,1]],"ુ":[{},[2,1]],"ૂ":[{},[2,1]],"ૃ":[{},[2,1]],"ૄ":[{},[2,1]],"ૢ":[{},[2,1]],"ૣ":[{},[2,1]],"ે":[{},[2,1]],"ૈ":[{},[2,1]],"ો":[{},[2,1]],"ૌ":[{},[2,1]],"ક":[{"્":[{".":[{},[2]]}]},[1,1]],"ખ":[{"્":[{".":[{},[2]]}]},[1,1]],"ગ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઘ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઙ":[{"્":[{".":[{},[2]]}]},[1,1]],"ચ":[{"્":[{".":[{},[2]]}]},[1,1]],"છ":[{"્":[{".":[{},[2]]}]},[1,1]],"જ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઝ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઞ":[{"્":[{".":[{},[2]]}]},[1,1]],"ટ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઠ":[{"્":[{".":[{},[2]]}]},[1,1]],"ડ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઢ":[{"્":[{".":[{},[2]]}]},[1,1]],"ણ":[{"્":[{".":[{},[2]]}]},[1,1]],"ત":[{"્":[{".":[{},[2]]}]},[1,1]],"થ":[{"્":[{".":[{},[2]]}]},[1,1]],"દ":[{"્":[{".":[{},[2]]}]},[1,1]],"ધ":[{"્":[{".":[{},[2]]}]},[1,1]],"ન":[{"્":[{".":[{},[2]]}]},[1,1]],"પ":[{"્":[{".":[{},[2]]}]},[1,1]],"ફ":[{"્":[{".":[{},[2]]}]},[1,1]],"બ":[{"્":[{".":[{},[2]]}]},[1,1]],"ભ":[{"્":[{".":[{},[2]]}]},[1,1]],"મ":[{"્":[{".":[{},[2]]}]},[1,1]],"ય":[{"્":[{".":[{},[2]]}]},[1,1]],"ર":[{"્":[{".":[{},[2]],"ક":[{".":[{},[2]]}],"ટ":[{".":[{},[2]]}],"ત":[{".":[{},[2]]}],"પ":[{".":[{},[2]]}]}]},[1,1]],"લ":[{"્":[{".":[{},[2]]}]},[1,1]],"ળ":[{"્":[{".":[{},[2]]}]},[1,1]],"વ":[{"્":[{".":[{},[2]]}]},[1,1]],"શ":[{"્":[{".":[{},[2]]}]},[1,1]],"ષ":[{"્":[{".":[{},[2]]}]},[1,1]],"સ":[{"્":[{".":[{},[2]]}]},[1,1]],"હ":[{"્":[{".":[{},[2]]}]},[1,1]],"ઁ":[{},[2]],"ં":[{},[2]],"ઃ":[{},[2]],"ઽ":[{},[2,2]],"્":[{},[2,2]],"ಅ":[{},[1,1]],"ಆ":[{},[1,1]],"ಇ":[{},[1,1]],"ಈ":[{},[1,1]],"ಉ":[{},[1,1]],"ಊ":[{},[1,1]],"ಋ":[{},[1,1]],"ೠ":[{},[1,1]],"ಌ":[{},[1,1]],"ೡ":[{},[1,1]],"ಎ":[{},[1,1]],"ಏ":[{},[1,1]],"ಐ":[{},[1,1]],"ಒ":[{},[1,1]],"ಓ":[{},[1,1]],"ಔ":[{},[1,1]],"ಾ":[{},[2,1]],"ಿ":[{},[2,1]],"ೀ":[{},[2,1]],"ು":[{},[2,1]],"ೂ":[{},[2,1]],"ೃ":[{},[2,1]],"ೄ":[{},[2,1]],"ೆ":[{},[2,1]],"ೇ":[{},[2,1]],"ೈ":[{},[2,1]],"ೊ":[{},[2,1]],"ೋ":[{},[2,1]],"ೌ":[{},[2,1]],"ಕ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಖ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಗ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಘ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಙ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಚ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಛ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಜ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಝ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಞ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಟ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಠ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಡ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಢ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಣ":[{"್":[{".":[{},[2]]}]},[1,1]],"ತ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಥ":[{"್":[{".":[{},[2]]}]},[1,1]],"ದ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಧ":[{"್":[{".":[{},[2]]}]},[1,1]],"ನ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಪ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಫ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಬ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಭ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಮ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಯ":[{"್":[{".":[{},[2]]}]},[1,1]],"ರ":[{"್":[{".":[{},[2]],"ಕ":[{".":[{},[2]]}],"ಟ":[{".":[{},[2]]}],"ತ":[{".":[{},[2]]}],"ಪ":[{".":[{},[2]]}]}]},[1,1]],"ಱ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಲ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಳ":[{"್":[{".":[{},[2]]}]},[1,1]],"ೞ":[{},[1,1]],"ವ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಶ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಷ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಸ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಹ":[{"್":[{".":[{},[2]]}]},[1,1]],"ಂ":[{},[2]],"ಃ":[{},[2]],"ೱ":[{},[2]],"ೲ":[{},[2]],"ಽ":[{},[2,2]],"ೕ":[{},[2]],"ೖ":[{},[2]],"್":[{},[2,2]],"അ":[{},[1,1]],"ആ":[{},[1,1]],"ഇ":[{},[1,1]],"ഈ":[{},[1,1]],"ഉ":[{},[1,1]],"ഊ":[{},[1,1]],"ഋ":[{},[1,1]],"ൠ":[{},[1,1]],"ഌ":[{},[1,1]],"ൡ":[{},[1,1]],"എ":[{},[1,1]],"ഏ":[{},[1,1]],"ഐ":[{},[1,1]],"ഒ":[{},[1,1]],"ഓ":[{},[1,1]],"ഔ":[{},[1,1]],"ാ":[{},[2,1]],"ി":[{},[2,1]],"ീ":[{},[2,1]],"ു":[{},[2,1]],"ൂ":[{},[2,1]],"ൃ":[{},[2,1]],"െ":[{},[2,1]],"േ":[{},[2,1]],"ൈ":[{},[2,1]],"ൊ":[{},[2,1]],"ോ":[{},[2,1]],"ൌ":[{},[2,1]],"ക":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"ഖ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഗ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഘ":[{"്":[{".":[{},[2]]}]},[1,1]],"ങ":[{"്":[{".":[{},[2]]}]},[1,1]],"ച":[{"്":[{".":[{},[2]]}]},[1,1]],"ഛ":[{"്":[{".":[{},[2]]}]},[1,1]],"ജ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഝ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഞ":[{"്":[{".":[{},[2]]}]},[1,1]],"ട":[{"്":[{".":[{},[2]]}]},[1,1]],"ഠ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഡ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഢ":[{"്":[{".":[{},[2]]}]},[1,1]],"ണ":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"ത":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"ഥ":[{"്":[{".":[{},[2]]}]},[1,1]],"ദ":[{"്":[{".":[{},[2]]}]},[1,1]],"ധ":[{"്":[{".":[{},[2]]}]},[1,1]],"ന":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"പ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഫ":[{"്":[{".":[{},[2]]}]},[1,1]],"ബ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഭ":[{"്":[{".":[{},[2]]}]},[1,1]],"മ":[{"്":[{".":[{},[2]]}]},[1,1]],"യ":[{"്":[{".":[{},[2]]}]},[1,1]],"ര":[{"്":[{".":[{},[2]],"ക":[{".":[{},[2]]}],"ട":[{".":[{},[2]]}],"ത":[{".":[{},[2]]}],"പ":[{".":[{},[2]]}],"‍":[{},[2,0,0,1]]}]},[1,1]],"റ":[{"്":[{".":[{},[2]]}]},[1,1]],"ല":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"ള":[{"്":[{".":[{},[2]],"‍":[{},[2,0,0,1]]}]},[1,1]],"ഴ":[{"്":[{".":[{},[2]]}]},[1,1]],"വ":[{"്":[{".":[{},[2]]}]},[1,1]],"ശ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഷ":[{"്":[{".":[{},[2]]}]},[1,1]],"സ":[{"്":[{".":[{},[2]]}]},[1,1]],"ഹ":[{"്":[{".":[{},[2]]}]},[1,1]],"ൺ":[{},[2,1]],"ൻ":[{},[2,1]],"ർ":[{},[2,1]],"ൽ":[{},[2,1]],"ൾ":[{},[2,1]],"ൿ":[{},[2,1]],"ം":[{},[2]],"ഃ":[{},[2]],"ൗ":[{},[2]],"്":[{},[2,2]],"అ":[{},[1,1]],"ఆ":[{},[1,1]],"ఇ":[{},[1,1]],"ఈ":[{},[1,1]],"ఉ":[{},[1,1]],"ఊ":[{},[1,1]],"ఋ":[{},[1,1]],"ౠ":[{},[1,1]],"ఌ":[{},[1,1]],"ౡ":[{},[1,1]],"ఎ":[{},[1,1]],"ఏ":[{},[1,1]],"ఐ":[{},[1,1]],"ఒ":[{},[1,1]],"ఓ":[{},[1,1]],"ఔ":[{},[1,1]],"ా":[{},[2,1]],"ి":[{},[2,1]],"ీ":[{},[2,1]],"ు":[{},[2,1]],"ూ":[{},[2,1]],"ృ":[{},[2,1]],"ౄ":[{},[2,1]],"ె":[{},[2,1]],"ే":[{},[2,1]],"ై":[{},[2,1]],"ొ":[{},[2,1]],"ో":[{},[2,1]],"ౌ":[{},[2,1]],"క":[{"్":[{".":[{},[2]]}]},[1,1]],"ఖ":[{"్":[{".":[{},[2]]}]},[1,1]],"గ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఘ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఙ":[{"్":[{".":[{},[2]]}]},[1,1]],"చ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఛ":[{"్":[{".":[{},[2]]}]},[1,1]],"జ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఝ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఞ":[{"్":[{".":[{},[2]]}]},[1,1]],"ట":[{"్":[{".":[{},[2]]}]},[1,1]],"ఠ":[{"్":[{".":[{},[2]]}]},[1,1]],"డ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఢ":[{"్":[{".":[{},[2]]}]},[1,1]],"ణ":[{"్":[{".":[{},[2]]}]},[1,1]],"త":[{"్":[{".":[{},[2]]}]},[1,1]],"థ":[{"్":[{".":[{},[2]]}]},[1,1]],"ద":[{"్":[{".":[{},[2]]}]},[1,1]],"ధ":[{"్":[{".":[{},[2]]}]},[1,1]],"న":[{"్":[{".":[{},[2]]}]},[1,1]],"ప":[{"్":[{".":[{},[2]]}]},[1,1]],"ఫ":[{"్":[{".":[{},[2]]}]},[1,1]],"బ":[{"్":[{".":[{},[2]]}]},[1,1]],"భ":[{"్":[{".":[{},[2]]}]},[1,1]],"మ":[{"్":[{".":[{},[2]]}]},[1,1]],"య":[{"్":[{".":[{},[2]]}]},[1,1]],"ర":[{"్":[{".":[{},[2]],"క":[{"్":[{".":[{},[2]]}]}],"ట":[{"్":[{".":[{},[2]]}]}],"త":[{"్":[{".":[{},[2]]}]}],"ప":[{"్":[{".":[{},[2]]}]}]}]},[1,1]],"ఱ":[{"్":[{".":[{},[2]]}]},[1,1]],"ల":[{"్":[{".":[{},[2]]}]},[1,1]],"ళ":[{"్":[{".":[{},[2]]}]},[1,1]],"వ":[{"్":[{".":[{},[2]]}]},[1,1]],"శ":[{"్":[{".":[{},[2]]}]},[1,1]],"ష":[{"్":[{".":[{},[2]]}]},[1,1]],"స":[{"్":[{".":[{},[2]]}]},[1,1]],"హ":[{"్":[{".":[{},[2]]}]},[1,1]],"ఁ":[{},[2]],"ం":[{},[2]],"ః":[{},[2]],"ౕ":[{},[2]],"ౖ":[{},[2]],"్":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
