(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsTh = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"ก":[{"ั":[{"น":[{},[0,0,0,3]]}]},[0,6]],"ช":[{"ี":[{"ว":[{"ั":[{},[0,0,5]]}]}]},[0,6]],"ท":[{"ั":[{"ศ":[{"น":[{"ู":[{},[0,0,0,0,0,5]]}]}]}],"ี":[{"่":[{},[0,0,0,3]]}]},[0,6]],"บ":[{"ท":[{},[0,0,1]]},[0,6]],"ร":[{"ง":[{},[0,0,4]],"า":[{"ย":[{},[0,0,0,3]]}],"ม":[{"ณ":[{"ี":[{},[0,0,7]]}]}],"ั":[{"ม":[{"ณ":[{"ี":[{},[0,0,0,7]]}]}]}]},[0,6]],"ล":[{"ำ":[{},[0,0,3]]},[0,6]],"ส":[{"น":[{"ท":[{},[0,0,5]]}],"ู":[{"ต":[{},[0,0,3]]}],"ิ":[{"ท":[{"ธ":[{"ิ":[{".":[{},[0,0,0,6]]}]}]}]}]},[0,6]],"ใ":[{"บ":[{},[0,0,3]]}],"ข":[{},[0,6]],"ฃ":[{},[0,6]],"ค":[{},[0,6]],"ฅ":[{},[0,6]],"ฆ":[{},[0,6]],"ง":[{},[0,6]],"จ":[{},[0,6]],"ฉ":[{},[0,6]],"ซ":[{},[0,6]],"ฌ":[{},[0,6]],"ญ":[{},[0,6]],"ฎ":[{},[0,6]],"ฏ":[{},[0,6]],"ฐ":[{},[0,6]],"ฑ":[{},[0,6]],"ฒ":[{},[0,6]],"ณ":[{},[0,6]],"ด":[{},[0,6]],"ต":[{},[0,6]],"ถ":[{},[0,6]],"ธ":[{},[0,6]],"น":[{},[0,6]],"ป":[{},[0,6]],"ผ":[{},[0,6]],"ฝ":[{},[0,6]],"พ":[{},[0,6]],"ฟ":[{},[0,6]],"ภ":[{},[0,6]],"ม":[{"ก":[{"ร":[{"า":[{},[0,0,7]]}]}]},[0,6]],"ย":[{"ี":[{"่":[{},[0,0,0,7]]}]},[0,6]],"ฤ":[{"ท":[{"ั":[{"ย":[{},[0,6]]}]}]},[0,6]],"ฦ":[{},[0,6]],"ว":[{"ส":[{"ล":[{"ะ":[{},[0,0,7]]}]}]},[0,6]],"ศ":[{},[0,6]],"ษ":[{},[0,6]],"ห":[{},[0,6]],"ฬ":[{},[0,6]],"อ":[{},[0,6]],"ฮ":[{},[0,6]],"เ":[{"ห":[{"ย":[{"ง":[{},[0,0,6]]}]}]}]}],"ก":[{"ก":[{"ม":[{},[0,4]],"ส":[{},[0,0,4]],".":[{},[5]]},[2,1]],"ข":[{"ค":[{"ณ":[{},[0,0,5]]},[0,4]],"ช":[{"า":[{},[0,0,5]]},[0,4]],"ณ":[{"ะ":[{},[0,5]],"า":[{},[0,5]]},[0,4]],"บ":[{"ุ":[{},[0,0,5]]},[0,4]],"ภ":[{"ั":[{},[0,0,5]]},[0,4]],"ม":[{"ั":[{},[0,5]],"า":[{},[0,0,5]],"ู":[{},[0,0,5]]},[0,4]],"ล":[{"า":[{},[0,0,5]]}],"ศ":[{"ั":[{},[0,0,5]]}],"เ":[{"ท":[{},[0,0,5]],"ว":[{},[0,0,5]]},[0,4]],"์":[{},[0,4]]},[2,1]],"ค":[{},[0,1]],"ง":[{"บ":[{"ว":[{},[0,0,5]]}],".":[{},[5]]}],"จ":[{},[0,1]],"ช":[{},[0,1]],"ซ":[{},[2]],"ญ":[{"จ":[{"น":[{},[0,0,5]]}]}],"ฎ":[{"ห":[{"ม":[{},[0,0,5]]}],"เ":[{"ก":[{},[0,0,5]]}],".":[{},[7]]}],"ฏ":[{"ห":[{"ม":[{},[0,0,5]]}],".":[{},[7]]}],"ด":[{"ิ":[{"น":[{},[0,5]]}],"ี":[{},[0,7]]}],"ต":[{"ด":[{"ิ":[{},[0,0,5]]},[0,4]],"ส":[{},[0,4]],"เ":[{},[0,4]]},[0,1]],"ท":[{},[0,1]],"น":[{"ด":[{},[0,4]],"ธ":[{},[0,4]],"ะ":[{},[0,6]]},[0,1]],"บ":[{".":[{},[5]]},[0,1]],"ป":[{"ร":[{},[0,0,4]]},[0,1]],"พ":[{},[0,1]],"ฟ":[{},[0,1]],"ม":[{"ม":[{},[0,4]],"ส":[{},[0,4]],"เ":[{},[0,4]]},[0,1]],"ย":[{"ม":[{"ุ":[{},[0,0,5]]}],"้":[{},[0,3]],"ะ":[{},[0,7]]}],"ร":[{"ก":[{"ฎ":[{},[0,0,5]]}],"ณ":[{"ั":[{},[0,5,5]]}],"ต":[{"๋":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"ก":[{"ศ":[{},[0,0,0,7]]}]},[1,4]],"ล":[{"า":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}],"า":[{"ค":[{},[0,5]]}],"ิ":[{"น":[{"ท":[{},[0,5]]}]}],"ู":[{},[0,4]],"ไ":[{"ฟ":[{},[0,0,5]]}],".":[{},[5]],"ส":[{},[0,6]]}],"ล":[{"น":[{"ค":[{},[0,0,5]]}],"ม":[{"ห":[{},[0,0,5]]}]}],"ว":[{"ั":[{"ต":[{},[0,5]]}]},[0,2]],"ษ":[{"ณ":[{"น":[{},[0,5]],"ะ":[{},[0,3]],"า":[{},[0,5]]}],"ม":[{"า":[{},[0,5]],"ี":[{},[0,5]]}],"เ":[{"ท":[{},[0,0,5]]}]}],"ส":[{"น":[{},[0,0,4]],"โ":[{},[0,4]],"ี":[{},[0,7]]},[0,1]],"ห":[{},[0,1]],"อ":[{"อ":[{"ิ":[{},[0,0,5]]}]}],"ะ":[{"ถ":[{"ั":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ร":[{},[4]]}],"ั":[{},[1]],"า":[{"ก":[{"ะ":[{},[0,0,5]]}],"ด":[{"ู":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]],"้":[{},[0,0,5]]}],"บ":[{"อ":[{},[0,0,5]]}],"ฝ":[{"า":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]]}]},[1]],"ำ":[{"ด":[{"้":[{},[0,0,5]]}],"ท":[{"อ":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}]}],"ิ":[{"ก":[{"ะ":[{},[0,0,5]]}],"ต":[{},[0,0,4]],"น":[{"ี":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],".":[{},[5]]},[1]],"ี":[{"ร":[{"ณ":[{},[0,0,5]],"ต":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}],".":[{},[5]]}],"ุ":[{"ง":[{"อ":[{},[0,0,5]]}],"ช":[{"ิ":[{},[0,0,5]]}],"ฎ":[{"ุ":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"ร":[{"ร":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],"แ":[{"ห":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ณ":[{"ฑ":[{"์":[{},[0,0,0,6]]}]},[0,0,0,5]]},[1]],"ู":[{"ป":[{"ร":[{},[0,0,5]]}],"ร":[{"ข":[{},[0,0,5]],"ม":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}]},[1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"่":[{"ก":[{"อ":[{},[0,0,5]]}],"บ":[{"้":[{},[0,0,5]]}],"ป":[{"่":[{},[0,0,5]]}]}],"์":[{"ท":[{"็":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ณ":[{"ะ":[{},[0,7]]}],"ฝ":[{},[0,7]]}],"ข":[{"ม":[{"ห":[{"ิ":[{},[0,0,5]]}]}],"ล":[{"า":[{},[4]]}],"อ":[{"ข":[{"ม":[{},[0,0,5]]}],"ง":[{"้":[{},[0,0,5]]}],"อ":[{"ภ":[{},[0,0,5]]}]}],"ั":[{"ด":[{"ส":[{"ม":[{"า":[{"ธ":[{"ิ":[{},[0,0,0,0,0,0,6]]}]}]}]}]}]},[1]],"า":[{"ก":[{"๊":[{},[0,0,5]]}],"ท":[{"น":[{},[0,0,5]]}]},[1]],"ิ":[{"ป":[{"ส":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"้":[{},[0,0,0,1]]}],"่":[{"ม":[{"ุ":[{},[0,0,5]]}],"ห":[{"ง":[{},[0,0,5]]}]}],"้":[{"า":[{"ว":[{},[0,0,0,0,3]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]}],"บ":[{"ถ":[{},[0,6]]}]},[0,2]],"ค":[{"ค":[{},[0,1]],"ช":[{"ส":[{"ี":[{},[0,0,5]]}],"เ":[{},[0,4]]},[0,1]],"ณ":[{"ิ":[{},[0,4]]}],"ท":[{"ร":[{"ี":[{},[0,0,5]]},[0,4]],"ว":[{"อ":[{},[0,0,5]]}]}],"น":[{"ย":[{"อ":[{},[0,0,5]]}],"ิ":[{},[4]],"ะ":[{},[0,7]],".":[{},[5]]}],"ป":[{"ซ":[{"ู":[{},[0,0,5]]}],"ผ":[{"ก":[{},[0,0,5]]}]}],"ม":[{"น":[{},[3]],"ฟ":[{"ร":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]]}]}],"ย":[{"ะ":[{},[0,7]]},[2]],"ร":[{"ซ":[{"อ":[{},[0,0,5]]}],"น":[{"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"พ":[{"น":[{},[0,0,5]]}],"ม":[{"เ":[{},[0,0,5]]}],"ร":[{"้":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ห":[{"า":[{},[0,0,5]]}],"ั":[{"ก":[{},[4,5]]}],"า":[{"ต":[{},[0,5]]}],"ู":[{},[0,6]]}],"ฤ":[{"ห":[{"บ":[{},[0,0,5]],"า":[{},[0,0,5]]}],"โ":[{"ฆ":[{},[0,0,5]]}]}],"ล":[{"ค":[{"ู":[{},[0,0,5]]}]}],"ว":[{"ท":[{"อ":[{},[0,0,5]]}],"า":[{},[3]]},[0,2]],"ส":[{"ต":[{"ิ":[{},[0,0,5]]}]},[2]],"ห":[{"ก":[{"ร":[{},[0,0,5]]}],"น":[{"ิ":[{},[0,0,5]]}],"บ":[{"ด":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}],"ะ":[{},[0,6]],"า":[{},[0,7]]}],"อ":[{"น":[{},[3]]}],"ั":[{"น":[{},[3]]}],"า":[{"ป":[{"ู":[{},[0,0,5]]}],"พ":[{"จ":[{},[0,0,5]],"ย":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]]}],"ว":[{"จ":[{},[0,0,5]]}],"ม":[{"ณ":[{"ี":[{},[0,0,0,7]]}]}]},[1]],"ำ":[{"ด":[{"ี":[{},[0,0,5]]}],"โ":[{"อ":[{},[0,0,5]]}],"ไ":[{"ก":[{},[0,0,5]]}]},[7]],"ุ":[{"ณ":[{"ู":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],"์":[{".":[{},[6]]},[4]],"ป":[{"ต":[{"ิ":[{},[0,0,0,7]]}]}]},[1]],"ู":[{"ป":[{"อ":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]]}],".":[{},[7]]}],"เ":[{},[2,1]],"โ":[{},[0,1]],"์":[{"จ":[{"ำ":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ิ":[{"์":[{".":[{},[6]]}]}],"ต":[{"ะ":[{},[0,6]]}],"ี":[{"ย":[{"ะ":[{},[0,0,7]]}],".":[{},[7]]}],"บ":[{".":[{},[5]]}],"ะ":[{},[5]]}],"ฆ":[{"า":[{"ณ":[{"ั":[{},[0,0,5]]}]},[1]],"ี":[{"ย":[{"ก":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],".":[{},[7]]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ะ":[{},[5]]}],"ง":[{"ก":[{"ห":[{},[0,4]],"ะ":[{"ร":[{},[0,0,0,4]]}],"เ":[{},[0,4]],"์":[{},[0,4]]},[0,1]],"ข":[{"ก":[{},[0,4]],"ต":[{},[0,4]]},[0,1]],"ค":[{"จ":[{},[0,4]],"ช":[{"า":[{"ต":[{"ิ":[{},[0,5]]}]}]},[0,4]],"ญ":[{},[0,4]],"ธ":[{},[0,4]],"บ":[{},[0,4]],"ป":[{},[0,4]],"ว":[{"ั":[{},[0,0,5]]}],"ศ":[{},[0,4]],"โ":[{},[0,4]]},[0,1]],"ฆ":[{"ป":[{"ร":[{},[0,0,5]]}],"ส":[{"ภ":[{},[0,0,5]]}],"เ":[{"ถ":[{},[0,0,5]],"ภ":[{},[0,0,5]]}]}],"ง":[{"เ":[{},[0,4]],".":[{},[5]]},[0,1]],"จ":[{},[0,1]],"ฉ":[{},[0,1]],"ช":[{"ี":[{},[0,4]]},[0,1]],"ซ":[{},[0,1]],"ด":[{},[0,1]],"ต":[{"ก":[{},[0,7]]},[0,1]],"ท":[{},[0,1]],"น":[{},[0,1]],"บ":[{"ด":[{"ุ":[{},[0,0,5]]}]}],"ป":[{},[0,1]],"ผ":[{},[0,1]],"พ":[{},[0,1]],"ม":[{},[0,1]],"ย":[{},[0,1]],"ร":[{},[0,1]],"ล":[{},[0,1]],"ว":[{"เ":[{},[0,4]],"ด":[{},[0,6]],"น":[{},[0,6]],"ย":[{},[0,6]]},[0,1]],"ส":[{"ก":[{"ล":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"บ":[{},[0,4]],"พ":[{"ย":[{},[0,0,5]]},[0,4]],"ภ":[{},[0,4]]},[0,1]],"ห":[{"น":[{"า":[{},[0,0,5]]}],"บ":[{"ั":[{},[0,0,5]]},[0,4]],"ร":[{"า":[{},[0,0,5]]}],"ล":[{},[0,7]]},[0,1]],"า":[{"ช":[{"้":[{},[0,0,5]]}],"ร":[{"ำ":[{},[0,0,5]]}]},[1]],"ู":[{"ส":[{"ว":[{},[0,0,5]]}]},[7]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"่":[{"ง":[{"อ":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ำ":[{},[5]],"อ":[{"ร":[{".":[{},[0,7]]}],"อ":[{".":[{},[0,7]]}]}]}],"จ":[{"จ":[{"ว":[{},[0,4]]},[0,1]],"ฉ":[{},[0,1]],"ด":[{"จ":[{"่":[{},[0,0,5]]}],".":[{},[5]]}],"ต":[{"จ":[{"ำ":[{},[0,0,5]]}],"ม":[{"ู":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}]}],"ป":[{"ก":[{},[0,0,4]]}],"ฟ":[{"ฟ":[{"ร":[{},[0,0,5]]}]}],"ม":[{"บ":[{"พ":[{},[0,0,0,5]]}]}],"ร":[{"ิ":[{},[3]],"ส":[{},[0,6]],".":[{},[5]]}],"อ":[{"ง":[{"อ":[{},[0,0,5]]}],".":[{},[5]]}],"ั":[{},[1]],"า":[{"ม":[{"ร":[{},[0,0,5]]}],"ร":[{"ึ":[{},[0,0,5]]}]},[1]],"ำ":[{"ท":[{"ว":[{},[0,0,5]]}],"อ":[{"ว":[{},[0,0,5]]}]},[7]],"ิ":[{"จ":[{"ู":[{},[0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ี":[{"ด":[{"ี":[{},[0,0,5]]}]}],"ุ":[{"ฑ":[{"า":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ร":[{"ณ":[{},[0,0,6]]}]}],"ู":[{"ป":[{"ิ":[{},[0,0,5]]}]}],"เ":[{},[0,1]],".":[{},[6]],"์":[{".":[{},[6]]}],"น":[{"ท":[{"ี":[{".":[{},[0,0,6]]},[0,0,6]]}]}],"ะ":[{".":[{},[5]]}],"บ":[{".":[{},[5]]}],"่":[{"า":[{"ร":[{},[0,0,0,7]]}]}]}],"ฉ":[{"ก":[{"ฉ":[{"ว":[{},[0,0,5]]}],"ษ":[{},[0,0,4]]}],"ท":[{"ท":[{"ิ":[{},[0,0,5]]}]}],"ร":[{"ฉ":[{"ิ":[{},[0,0,5]]}]}],"ั":[{},[1]],"า":[{"ก":[{"๊":[{},[0,0,5]]}],"พ":[{"ย":[{},[0,0,5]]}]},[1]],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"น":[{"ี":[{},[0,6]]}],"ป":[{"ะ":[{},[0,6]]}],"ล":[{".":[{},[5]]}]},[0,2]],"ช":[{"ช":[{},[0,1]],"ฌ":[{"ก":[{},[0,4]],"ฆ":[{},[0,4]]},[0,1]],"ด":[{"ช":[{"้":[{},[0,0,5]]}]}],"น":[{"ี":[{"ก":[{},[0,5]]}],"์":[{},[4]],".":[{},[5]]}],"บ":[{},[0,1]],"ฟ":[{"ร":[{"อ":[{},[0,0,5]]}],"โ":[{"ร":[{},[0,0,5]]}]}],"ร":[{"ก":[{"ล":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ฤ":[{"ก":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"อ":[{"ุ":[{},[0,0,5]]}],"า":[{".":[{},[0,6]]},[0,3]],"ี":[{".":[{},[0,7]]}],"ะ":[{},[0,5]],"ถ":[{".":[{},[0,7]]}]}],"ว":[{"โ":[{},[0,0,4]],"า":[{".":[{},[0,6]]}]}],"อ":[{"ง":[{},[0,0,0,4]]}],"ั":[{},[1]],"า":[{"ต":[{"ร":[{},[0,0,5]]},[0,0,2]],"ป":[{"ี":[{},[0,0,5]]}],"ม":[{"ต":[{},[0,0,5]]}],"ย":[{"ต":[{},[0,0,5]]}],"ส":[{"ง":[{},[0,0,5]]}]},[1]],"ำ":[{"ง":[{"ั":[{},[0,0,5]]}]}],"ิ":[{"น":[{"ี":[{},[0,0,5]]}],"ร":[{"ณ":[{},[0,0,5]]}],"แ":[{"ก":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"ผ":[{"ะ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ร":[{"ณ":[{},[0,0,5]]}],"ว":[{"น":[{},[0,0,5]]},[1]]}],"ุ":[{"ต":[{"ิ":[{},[0,0,5]]}],"ล":[{"ด":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ป":[{"ก":[{},[0,0,5]],"ถ":[{},[0,0,5]],"โ":[{},[0,0,5]]}]},[5]],"เ":[{},[0,1]],"่":[{"อ":[{"ิ":[{},[0,0,5]]}]}],"้":[{"ส":[{"อ":[{},[0,0,5]]}],"ไ":[{"ด":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ไ":[{},[0,6]],"ล":[{".":[{},[5]]}],"ก":[{".":[{},[5]]}],"ญ":[{"ะ":[{},[0,7]]}],"ต":[{"ก":[{".":[{},[0,7]]}]}]}],"ซ":[{"ก":[{"ซ":[{"อ":[{},[0,0,5]]}]}],"น":[{"ท":[{"ร":[{},[0,0,5]]}],".":[{},[5]]}],"ร":[{"า":[{"ม":[{},[0,5]]}]}],"ล":[{"ฟ":[{"ี":[{},[0,0,5]]}]}],"ั":[{},[1]],"า":[{"ช":[{"ู":[{},[0,0,5]]}],"ม":[{"ู":[{},[0,0,5]]}]},[1]],"ิ":[{"ต":[{"ร":[{},[0,0,5]]}],"แ":[{"ล":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ี":[{"ด":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"ิ":[{},[0,0,5]],"็":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],".":[{},[7]]}],"ึ":[{"ม":[{},[3]]}],"ู":[{"ซ":[{"ู":[{},[0,0,5]],"ุ":[{},[0,0,7]]}],"บ":[{"ิ":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ฮ":[{"า":[{},[0,0,5]],"ก":[{},[0,0,7]]}]},[7]],"เ":[{},[0,1]],"โ":[{},[0,1]],"่":[{"ง":[{"่":[{},[0,0,5]]}],"ซ":[{"้":[{},[0,0,5]]}],"า":[{},[1]]}],"์":[{"ค":[{"ล":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ุ":[{"์":[{".":[{},[6]]}]}],"อ":[{},[5]],"ฟ":[{"ี":[{},[0,7]]}]}],"ญ":[{"จ":[{"ด":[{"ุ":[{},[0,0,5]]}],"น":[{"ท":[{},[0,5,5]],"บ":[{},[0,5,5]],"า":[{},[0,5]]},[0,4]],"บ":[{"ร":[{},[0,0,5]]}],"ม":[{"บ":[{},[0,5,5]]}],"ร":[{"ง":[{},[0,0,5]]}],"ว":[{"ี":[{},[0,0,5]]}],"ศ":[{"ี":[{},[0,0,5]]}]}],"ฉ":[{"น":[{},[0,4]]}],"ช":[{},[0,1]],"ญ":[{},[0,1]],"ป":[{"ร":[{"ะ":[{},[0,0,0,0,4]]}]}],"า":[{"ญ":[{"่":[{},[0,0,5]]}],"ต":[{},[0,0,4]]},[1]],"่":[{"บ":[{"้":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ี":[{},[5]]}],"ฏ":[{"ฐ":[{"บ":[{},[0,4]]},[0,1]],"ิ":[{"ท":[{"ิ":[{},[0,0,5]]}],"ป":[{"ท":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ส":[{"น":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ว":[{"ี":[{".":[{},[0,7]]}]}],"ะ":[{".":[{},[5]]}],"ฏ":[{"ิ":[{".":[{},[0,7]]}]}]}],"ฐ":[{"ภ":[{"ั":[{},[0,4]]}],"ม":[{"ฌ":[{"า":[{},[0,0,5]]}],"พ":[{"ย":[{},[0,0,5]]}],"ฤ":[{"ก":[{},[0,0,5]]}]}],"า":[{"น":[{"ี":[{},[0,0,5]]}]},[1]],"ุ":[{"ช":[{"ุ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ะ":[{},[5]]}],"ฑ":[{"า":[{"ม":[{"ณ":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}]}],"ู":[{"ร":[{},[3]]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ฑ":[{"ุ":[{},[0,7]]}]}],"ฒ":[{"ิ":[{"ส":[{"ภ":[{},[0,0,5]],"ม":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]}]}],"ณ":[{"ฑ":[{"ก":[{},[0,4]],"ฆ":[{},[0,4]],"น":[{"ะ":[{},[0,5]]},[0,4]],"บ":[{},[0,4]],"ม":[{},[0,4]],"ล":[{"า":[{},[0,0,5]]}],"ส":[{"ก":[{},[0,5]],"ถ":[{},[0,0,5]],"ี":[{},[0,5,5]]},[0,4]],"โ":[{"ล":[{},[0,0,5]]}],"์":[{},[0,4]]},[0,1]],"ย":[{"ร":[{"ั":[{},[0,0,5]]}]}],"ร":[{"ส":[{"ี":[{},[0,0,6]]}]},[0,1]],"ว":[{"า":[{},[0,4]]}],"ห":[{"พ":[{"ล":[{},[0,0,5]]}],"ภ":[{"ู":[{},[0,0,5]]}],"า":[{},[0,7]]}],"า":[{"ป":[{"ี":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}]},[1]],"ิ":[{"์":[{".":[{},[6]]}]},[1]],"ี":[{"ส":[{"ง":[{},[0,0,5]]}],"ย":[{"ะ":[{},[0,0,7]]}]},[1]],"ู":[{"ป":[{"โ":[{},[0,0,5]]}]},[5]],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]},[7]],"ณ":[{"ะ":[{},[0,7]]}],"ส":[{"ี":[{},[0,7]]}],"ม":[{"ี":[{},[0,7]]}],"พ":[{".":[{},[7]]}]}],"ด":[{"ก":[{"ง":[{},[0,4]],"ด":[{"ื":[{},[0,0,5]]},[0,4]],"เ":[{},[0,4]],"แ":[{},[0,4]],".":[{},[5]]},[0,1]],"ข":[{},[0,1]],"ค":[{},[0,1]],"ง":[{"ค":[{"ต":[{},[0,0,7]]},[0,0,4]],"อ":[{"อ":[{},[0,0,5]]}]}],"ช":[{"น":[{"ะ":[{},[0,5]]}],"ะ":[{},[0,7]]}],"ด":[{"เ":[{},[0,4]]},[0,1]],"ต":[{},[0,1]],"ท":[{},[0,1]],"ป":[{},[0,1]],"พ":[{},[0,1]],"ม":[{"ค":[{"ต":[{},[0,0,5]]}],".":[{},[5]]}],"ร":[{"ล":[{"ิ":[{},[0,0,5]]}],"ู":[{},[0,4]],"้":[{},[0,3]],"์":[{},[4]],"ส":[{},[0,6]],".":[{},[5]]}],"ส":[{"ก":[{},[0,4]],"เ":[{},[0,0,4]]},[0,1]],"ห":[{},[0,1]],"ั":[{},[1]],"า":[{"ม":[{"ุ":[{},[0,0,5]]}],"ร":[{"ก":[{},[0,0,5]]}],"ส":[{"ว":[{},[0,0,5]]}]},[1]],"ำ":[{"ฤ":[{"ษ":[{},[0,0,5]]}]},[5]],"ิ":[{"ท":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"บ":[{"ด":[{"ี":[{},[0,0,0,7]]}]},[0,0,4]],"ว":[{"ร":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]],"ร":[{},[0,0,7]]}],"์":[{".":[{},[6]]},[4]]}],"ี":[{"ด":[{"ี":[{},[0,0,5]]}],"น":[{},[3]],"ฝ":[{"่":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ว":[{"ี":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]],"ว":[{},[0,0,5]]}]}],"ู":[{"ถ":[{"ู":[{},[0,0,5]]}],"ป":[{"อ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]]}],"แ":[{"ค":[{},[0,0,5]]}]}],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"้":[{"ย":[{"ิ":[{},[0,0,5]]}]}],"์":[{"ป":[{"ร":[{},[0,0,5]]}],"ส":[{"ป":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ุ":[{"์":[{".":[{},[6]]}]}],"ล":[{".":[{},[5]],"ะ":[{},[0,7]],"ม":[{".":[{},[0,7]]}]}],"น":[{"ู":[{},[0,6]]}],"อ":[{".":[{},[5]]}]}],"ต":[{"ก":[{"ร":[{"้":[{},[0,0,5]]}],"ล":[{"ง":[{},[0,0,7]]}]},[2]],"ค":[{},[0,1]],"ช":[{},[2,1]],"ต":[{"ภ":[{},[0,4]],"ส":[{"ด":[{},[0,0,5]]},[0,4]],"โ":[{},[0,4]]},[2,1]],"ถ":[{"ก":[{"ะ":[{},[0,5]],"ิ":[{},[0,0,5]]}],"า":[{},[0,3]],"ุ":[{"ป":[{},[0,5]],"ศ":[{},[0,5]]}],"เ":[{"ล":[{},[0,0,5]]}],"ี":[{},[0,5]],"ิ":[{},[0,7]],"ร":[{".":[{},[0,7]]}]}],"ท":[{"ั":[{"ศ":[{"น":[{"ู":[{"ป":[{},[0,0,0,0,0,0,0,5]]}]}]}]}]}],"น":[{"ฟ":[{"อ":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}]},[2]],"บ":[{"ช":[{"ว":[{},[0,0,5]]},[0,4]]},[2,1]],"ป":[{"น":[{"ี":[{},[0,0,5]]}]}],"ภ":[{},[0,1]],"ย":[{},[2]],"ร":[{"ก":[{},[4]],"ง":[{"อ":[{},[0,0,5]]}],"จ":[{"ี":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ฐ":[{},[4]],"ต":[{"ร":[{},[0,0,5]]}],"ท":[{"ว":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ฝ":[{"ร":[{},[0,0,5]]}],"พ":[{"ล":[{},[0,0,5]]}],"ร":[{"ง":[{},[0,0,5]]}],"ล":[{"ด":[{},[0,0,5]]}],"ศ":[{},[4]],"ิ":[{"ย":[{"า":[{},[0,5]]}]}],"ู":[{},[0,4]],"์":[{},[2]],".":[{},[6]]}],"ฤ":[{"ต":[{"ี":[{},[0,0,5]]}]}],"ล":[{"ร":[{"ั":[{},[0,0,5]]}]}],"ส":[{"ว":[{"า":[{},[0,0,5]]}],"เ":[{"ซ":[{},[0,0,5]]},[0,0,4]],"แ":[{"ต":[{},[0,0,5]]}]}],"อ":[{"ม":[{"่":[{},[0,0,5]]}]}],"ะ":[{"ใ":[{"ภ":[{},[0,0,5]]}],".":[{},[5]]}],"ั":[{"ว":[{"ต":[{"น":[{},[0,0,0,7]]}]}]},[1]],"า":[{"ก":[{"ล":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"น":[{"ึ":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ผ":[{"ิ":[{},[0,0,5]]}],"ฟ":[{"ู":[{},[0,0,5]]}],"ม":[{"ห":[{},[0,0,3]],"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]]}],"ฬ":[{"ี":[{},[0,0,5]]}]},[1]],"ิ":[{"ก":[{".":[{},[1]]}],"จ":[{"ู":[{},[0,0,5]]}],"ช":[{"่":[{},[0,0,5]]}],"ซ":[{"อ":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}],"น":[{"ร":[{},[0,0,5]]}],"บ":[{"อ":[{},[0,0,5]]}],"ม":[{},[0,0,3]],"ย":[{"ภ":[{},[0,0,5]],"ม":[{},[0,0,5]]}],"์":[{".":[{},[6]]},[4]],"ง":[{"ส":[{"ต":[{"ิ":[{},[0,0,0,0,7]]}]}]}]}],"ี":[{"ข":[{"ล":[{},[0,0,5]]}],"ค":[{"ู":[{},[0,0,5]]}],"ต":[{"ื":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"้":[{".":[{},[3]]}]}],"ุ":[{"ต":[{"ถ":[{},[0,0,5]]}],"ท":[{"ส":[{},[0,0,5]]}],"ป":[{"่":[{},[0,0,5]]}],"ม":[{"ห":[{},[0,0,5]]}],"ร":[{"ก":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"ส":[{"ด":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ด":[{"ิ":[{},[0,0,5]]}],".":[{},[5]]}],"เ":[{},[0,1]],"แ":[{"ล":[{},[0,3]]}],"โ":[{},[0,1]],"่":[{"ถ":[{"า":[{},[0,0,5]]}],"ว":[{"่":[{},[0,0,5]]}],"ส":[{"ว":[{},[0,0,5]]}]}],"้":[{"ก":[{"๋":[{},[0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]}],"ฝ":[{"ุ":[{},[0,0,5]]}]}],"๋":[{"เ":[{"ต":[{},[0,0,5]]}]}],"์":[{"ค":[{"ล":[{},[0,0,5]]}],"ฟ":[{"ู":[{},[0,0,5]]}],"ศ":[{"ต":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ด":[{"ี":[{},[0,7]]}],"ม":[{"ะ":[{},[0,6]]}]}],"ถ":[{"ก":[{"ิ":[{},[0,4]]}],"ด":[{"ถ":[{"อ":[{},[0,0,5]]}]}],"ม":[{"ถ":[{"ื":[{},[0,0,5]]}]}],"ล":[{"ไ":[{"ถ":[{},[0,0,5]]}]}],"ว":[{"ไ":[{"ม":[{},[0,0,5]]}],"ี":[{".":[{},[0,7]]}]}],"ะ":[{"ถ":[{"ั":[{},[0,0,5]]}]},[7]],"า":[{"ธ":[{},[0,4]],"ว":[{"ร":[{},[0,0,5]]}]}],"ี":[{"ย":[{},[0,4]],"ล":[{"ิ":[{},[0,0,5]]}]}],"ุ":[{"น":[{},[3]],"์":[{".":[{},[6]]}]}],"่":[{"ถ":[{"อ":[{},[0,0,5]],"า":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ร":[{"ะ":[{},[0,7]],"ี":[{},[0,7]]}]}],"ท":[{"ก":[{"า":[{},[4]],".":[{},[5]],"ร":[{"ก":[{},[0,0,7]]}]}],"ค":[{"ต":[{"ิ":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ล":[{".":[{},[0,7]]}]}],"ด":[{"ร":[{"อ":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]]}],".":[{},[5]]}],"ธ":[{"ค":[{"ย":[{},[0,0,5]]}],"ช":[{"ะ":[{},[0,5]]}],"ฎ":[{"ี":[{},[0,0,5]]}],"ป":[{"ฏ":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"ศ":[{"ต":[{},[0,0,5]]}],"ส":[{"ี":[{},[0,0,5]]}],"อ":[{"ง":[{},[0,0,5]]}],"ิ":[{"ก":[{},[0,5]],"ช":[{},[0,5]],"บ":[{},[0,5]],"ป":[{},[0,5]],"ผ":[{},[0,5]],"พ":[{},[0,5]],"ภ":[{},[0,5]],"ร":[{},[0,5]],"ฤ":[{},[0,5]],"ศ":[{},[0,5]],"ส":[{},[0,5]],"โ":[{},[0,5]]}],"เ":[{"จ":[{},[0,0,5]]}]}],"พ":[{"ธ":[{"ิ":[{},[0,0,5]]}],"ย":[{"ุ":[{},[0,0,5]]}],"น":[{"ม":[{".":[{},[0,0,7]]}]}]}],"ฟ":[{"ล":[{"อ":[{},[0,0,5]]}]}],"ย":[{"า":[{"น":[{},[0,5]]}],"ะ":[{},[0,7]]},[2]],"ร":[{"ค":[{"ต":[{},[0,0,5]],"ร":[{},[0,0,5]]}],"ธ":[{"น":[{},[0,0,5]]}],"ร":[{},[3]],"ส":[{"โ":[{},[0,0,5]]},[0,6]],"ห":[{"ว":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"ั":[{},[3]],"า":[{"ก":[{},[0,5]],"ห":[{},[4,5]]},[1]],"ี":[{},[1]],"พ":[{"ี":[{},[0,0,7]]}],"ะ":[{".":[{},[0,7]]}]}],"ว":[{"ท":[{"ห":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}]}],"ศ":[{"ท":[{"ิ":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}]}],"ส":[{"น":[{"ท":[{},[0,0,0,5]]}],"ล":[{"า":[{},[0,0,7]]}]}],"ห":[{"ว":[{"ั":[{},[0,0,5]]}],"ฬ":[{"ิ":[{},[0,0,5]]}],"ะ":[{},[0,6]],"ร":[{"ะ":[{},[0,0,7]]}]}],"ั":[{},[1]],"า":[{"ฐ":[{"ิ":[{},[0,0,5]]}],"ฒ":[{"ิ":[{},[0,0,5]]}],"น":[{"อ":[{},[0,0,5]]}],"ม":[{"ต":[{},[0,0,5]],"ร":[{},[0,0,5]]}],"ร":[{"พ":[{},[0,0,5]]}]},[1]],"ำ":[{"ข":[{"ว":[{},[0,0,5]]}],"ซ":[{"้":[{},[0,0,5]]}],"ท":[{"่":[{},[0,0,5]]}],"โ":[{"ท":[{},[0,0,5]]}]}],"ิ":[{"ฆ":[{"ั":[{},[0,0,5]]}],"ฐ":[{"ิ":[{},[0,0,5]]}],"พ":[{"า":[{},[0,0,5]]},[0,0,4]],"ว":[{"ง":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"น":[{"ว":[{},[0,0,5]],"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],".":[{},[5]]}],"ุ":[{"ค":[{"ต":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"ศ":[{"ี":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],".":[{},[7]]}],"ู":[{"น":[{"่":[{},[0,0,5]]}]},[1]],"เ":[{},[0,1]],"์":[{"ด":[{"อ":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ณ":[{"ะ":[{},[0,7]]}],"ล":[{"ี":[{},[0,7]]}],"ท":[{"ะ":[{},[0,7]]}],"โ":[{"ท":[{},[0,7]]}]}],"ธ":[{"ร":[{"ส":[{},[4]],"ั":[{},[4]]},[1]],"า":[{"ร":[{"ณ":[{"า":[{},[0,0,5]]}]}],"ต":[{"ุ":[{".":[{},[0,0,6]]}]}]},[1]],"ิ":[{"ฤ":[{"ท":[{},[0,0,5]]}],"ศ":[{"ี":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ุ":[{"ด":[{"ง":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ป":[{"น":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ไ":[{"น":[{},[0,6]]}],"ค":[{"ย":[{"า":[{},[0,0,6]]}]}],"ย":[{"ะ":[{},[0,7]]}],"น":[{"ู":[{},[0,6]]}],"ะ":[{},[7]],"ี":[{},[5]],"ก":[{".":[{},[5]]}],"ม":[{".":[{},[5]]}],"ต":[{"ร":[{"ฐ":[{},[0,0,7]]}]}]}],"น":[{"ก":[{"ค":[{},[0,4]],"ป":[{},[0,4]],"ย":[{"ู":[{},[0,0,5]]}],"ร":[{"ู":[{},[0,0,5]]}]},[0,1]],"ข":[{"ล":[{"ิ":[{},[0,0,5]]}]},[0,1]],"ค":[{"ร":[{"ิ":[{},[0,0,5]],".":[{},[0,6]]}]},[0,1]],"จ":[{"อ":[{"น":[{},[0,0,5]]},[0,4]]},[0,1]],"ช":[{"ญ":[{},[0,4]]},[0,1]],"ซ":[{},[0,1]],"ด":[{},[0,1]],"ต":[{"ก":[{"ว":[{},[0,0,5]],"ะ":[{},[0,5]]}],"ด":[{"ิ":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]},[0,4]],"ป":[{"ิ":[{},[0,0,5]]}],"ภ":[{},[0,4]],"ร":[{"ะ":[{},[0,5]],"ั":[{},[0,5]],"า":[{},[0,3]],"ิ":[{},[0,5,5]]}],"ฤ":[{"ด":[{},[0,0,5]]}],"ิ":[{},[0,3]],"ุ":[{"ก":[{},[0,5]],"ฏ":[{},[0,5]],".":[{},[0,7]]}],"์":[{},[0,4]],"ี":[{},[0,7]]},[0,1]],"ถ":[{"ธ":[{"ุ":[{},[0,0,5]]}],"ร":[{"จ":[{},[0,0,5]]}]}],"ท":[{"ข":[{"ี":[{},[0,0,5]]}],"น":[{"น":[{},[0,0,5]],"ะ":[{},[0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ย":[{},[0,0,4]],"ร":[{"ง":[{},[0,5]],"ุ":[{},[0,5]],".":[{},[0,7]]}],"ฤ":[{"ก":[{},[0,0,5]]}],"ล":[{"า":[{},[0,5]]}],"ว":[{"ย":[{},[0,5]]}],"อ":[{},[0,3]],"ิ":[{},[0,1]],"ี":[{},[0,3]],"ะ":[{},[0,7]],"ม":[{".":[{},[0,7]]}]}],"ธ":[{"ก":[{"ร":[{},[0,0,5]],"ะ":[{},[0,5]]}],"น":[{"ะ":[{},[0,5]]}],"ุ":[{"ก":[{},[0,5]],"ร":[{},[0,5]],"ว":[{},[0,5]],"ศ":[{},[0,5]]}],"ไ":[{"ม":[{},[0,0,5]]}]}],"น":[{"ต":[{},[0,4]],"ท":[{},[0,4]],"ร":[{".":[{},[0,7]]},[0,4]]},[0,1]],"บ":[{"น":[{"อ":[{},[0,0,5]]}]},[0,1]],"ป":[{"จ":[{"ู":[{},[0,0,5]]},[0,4]],"ท":[{},[0,4]]},[0,1]],"พ":[{"ป":[{"ฎ":[{},[0,0,5]]}],"ศ":[{"ู":[{},[0,0,5]]}],".":[{},[7]]},[0,1]],"ภ":[{"ศ":[{"ู":[{},[0,0,5]]}]}],"ย":[{"น":[{"ต":[{},[0,5]]}],"ำ":[{},[0,7]],"ิ":[{},[0,7]],"ะ":[{},[0,7]],"ง":[{},[0,7]]}],"ร":[{"า":[{},[0,3]],"ำ":[{},[0,7]],"ี":[{".":[{},[0,5]]}],"น":[{".":[{},[0,7]]}],"ถ":[{".":[{},[0,7]]}]}],"ฤ":[{"ค":[{"ห":[{},[0,0,5]]}],"ป":[{"เ":[{},[0,0,5]]}],"เ":[{"ท":[{},[0,0,5]],"บ":[{},[0,0,5]]}]}],"ล":[{"ล":[{},[0,4]]},[0,1]],"ว":[{"ร":[{"่":[{},[0,0,5]]}],"ก":[{"ะ":[{},[0,0,7]]}]}],"ศ":[{},[0,1]],"ษ":[{"ก":[{"ร":[{},[0,0,5]]}]}],"ส":[{"ฟ":[{"อ":[{},[0,0,5]]}],"แ":[{"ด":[{},[0,0,5]],"ต":[{},[0,0,5]]}]},[0,1]],"ห":[{},[0,1]],"อ":[{"ก":[{"ะ":[{},[0,0,5]]}],"น":[{},[3]]}],"ั":[{"ก":[{},[0,0,0,7]]},[1]],"า":[{"ค":[{"ร":[{".":[{},[0,0,7]]},[0,0,4]]}],"ณ":[{"ั":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]]}],"ร":[{"ย":[{},[0,0,5]]}],"ว":[{"ต":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ส":[{"ณ":[{},[0,0,5]],"น":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ฬ":[{"ิ":[{},[0,0,5]]}],"ะ":[{},[4]]},[1]],"ิ":[{"จ":[{"ู":[{},[0,0,5]]}],"ด":[{"้":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ม":[{"น":[{"า":[{},[0,0,0,6]]},[0,0,5]]}],"ย":[{"ม":[{},[0,0,5]],"า":[{},[0,0,5]],"ต":[{},[0,0,7]]}],"ร":[{"อ":[{},[0,0,5]]}],"ล":[{"ุ":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}],"ส":[{"ง":[{},[0,0,5]],"ถ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"แ":[{"ด":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ค":[{"ห":[{"ะ":[{},[0,0,0,7]]}]}]},[1]],"ุ":[{"พ":[{"ย":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ู":[{},[1]],"เ":[{},[2,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"่":[{"อ":[{"ี":[{},[0,0,5]]}]}],"้":[{"อ":[{},[3]],"ำ":[{},[1]]}],"์":[{"ส":[{"ไ":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ง":[{"ก":[{},[0,7]]}],"ำ":[{},[5]],"ี":[{".":[{},[5]],"ย":[{"ะ":[{},[0,0,7]]}]}]}],"บ":[{"ก":[{"ษ":[{},[0,4]],"ิ":[{"ส":[{},[0,0,0,0,5]]}],"แ":[{},[0,4]]},[0,1]],"ข":[{},[0,1]],"ค":[{"ท":[{"ี":[{},[0,0,5]]},[0,4]],"โ":[{},[0,4]]},[0,1]],"ด":[{"ี":[{".":[{},[1]]}]}],"ท":[{"ค":[{"ว":[{},[0,6]]}],".":[{},[5]]},[0,1]],"บ":[{"ฉ":[{"บ":[{},[0,0,5]]}],"ฝ":[{"ึ":[{},[0,0,5]]}],"อ":[{"ย":[{},[0,0,5]]}]}],"ป":[{},[0,1]],"พ":[{},[0,1]],"ร":[{"ม":[{"ี":[{},[0,0,5]]}],"ั":[{"ด":[{},[0,5]]}],"ร":[{"จ":[{},[0,0,0,7]],"ถ":[{},[0,0,0,7]],"พ":[{"ต":[{},[0,0,0,7]]}]}]}],"ส":[{"บ":[{},[0,4]],"เ":[{},[0,0,4]],".":[{},[5]]},[0,1]],"ห":[{},[0,1]],"อ":[{"ด":[{"ี":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{},[3]]}],"ั":[{"พ":[{"พ":[{"า":[{"ช":[{"น":[{"ี":[{},[0,0,0,0,0,0,0,0,5]]}]}]}]}]}]},[1]],"า":[{"จ":[{"ร":[{},[0,0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]},[0,0,4]],"ท":[{"า":[{},[0,0,5]],"ุ":[{},[0,0,5]]},[0,0,2]],"ร":[{"น":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}]},[1]],"ิ":[{"ก":[{"้":[{},[0,0,5]]}],"ช":[{"อ":[{},[0,0,5]]}],"น":[{},[3]],"์":[{".":[{},[6]]}],"ว":[{"ล":[{"า":[{},[0,0,0,7]]}]}]}],"ี":[{"ค":[{"ิ":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}]}],"ุ":[{"ค":[{},[0,0,0,3]],"ต":[{"ร":[{".":[{},[0,0,6]]},[0,0,5]]}],"ถ":[{"ุ":[{},[0,0,5]]}],"ร":[{"พ":[{},[0,0,5]],"ิ":[{"ม":[{"ส":[{"ิ":[{"ท":[{"ธ":[{"ิ":[{".":[{},[0,0,0,0,0,0,0,0,6]]}]}]}]}]}]}]}]}],"์":[{".":[{},[6]]}]},[1]],"ู":[{"ช":[{"น":[{},[0,0,4,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"ย":[{"่":[{},[0,0,5]]}]},[1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"๊":[{"จ":[{"ี":[{},[0,0,5]]}],"เ":[{"บ":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ถ":[{".":[{},[5]]}],"ะ":[{".":[{},[5]]}],"ย":[{"ก":[{".":[{},[0,7]]}],"ล":[{".":[{},[0,7]]}]}],"ต":[{"ก":[{".":[{},[0,7]]}]}]}],"ป":[{"ก":[{"ส":[{},[0,0,4]]}],"จ":[{"ั":[{},[0,4]],"า":[{},[0,4]]}],"ฐ":[{"ป":[{"ท":[{},[0,0,5]]}],"พ":[{"ี":[{},[0,0,5]]}],"ว":[{"ี":[{},[0,0,7]]}]}],"ต":[{"ถ":[{"ก":[{},[0,0,5]]}],"พ":[{"ล":[{},[0,0,5]]}]}],"ป":[{"เ":[{},[0,4]]},[0,1]],"ม":[{"ด":[{"้":[{},[0,0,5]]}]}],"ย":[{"ุ":[{},[0,4]],"ะ":[{},[0,7]]}],"ร":[{"ต":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ผ":[{"ั":[{},[0,0,5]]}],"ษ":[{"ณ":[{},[0,0,5]]}],"ะ":[{},[1]],"ิ":[{"ค":[{},[0,5]]}],"แ":[{"ก":[{},[0,0,5]],"ท":[{},[0,0,5]]}],"ไ":[{"บ":[{},[0,0,5]],"ฟ":[{},[0,0,5]]}]}],"ล":[{"ญ":[{"ว":[{},[0,0,5]]}]}],"ว":[{"า":[{},[0,4]]}],"ส":[{"ต":[{},[0,0,4]]}],"ั":[{},[1]],"า":[{"ฐ":[{"ก":[{},[0,0,5]]}],"ณ":[{"ก":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ป":[{"ิ":[{},[0,0,5]]}],"ร":[{"เ":[{},[0,0,5]]},[0,0,0,4]]},[1]],"ิ":[{"ด":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ย":[{"ภ":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ห":[{"ก":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"ช":[{"ี":[{},[0,0,5]]}],"ฬ":[{"ก":[{},[0,0,5]]}],"่":[{},[0,0,0,3]],".":[{},[7]]}],"ุ":[{"ค":[{"ล":[{},[0,0,5]]}],"ถ":[{"ุ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"จ":[{"๋":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}]}],"เ":[{},[0,1]],"ไ":[{},[0,1]],".":[{},[6]],"์":[{".":[{},[6]]}],"โ":[{"ย":[{},[0,6]],"ภ":[{},[0,6]]},[0,5]],"ธ":[{"ิ":[{},[0,7]]}],"ะ":[{".":[{},[5]]}],"ท":[{"ม":[{".":[{},[0,7]]}],"า":[{".":[{},[0,6]]}]}],"ผ":[{"ะ":[{},[0,7]]}]}],"ผ":[{"ก":[{"ผ":[{"ั":[{},[0,0,5]]}]}],"ณ":[{"ิ":[{"ศ":[{},[0,0,0,5]]}]}],"น":[{"ผ":[{"ั":[{},[0,0,5]]}],"ิ":[{},[0,4]]}],"ย":[{"า":[{},[0,4]],"อ":[{".":[{},[0,6]]}]}],"ล":[{"พ":[{"ล":[{},[0,0,5]]}],"ไ":[{"ม":[{},[0,0,5]]}]},[5]],"ส":[{"า":[{},[0,4]]}],"ี":[{"ด":[{"ิ":[{},[0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]}],"ถ":[{"้":[{},[0,0,5]]}],"ห":[{"่":[{},[0,0,5]]}]},[5]],"้":[{"า":[{},[0,0,0,3]]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ว":[{"า":[{},[0,6]]}],"ง":[{},[5]],"า":[{},[5]]}],"ฝ":[{"อ":[{"ย":[{},[3]]}],"่":[{"ฝ":[{"ั":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}]}],"พ":[{"จ":[{"น":[{"ี":[{},[0,0,5]]},[3]]}],"ช":[{"ฉ":[{"ล":[{},[0,0,5]]}]}],"ต":[{"ิ":[{},[0,3]],".":[{},[5]]}],"ท":[{"ร":[{"ิ":[{},[0,0,5]]}],"ั":[{"ก":[{},[0,0,0,0,4]]}]}],"น":[{"ท":[{"ะ":[{},[0,0,5]]}],"ั":[{},[0,4]],"ิ":[{},[0,0,0,4]]}],"พ":[{},[0,1]],"ย":[{"ก":[{"๊":[{},[0,0,5]]}],"า":[{"ธ":[{"ิ":[{".":[{},[0,0,0,6]]}]}]}]},[2,2]],"ร":[{"ช":[{"ย":[{},[0,0,5]]}],"ซ":[{"ี":[{},[0,0,5]]}],"ม":[{"ี":[{},[0,0,5]]}],"ร":[{"ด":[{"ิ":[{},[0,0,0,6]]}]},[1]],"ู":[{},[0,4]],"ไ":[{"ฟ":[{},[0,0,5]]}],"ี":[{".":[{},[0,7]]}],"ส":[{},[0,6]],".":[{},[5]]}],"ฤ":[{"ก":[{},[3]],"ฒ":[{"า":[{},[0,0,5]]}],"ษ":[{"ภ":[{".":[{},[0,0,7]]}]}]}],"ล":[{"ท":[{"ิ":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}],".":[{},[5]]}],"ส":[{"เ":[{"ฟ":[{},[0,0,5]]}],"พ":[{},[0,7]]}],"อ":[{"ค":[{"ว":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}]}],"ั":[{},[1]],"า":[{"จ":[{},[4]],"ช":[{"น":[{},[0,0,5]]}],"น":[{"ร":[{},[0,0,5]]}]},[1]],"ิ":[{"ถ":[{"ั":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ป":[{"ล":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ล":[{"ึ":[{},[0,0,5]]}],"ศ":[{"ุ":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ี":[{"ร":[{"ะ":[{},[0,0,5]]}],".":[{},[5]]}],"ุ":[{"ช":[{"ิ":[{},[0,0,5]]}],"พ":[{"อ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ท":[{"ว":[{},[0,0,5]]}],"พ":[{"อ":[{},[0,0,5]]}],"น":[{"ท":[{},[0,0,7]]}]}],"เ":[{"ย":[{},[0,4]]},[0,1]],"่":[{"ป":[{"๊":[{},[0,0,5]]}],"อ":[{},[0,0,0,3]]}],"้":[{"ท":[{"้":[{},[0,0,5]]}]}],"์":[{"ด":[{"ี":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ญ":[{"า":[{},[0,6]]}],"ด":[{"ี":[{},[0,7]]}],"ก":[{".":[{},[5]]}]}],"ฟ":[{"ซ":[{"ต":[{"ิ":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}]}],"ร":[{"ต":[{"ิ":[{},[0,0,5]]}]}],"ส":[{"ต":[{"ิ":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}]}],"ั":[{},[1]],"า":[{},[1]],"ิ":[{"ล":[{"า":[{},[0,0,4]]}],"์":[{".":[{},[6]]}]},[1]],"ี":[{"ฟ":[{"่":[{},[0,0,5]]}]}],"ู":[{"ฟ":[{"่":[{},[0,0,5]]}]},[7]],"เ":[{},[0,1]],"้":[{},[1]],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ะ":[{},[5]],"ง":[{},[5]]}],"ภ":[{"ค":[{"ท":[{"ร":[{},[0,0,5]]}],"ว":[{},[0,0,3]]}],"ช":[{"น":[{"ี":[{},[0,0,5]],"ะ":[{},[0,0,7]]}]}],"ั":[{"ต":[{"ต":[{"ิ":[{},[0,0,0,6]]}]}]},[1]],"า":[{"ณ":[{"ก":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ร":[{"ด":[{},[0,0,5]],"ต":[{},[0,0,5]],"ย":[{},[0,0,5]]}],"ว":[{"น":[{},[0,0,5]]}]},[1]],"ิ":[{"ช":[{"น":[{},[0,0,5]]}],"ม":[{"ห":[{},[0,0,5]]}],"ร":[{},[0,0,3]],"ส":[{"ม":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"ษ":[{"ม":[{},[0,0,5]]}]}],"ุ":[{"ช":[{"ง":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ม":[{"ร":[{},[0,0,0,7]]}]}],"ู":[{"ฏ":[{"า":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}]},[1]],".":[{},[6]],"์":[{".":[{},[6]]}],"ว":[{"น":[{"ะ":[{},[0,0,7]]}]}],"ร":[{"ี":[{},[0,7]],".":[{},[5]]}],"ม":[{"ร":[{"ี":[{},[0,0,7]]}]}],"พ":[{".":[{},[7]]}],"ะ":[{},[5]]}],"ม":[{"ก":[{"ม":[{},[0,4]],"ษ":[{},[0,4]]},[0,1]],"ข":[{"ล":[{"า":[{},[0,0,7]]},[0,4]]},[0,1]],"ค":[{"ร":[{},[0,3]],"อ":[{"ิ":[{},[0,0,5]]}],"ด":[{},[0,7]]}],"ง":[{"ค":[{"ล":[{},[1]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ว":[{"ง":[{},[0,0,6]]}]}],"จ":[{},[0,1]],"ช":[{"ว":[{},[0,0,4]]},[0,1]],"ซ":[{},[0,1]],"ณ":[{"ฑ":[{"น":[{},[0,0,5]],"ก":[{},[0,0,7]]},[3]],"บ":[{"ร":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]]}],"เ":[{"ฑ":[{},[0,0,5]],"พ":[{},[0,0,5]]}],"ี":[{},[0,6]],"โ":[{"ฑ":[{},[0,0,7]]}]}],"ด":[{"ช":[{"ม":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]]}],"ล":[{"ู":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ต":[{"ธ":[{},[0,4]],"ิ":[{},[0,4]],"ไ":[{"ต":[{},[0,0,5]]},[0,4]],"น":[{},[0,7]]},[0,1]],"ท":[{"น":[{"ะ":[{},[0,0,7]],"ี":[{},[0,0,6]]}]},[0,1]],"น":[{"ต":[{"ร":[{},[3]]}],"ฮ":[{"ั":[{},[0,0,5]]}],"ุ":[{},[0,4]],".":[{},[5]]}],"บ":[{"พ":[{},[0,0,4]]},[0,1]],"ป":[{"ช":[{},[0,0,4]],"ท":[{},[0,0,4]],"ฤ":[{"ด":[{},[0,0,5]],"ๅ":[{},[0,0,5]]}],"์":[{},[0,4]]},[0,1]],"พ":[{"ก":[{},[0,4]],"ว":[{},[0,4]]},[0,1]],"ภ":[{"ก":[{"ถ":[{},[0,0,5]]}]},[0,1]],"ม":[{"เ":[{},[0,4]],"โ":[{},[0,4]]},[0,1]],"ย":[{"ร":[{"า":[{},[0,0,5]]}],"ำ":[{},[0,7]],"ง":[{},[0,7]]}],"ร":[{"ร":[{},[3]],"ั":[{},[0,3]],"ิ":[{},[0,1]],"ี":[{".":[{},[0,7]]}],"า":[{},[0,7]],"ม":[{},[0,7]],"ก":[{"ต":[{},[0,0,7]]}],"ฑ":[{"ป":[{},[0,0,7]]}]}],"ฤ":[{"ค":[{"ิ":[{},[0,0,5]]}],"เ":[{"ค":[{},[0,0,5]]}]}],"ล":[{"ท":[{"ิ":[{},[0,0,5]]}],"า":[{},[0,3]],"ิ":[{},[0,3]],"้":[{},[0,3]],"ก":[{"ะ":[{},[0,0,7]]}],".":[{},[5]]}],"ว":[{"ม":[{"อ":[{},[0,0,5]]}],"ล":[{},[0,4]],"ก":[{},[0,6]],"น":[{},[0,6]],"ด":[{"ี":[{},[0,7]]},[0,6]],"ย":[{},[0,6]]},[0,1]],"ส":[{},[0,1]],"ห":[{"ก":[{"ร":[{},[0,0,5]]}],"น":[{},[0,3]],"ภ":[{"า":[{},[0,0,5]]}],"า":[{"ญ":[{},[0,5]],"ย":[{},[0,5]],"ส":[{},[0,0,0,3]]}]}],"อ":[{"ข":[{"ว":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]]}],"ด":[{"ู":[{},[0,0,5]]}],"ต":[{"ำ":[{},[0,0,5]]}],"น":[{"ว":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]],".":[{},[0,7]]}],"ั":[{},[4]]}],"ะ":[{"ถ":[{"ั":[{},[0,0,5]]}],"ฝ":[{"่":[{},[0,0,5]]}],"ฮ":[{"อ":[{},[0,0,5]]}]},[5]],"ั":[{"่":[{},[0,4]]},[1]],"า":[{"ด":[{"ร":[{},[0,0,5]]}],"น":[{"ร":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ป":[{"่":[{},[0,0,5]]}],"พ":[{"จ":[{},[0,0,5]]}],"ม":[{"ก":[{},[0,0,5]],"ุ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ย":[{"ณ":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}],"ว":[{},[0,0,3,4]],"ต":[{"ฤ":[{},[0,0,7]]}]},[1]],"ิ":[{"ก":[{"ภ":[{},[0,0,5]]}],"ซ":[{"ร":[{},[0,0,5]]}],"ต":[{"ล":[{},[0,0,5]]}],"ถ":[{"ิ":[{},[0,0,5]]}],"น":[{"่":[{},[0,0,5]]}],"ฟ":[{"ล":[{},[0,0,5]]}],"ล":[{"ำ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"แ":[{"พ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ผ":[{},[0,0,7]]},[1]],"ี":[{"ข":[{"ม":[{},[0,0,5]]}]}],"ื":[{"ด":[{},[3]],"อ":[{".":[{},[1]]}]}],"ุ":[{"ท":[{"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ต":[{"ต":[{"ิ":[{},[0,0,0,6]]}]}]}],"ู":[{"ซ":[{"ี":[{},[0,0,5]]}],"ป":[{"่":[{},[0,0,5]]}],"ร":[{"ต":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ห":[{"ย":[{},[0,0,5]],"ร":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}],"แ":[{"ด":[{},[0,0,5]],"ผ":[{},[0,0,5]],"ฮ":[{},[0,0,5]]}]}],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{"ห":[{},[0,0,0,5]]},[0,1]],"ไ":[{"ห":[{},[0,6]]},[0,1]],"่":[{"า":[{},[0,4]]}],"้":[{"ม":[{},[0,0,0,4]],"า":[{},[3]]}],"์":[{"ภ":[{"ิ":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]]}],"ย":[{"ก":[{"ย":[{"่":[{},[0,0,5]]}],"ร":[{"้":[{},[0,4,5]]},[0,1]],"น":[{"ะ":[{},[0,0,7]]}]}],"ค":[{},[0,1]],"ง":[{"บ":[{"่":[{},[0,0,5]]}],"ฝ":[{"้":[{},[0,0,5]]}],"อ":[{"ย":[{},[0,0,5]]}]}],"จ":[{"ค":[{"ร":[{},[0,0,5]]}]}],"ด":[{"ย":[{"้":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ต":[{},[0,1]],"ท":[{},[0,1]],"ธ":[{},[0,1]],"บ":[{"ร":[{"้":[{},[0,0,5]]}]}],"ป":[{},[0,1]],"พ":[{},[0,1]],"ภ":[{},[0,1]],"ม":[{"ย":[{"อ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ห":[{"า":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}],"ิ":[{},[0,4]]}],"ย":[{"ส":[{},[0,0,4]]},[0,1]],"ร":[{"ถ":[{"ี":[{},[0,0,5]]}],"บ":[{"ั":[{},[0,5,4]]}],"ำ":[{},[0,7]],"า":[{},[0,7]],"ก":[{".":[{},[0,7]]}]}],"ล":[{"ไ":[{"ท":[{},[0,0,5]]}],"ะ":[{},[0,7]],"ำ":[{},[0,7]]}],"ว":[{"ข":[{"้":[{},[0,0,5]]}],"จ":[{"๊":[{},[0,0,5]]}],"ด":[{"อ":[{},[0,0,5]],"ี":[{},[0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ย":[{"่":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]],"ก":[{".":[{},[0,0,7]]}]}],"ไ":[{"ส":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ศ":[{".":[{},[5]]},[0,1]],"ส":[{},[0,1]],"ห":[{"ฐ":[{"า":[{},[0,0,5]]},[0,4]],"ป":[{"ร":[{},[0,0,5]]},[0,4]]},[0,1]],"อ":[{"บ":[{"ี":[{},[0,0,5]]}],"ร":[{"ม":[{},[0,0,5]]}],".":[{},[5]],"ด":[{"อ":[{"ก":[{},[0,0,0,7]]}]}]}],"ั":[{},[1]],"า":[{"ก":[{"ฤ":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ฉ":[{"ุ":[{},[0,0,5]]}],"ณ":[{"ม":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ถ":[{"่":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ร":[{"ช":[{},[0,0,5]]}],"ส":[{"ล":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ฬ":[{"ั":[{},[0,0,5]]}]},[1]],"ำ":[{"ท":[{"ว":[{},[0,0,5]]}]}],"ี":[{"ร":[{"า":[{},[0,0,5]]}],".":[{},[5]]}],"ุ":[{"ค":[{"ล":[{},[0,0,5]]}],"ต":[{"ก":[{},[0,0,5]]}],"ภ":[{},[4]],"แ":[{"ย":[{},[0,0,5]],"ห":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ู":[{"ค":[{"ล":[{},[0,0,5]]}],"ถ":[{"ิ":[{},[0,0,5]]}],"ฟ":[{"่":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ไ":[{"น":[{},[0,0,5]]}],".":[{},[5]]}],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"์":[{"ก":[{"ล":[{},[0,0,5]]}],"ถ":[{"่":[{},[0,0,5]]}],"ม":[{"น":[{"า":[{},[0,0,0,6]]},[0,0,5]]}],"ห":[{"น":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ิ":[{"์":[{".":[{},[6]]}]}],"น":[{"ะ":[{},[0,7]]}],"ื":[{"ด":[{"อ":[{"ก":[{},[0,0,0,7]]}]}]}],"ช":[{"ม":[{".":[{},[0,7]]}]}]}],"ร":[{"ก":[{"ซ":[{"อ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"้":[{},[0,0,5]]},[0,1]]},[2]],"ค":[{"พ":[{"ว":[{},[0,0,5]]}],"ต":[{},[0,7]]}],"ง":[{"พ":[{"ย":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}]}],"จ":[{"ถ":[{"ร":[{},[0,0,5]]}]}],"ช":[{"ก":[{},[0,4]],"ช":[{},[0,4]],"น":[{},[0,4]],"ย":[{},[0,4]],"ะ":[{},[0,5]],"ร":[{".":[{},[0,7]]}]},[0,1]],"ณ":[{"ค":[{"ด":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"ถ":[{"ั":[{},[0,0,5]]}],"พ":[{"ฤ":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}],"า":[{"ญ":[{},[0,5]]}],"ู":[{"ป":[{},[0,0,0,5]]}],"์":[{},[4]],"ะ":[{},[0,5]]}],"ด":[{"ป":[{},[0,4]],"แ":[{},[0,4]],"โ":[{},[0,4]],"ไ":[{"อ":[{},[0,0,5]]},[0,4]]},[0,1]],"ถ":[{"พ":[{"ย":[{},[0,0,5]]}],"ี":[{},[0,7]]},[0,0,1]],"ท":[{"ฤ":[{"ด":[{},[0,0,5]]},[0,4]],"ว":[{"ิ":[{},[0,0,5]]},[0,4,4]]},[0,1]],"ธ":[{"ข":[{"ึ":[{},[0,0,5]]}],"ส":[{"ร":[{},[0,0,5]]}],"เ":[{"ก":[{},[0,0,5]]}],"ก":[{"ะ":[{},[0,0,7]]}]}],"น":[{"ท":[{"ุ":[{},[0,0,5]]}],"า":[{},[4]]}],"บ":[{"ค":[{},[0,4]],"ถ":[{"้":[{},[0,0,5]]},[0,4]],"ม":[{},[0,4]],"ไ":[{"ก":[{},[0,0,5]]},[0,4]],"ร":[{"า":[{},[0,0,7]]}]},[0,1]],"ป":[{"ณ":[{"ะ":[{},[0,0,7]]},[0,4]]},[0,1]],"พ":[{"ช":[{"า":[{},[0,5]],"ิ":[{},[0,5,5]]}],"ท":[{"ิ":[{},[0,0,5]]}],"ี":[{},[0,6]]}],"ภ":[{"ย":[{},[0,4]]},[0,1]],"ม":[{"ร":[{"อ":[{},[0,0,5]]}],"า":[{"ว":[{},[0,0,0,0,5]]}],"เ":[{"ห":[{},[0,0,4]]}],"น":[{"ี":[{},[0,0,6]]}],"ะ":[{},[0,6]]}],"ย":[{"ั":[{},[0,4]]}],"ร":[{"ก":[{},[0,0,4]],"ค":[{"า":[{},[0,0,5]]}],"จ":[{"ถ":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ณ":[{"ึ":[{},[0,0,5]]}],"ถ":[{"า":[{},[0,0,5]]}],"ย":[{"ง":[{},[0,0,5]],"เ":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ล":[{},[0,0,3]],"ห":[{"า":[{},[0,0,5]]}],"แ":[{"ท":[{},[0,0,5]],"ส":[{},[0,0,5]]}],"ไ":[{"ก":[{},[0,0,5]],"ต":[{},[0,0,5]]}],"ธ":[{"น":[{"ะ":[{},[0,0,0,7]]}]}],"ำ":[{},[0,7]],"ม":[{"ะ":[{},[0,0,7]]}],"ต":[{"ุ":[{},[0,0,6]]}],"ด":[{"ิ":[{".":[{},[0,0,6]]}]}]}],"ศ":[{"น":[{"ี":[{},[0,0,5]]}],"ร":[{},[0,7]]}],"ษ":[{"ฐ":[{"ิ":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"า":[{},[0,7]]}],"ส":[{"ก":[{"า":[{},[0,0,7]]},[0,4]],"ช":[{},[0,4]],"เ":[{},[0,4]],"โ":[{},[0,4,4]],".":[{},[5]]},[0,1]],"ห":[{"ิ":[{},[0,3]]}],"ะ":[{"ส":[{"า":[{},[0,0,5]]}],"ห":[{"ก":[{},[0,0,5]]}]},[0,0,1]],"ั":[{"ง":[{"ส":[{},[5]]}],"ฐ":[{},[3]],"ต":[{},[1]]}],"า":[{"ก":[{"ฏ":[{},[0,0,5]],"ฤ":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ช":[{"ู":[{},[0,0,5]]},[1]],"ด":[{"ร":[{},[0,0,5]],"ว":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ม":[{"่":[{},[0,0,5]]}],"ว":[{"ณ":[{},[0,0,5]]}],"ส":[{"ง":[{},[0,0,5]]}],"ห":[{"ุ":[{},[0,0,5]]},[0,0,2]]}],"ำ":[{"ง":[{"ั":[{},[0,0,5]]}],"จ":[{"ว":[{},[0,0,5]]}]}],"ิ":[{"ก":[{"อ":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"ท":[{"ึ":[{},[0,0,5]]}],"พ":[{},[4]],"ม":[{"น":[{},[0,0,5]]}],"ย":[{"จ":[{},[4]],"ย":[{},[4]]}],"ร":[{},[4]],"แ":[{"ล":[{},[0,0,5]]}],"่":[{},[4]],"์":[{".":[{},[6]]}]}],"ี":[{"ค":[{"ู":[{},[0,0,5]]}],"ฑ":[{"า":[{},[0,0,5]]}],"ด":[{"ู":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]],"า":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ส":[{"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]]}],"ผ":[{},[0,0,7]],"ย":[{"ะ":[{},[0,0,5]]}]}],"ุ":[{"ก":[{"ว":[{},[0,0,5]]}],"ข":[{"ร":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]]}],"ท":[{"ว":[{},[0,0,5]]}],"ธ":[{"ิ":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"ว":[{"น":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ต":[{"ิ":[{},[0,0,7]]}]}],"ู":[{"ท":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"บ":[{"ิ":[{},[0,0,5]]}],"ป":[{"ก":[{},[0,0,0,5]],"ิ":[{},[0,0,5]]}],"ม":[{"า":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ห":[{"ร":[{},[0,0,5]]}]},[1]],"เ":[{},[2,1]],"โ":[{},[0,1]],"่":[{"ก":[{"ะ":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]]}]}],"์":[{"ก":[{"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ค":[{"ั":[{},[0,0,5]]}],"ด":[{"ิ":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],"ว":[{"อ":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ว":[{"ณ":[{"ะ":[{},[0,0,7]]}]}],"ต":[{"น":[{"ะ":[{},[0,0,7]]}],"ะ":[{},[0,6]],"ี":[{},[0,7]]}],"ล":[{"ี":[{},[0,7]],"ะ":[{},[0,7]]}]}],"ฤ":[{"ด":[{"า":[{},[0,4]]}],"ป":[{"เ":[{},[0,0,4]]}],"ษ":[{"ฎ":[{"ี":[{},[0,0,5]]}],"ณ":[{"ะ":[{},[0,0,7]]}]}],"ห":[{"บ":[{"ด":[{},[0,0,5]]}]}],"ช":[{"า":[{},[0,6]]}],"ๅ":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ล":[{"ก":[{"น":[{"ะ":[{},[0,5]]}],"ล":[{"า":[{},[0,0,5]]}],"ว":[{"ั":[{},[0,0,5]]}],"อ":[{},[0,3]],"ั":[{"ย":[{},[0,4]]}]}],"ข":[{"ค":[{"ณ":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]]}]}],"ช":[{"ี":[{},[0,0,0,4]],"น":[{},[0,7]]}],"ด":[{"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"า":[{},[0,4]]}],"ต":[{"ฟ":[{"อ":[{},[0,0,5]]},[0,4]]},[0,1]],"บ":[{"ต":[{"ะ":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"ล":[{"้":[{},[0,0,5]]}],"ไ":[{"ส":[{},[0,0,5]]}],"ก":[{".":[{},[0,7]]}]}],"ป":[{"ต":[{"อ":[{},[0,0,5]]}]}],"ม":[{"ค":[{"้":[{},[0,0,5]]}],"ง":[{"ว":[{},[0,0,5]]}],"อ":[{},[0,3]],"ี":[{},[0,7]]}],"ย":[{},[2]],"ล":[{},[0,1]],"ว":[{"ี":[{},[0,3]],"ไ":[{"ห":[{},[0,0,5]]}],"ณ":[{"ะ":[{},[0,0,7]]}],"น":[{"ะ":[{},[0,0,7]]}]}],"ส":[{"ไ":[{"ต":[{},[0,0,5]]}],"ก":[{"า":[{},[0,0,7]]}]}],"ห":[{"ก":[{"ุ":[{},[0,0,5]]}]}],"อ":[{"ก":[{"ล":[{},[0,0,0,5]]}],"จ":[{"ี":[{},[0,0,5]]}],"ส":[{"ร":[{},[0,0,5]]}]}],"ะ":[{"ผ":[{"ล":[{},[0,0,5]]}]}],"ั":[{"ก":[{"ษ":[{},[1]]}]}],"า":[{"ก":[{"ล":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ป":[{"๋":[{},[0,0,5]]}],"พ":[{"อ":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"้":[{},[0,0,5]]},[3]],"ฤ":[{"ก":[{},[0,0,5]]}],"ส":[{"้":[{},[0,0,5]]}]}],"ิ":[{"ก":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]],"ร":[{"า":[{},[0,0,0,7]]}]}],"จ":[{"ู":[{},[0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]}],"น":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ม":[{"ู":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"บ":[{"ง":[{},[0,0,7]]}]}],"ี":[{"ต":[{"ะ":[{},[0,0,5]]}],"น":[{},[3]],"ผ":[{"ล":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]]}],"ว":[{"ู":[{},[0,0,5]]}]}],"ุ":[{"ก":[{"ร":[{},[0,0,0,5]],"ล":[{},[0,0,0,5]]}],"ล":[{"่":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ก":[{},[0,0,0,1]],"ซ":[{"ี":[{},[0,0,5]]}],"ท":[{"ี":[{},[0,0,5]]}],"ม":[{"ิ":[{},[0,0,3]]}],"ล":[{"อ":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]]}],"แ":[{"บ":[{},[0,0,5]]}]}],"เ":[{},[2,1]],"แ":[{},[2,1]],"โ":[{},[0,1]],"่":[{"ต":[{"ิ":[{},[0,0,5]]}],"ท":[{"ี":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]]}]}],"้":[{"โ":[{"พ":[{},[0,0,5]]}]}],"์":[{"ส":[{"ต":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ณ":[{"ะ":[{},[0,7]]}],"ร":[{"บ":[{".":[{},[0,7]]}]}]}],"ว":[{"ก":[{"ร":[{},[0,3]],"ว":[{"่":[{},[0,0,5]],"น":[{},[0,0,7]]}],"า":[{"ร":[{},[0,5]]}]}],"ค":[{},[0,1]],"ง":[{"ศ":[{},[1]]}],"จ":[{"ต":[{"ร":[{},[0,0,5]]}],"ส":[{"อ":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}]}],"ช":[{"น":[{"ี":[{},[0,0,5]]}]}],"ด":[{"ถ":[{"่":[{},[0,0,5]]}],"ม":[{"ว":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]],"้":[{},[0,0,5]]}],"อ":[{"้":[{},[0,0,5]]}]}],"ต":[{"ฉ":[{},[0,4]],"ก":[{},[0,7]]},[0,1]],"น":[{"ถ":[{"ี":[{},[0,0,5]]}],"ท":[{"้":[{},[0,0,5]]}],"ผ":[{"ส":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]],"่":[{},[0,0,5]]}],"อ":[{"ิ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ม":[{".":[{},[0,7]]}]}],"บ":[{"ย":[{"อ":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ฮ":[{"า":[{},[0,0,5]]}]}],"ป":[{},[0,1]],"พ":[{},[0,1]],"ม":[{"ร":[{"อ":[{},[0,0,5]]}],"ู":[{},[0,3]],"ี":[{},[0,7]]}],"ย":[{"ก":[{"้":[{},[0,0,5]]}],"จ":[{"ี":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ื":[{},[0,0,5]]}],"ล":[{"้":[{},[0,0,5]]}],"ไ":[{"ท":[{},[0,0,5]],"ม":[{},[0,0,5]]}]}],"ร":[{"ธ":[{"ิ":[{},[0,0,5]]}],"ม":[{"ณ":[{},[0,0,5]],"ห":[{},[0,0,5]]}],"ย":[{},[0,4]],"ร":[{"ณ":[{},[3]]},[0,0,0,4]],"์":[{},[0,4]],"บ":[{".":[{},[0,7]]}]}],"ล":[{"ร":[{"ะ":[{},[0,0,5]]}],"ม":[{".":[{},[0,7]]}]}],"ส":[{"ป":[{"อ":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}],"ะ":[{},[0,6]]}],"ห":[{},[0,1]],"อ":[{"ช":[{"ิ":[{},[0,0,5]]}]}],"ั":[{"น":[{"ต":[{},[0,0,0,0,5]],"ท":[{},[0,0,0,0,4]]},[0,0,0,3]],"ง":[{"ว":[{"น":[{},[0,0,0,7]]}]}]},[1]],"า":[{"ด":[{"ะ":[{},[0,0,5]]}],"ต":[{"ก":[{},[0,0,5]],"ิ":[{},[0,0,5]]},[0,0,4]],"น":[{"ร":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ม":[{"น":[{},[0,0,5]]}],"ร":[{"ณ":[{},[0,0,5]]}],"ส":[{"น":[{"ะ":[{},[0,0,5]]}]}],"ห":[{"น":[{},[0,0,5]],"ิ":[{},[0,0,5]]},[0,0,4]]},[1]],"ิ":[{"ก":[{"ล":[{},[0,0,5]],"ส":[{},[0,0,5]]}],"ค":[{"ห":[{},[0,0,5]]}],"จ":[{"ุ":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,0,5]]}],"ต":[{"ก":[{},[0,0,5]],"ร":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ถ":[{"ี":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]},[3]],"ธ":[{"ุ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ป":[{"ก":[{},[0,0,5]],"ฏ":[{},[0,0,5]],"ล":[{},[0,0,5]],"ว":[{},[0,0,5]],"โ":[{"ย":[{},[0,0,0,7]]}]}],"ภ":[{"ู":[{},[0,0,0,0,5]]}],"ม":[{"ล":[{},[0,0,5]]}],"ร":[{"ง":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}],"ศ":[{"ร":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ษ":[{"ุ":[{},[0,0,5]]}],"ส":[{"ร":[{},[0,0,5]],"ฤ":[{},[0,0,5]]}],"เ":[{"ล":[{},[0,0,0,0,5]]}],"์":[{".":[{},[6]]}]},[1]],"ี":[{"ค":[{"ู":[{},[0,0,5]]}],"ช":[{"น":[{"ี":[{},[0,0,0,6]]},[0,0,5]]}],"ด":[{"ิ":[{},[0,0,5]]}],"ส":[{"ต":[{"ิ":[{},[0,0,0,7]]}]}]}],"ุ":[{"์":[{".":[{},[6]]}]},[1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"่":[{"ห":[{"้":[{},[0,0,5]]}]}],"้":[{"ช":[{"ื":[{},[0,0,5]]}],"ท":[{"ุ":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]]}]}],"์":[{"ล":[{"ิ":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ท":[{"น":[{"ะ":[{},[0,0,7]]}]}]}],"ศ":[{"จ":[{},[0,1]],"ต":[{"ว":[{"ร":[{},[0,0,5]]}],"ก":[{"ะ":[{},[0,0,7]]}]}],"น":[{"อ":[{"ุ":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"พ":[{"ิ":[{},[0,0,0,4]],".":[{},[7]]}],"ร":[{"ี":[{},[3]]}],"ษ":[{"ซ":[{"้":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}],"เ":[{"ก":[{},[0,0,5]],"ห":[{},[0,0,5]]}]}],"ั":[{"ก":[{"ร":[{},[0,0,0,5]]}]},[1]],"า":[{"ก":[{"า":[{},[0,0,5]]}],"ข":[{"บ":[{},[0,0,5]]},[0,0,5]],"น":[{"ุ":[{},[0,0,5]]}],"ภ":[{"ิ":[{},[0,0,5]]}],"ร":[{"ย":[{},[0,0,5]],"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]]}]},[1,0,2]],"ิ":[{"ร":[{"พ":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ศ":[{"ี":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ษ":[{"ฎ":[{"ิ":[{},[0,0,0,7]]}]}]},[1]],"ึ":[{},[1]],"ุ":[{"ก":[{"ล":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],".":[{},[5]]}],"ู":[{"ล":[{"ิ":[{},[0,0,5]]}]}],"เ":[{"จ":[{"ร":[{},[0,0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ม":[{"น":[{"ะ":[{},[0,0,7]]}],"ี":[{},[0,7]]}],"ก":[{".":[{},[5]]}],"ด":[{"ี":[{},[0,7]]}],"ะ":[{},[5]],"ี":[{".":[{},[5]],"ล":[{},[0,0,0,7]]}],"ภ":[{},[0,7]],"ล":[{".":[{},[5]]}],"ว":[{"ง":[{".":[{},[0,7]]}]}],"ย":[{"ป":[{".":[{},[0,7]]}]}]}],"ษ":[{"ฎ":[{"า":[{},[0,3]],"ร":[{".":[{},[0,7]]}]}],"ฐ":[{"ภ":[{"ค":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ม":[{"ณ":[{"ี":[{},[0,5]]}],"า":[{},[0,4]]}],"ั":[{},[1]],"า":[{"ค":[{"เ":[{},[0,0,5]]}]},[1]],"ิ":[{"์":[{".":[{},[6]]}]},[1]],"์":[{"พ":[{"ย":[{},[0,0,5]]}],".":[{},[6]]}],".":[{},[6]],"ุ":[{"์":[{".":[{},[6]]}]},[7]],"ย":[{"ะ":[{},[0,7]]}],"บ":[{},[0,7]],"ป":[{},[0,7]],"ี":[{".":[{},[5]]}],"ะ":[{},[7]],"ก":[{".":[{},[5]]}],"ฏ":[{"ิ":[{".":[{},[0,7]]}],"ี":[{},[0,7]],"ุ":[{},[0,7]]}],"ส":[{".":[{},[5]]}],"อ":[{"ร":[{},[0,7]]}]}],"ส":[{"ก":[{"ล":[{"ิ":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"ว":[{"ั":[{},[0,0,5]],"า":[{},[0,0,5]]}],"า":[{},[0,4]],"ุ":[{},[4,4]]}],"ข":[{"บ":[{"ุ":[{},[0,0,5]]}],"ะ":[{},[0,5]]}],"ง":[{"ข":[{"ล":[{},[0,0,5]]}],".":[{},[5]]}],"ซ":[{},[0,1]],"ด":[{"ช":[{"ื":[{},[0,0,5]]}],"ุ":[{"ภ":[{},[0,5]]},[0,4]],"ำ":[{},[0,6]],"ก":[{},[0,6]],"ม":[{},[0,6]]}],"ต":[{"ท":[{"ิ":[{},[0,0,5]]},[0,4]],"ร":[{"า":[{},[0,3]]}],"์":[{},[2]],"ุ":[{},[0,7]]}],"ถ":[{"ว":[{"ี":[{},[0,0,5]]}],"์":[{},[4]]}],"น":[{"ธ":[{"ย":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ี":[{"ย":[{"ะ":[{},[0,5]]}]}],"ุ":[{},[0,4]],"ู":[{"ป":[{},[0,0,0,0,5]]}]}],"ป":[{"า":[{},[0,4]],"ะ":[{},[0,6]]}],"ม":[{"ค":[{"ว":[{},[0,0,5]]}],"ด":[{"ุ":[{},[0,0,5]]}],"บ":[{},[3]],"ผ":[{"ส":[{},[0,0,5]],"ุ":[{},[0,0,5]],"เ":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]]}],"ฤ":[{"ด":[{},[0,0,5]],"ต":[{},[0,0,5]]}],"ห":[{"ว":[{},[0,0,5]]}],"ั":[{"ท":[{},[0,5]],"น":[{},[0,5]]}],"ุ":[{},[0,0,0,4]],"ณ":[{"ะ":[{},[0,0,7]]}],"า":[{".":[{},[0,5]]}],"ร":[{"ด":[{},[0,0,7]]}]},[0,2]],"ร":[{"ร":[{"ช":[{},[0,0,0,5]]}],"ล":[{"อ":[{},[0,0,5]]}],"ต":[{"ะ":[{},[0,0,7]]}],".":[{},[7]],"ถ":[{".":[{},[0,7]]}]}],"ล":[{"บ":[{"ร":[{},[0,0,5]]}],"ม":[{".":[{},[0,7]]}]}],"ว":[{"ก":[{},[0,0,4]],"ย":[{"ม":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ะ":[{},[0,0,7]],".":[{},[0,7]]}],"า":[{"ด":[{"ิ":[{},[0,0,0,6]]}]},[0,4]],"ิ":[{},[4]],"น":[{"ะ":[{},[0,0,5]]}],"ี":[{".":[{},[0,7]]}]}],"ส":[{"น":[{"ี":[{},[0,0,6]]}]},[0,1]],"ห":[{"ก":[{"ร":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ช":[{"า":[{},[0,0,5]]}],"ธ":[{"ร":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]]}],"พ":[{"ั":[{},[0,0,5]]}],"ภ":[{"า":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ศ":[{"ึ":[{},[0,0,5]]}]}],"อ":[{"พ":[{"ล":[{},[0,0,5]],"อ":[{},[0,0,5]]}],".":[{},[7]]}],"ะ":[{"ใ":[{"ภ":[{},[0,0,5]]}]},[5]],"ั":[{"ญ":[{"ป":[{"ร":[{"ะ":[{},[0,0,0,0,0,0,5]]}]}]}],"น":[{"ถ":[{},[0,0,0,3]]}],"ม":[{},[0,0,0,3]],"ก":[{"ว":[{"า":[{},[0,0,0,7]]}]}],"ป":[{"ด":[{},[0,0,0,7]],"ท":[{},[0,0,0,7]]}]},[1]],"า":[{"ค":[{"เ":[{},[0,0,5]]}],"ธ":[{},[4]],"น":[{"ึ":[{},[0,0,5]]}],"ม":[{"น":[{},[0,0,5]]}],"ว":[{"พ":[{},[0,0,5]],"น":[{"ะ":[{},[0,0,0,7]]}],"ก":[{},[0,0,7]]}],".":[{},[5]]},[1]],"ำ":[{"อ":[{"อ":[{},[0,0,5]]}],"โ":[{"ร":[{},[0,0,5]]}]}],"ิ":[{"ถ":[{"ิ":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"น":[{"ธ":[{"พ":[{},[0,0,0,7]],"ุ":[{".":[{},[0,0,0,7]]}],"ู":[{},[0,0,0,7]]}]}]},[1]],"ี":[{"ข":[{"้":[{},[0,0,5]]}],"ช":[{"อ":[{},[0,0,5]]}],"ด":[{"ว":[{},[0,0,5]]}],"ต":[{"ล":[{},[0,0,5]],"โ":[{},[0,0,5]]}],"ถ":[{"่":[{},[0,0,5]]}],"ผ":[{"ึ":[{},[0,0,5]]}],"ฝ":[{"ุ":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ว":[{"ล":[{},[0,0,5]]}],"ห":[{"น":[{"ุ":[{},[0,0,0,7]]}]}]}],"ุ":[{"ก":[{"ร":[{},[0,0,5]],"ำ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ข":[{"ิ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ค":[{"ต":[{},[0,0,5]],"ร":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]]}],"ม":[{"น":[{},[0,0,5]]}],"ส":[{"ง":[{},[0,0,5]]}],"ไ":[{"ห":[{},[0,0,5]]}],"์":[{".":[{},[6]]},[2]],"ต":[{"ิ":[{},[0,0,7]]}]},[1]],"ู":[{},[1]],"เ":[{"ฟ":[{},[0,4]]},[0,1]],"โ":[{"ค":[{},[0,4]],"ซ":[{},[0,7]]},[0,1]],"่":[{"ว":[{},[3]],"ไ":[{"ค":[{},[0,0,5]]}]}],"้":[{"ก":[{"ร":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"ไ":[{"ก":[{},[0,0,5]]}]}],"์":[{"ห":[{"ย":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ไ":[{"ต":[{},[0,6]],"น":[{},[0,6]],"บ":[{},[0,6]],"ป":[{},[0,6]],"ล":[{},[0,6]]}],"ภ":[{"า":[{"ร":[{},[0,7]]},[0,6]]}],"ธ":[{"น":[{"ะ":[{},[0,0,5]]}]}],"บ":[{"ท":[{},[0,6]],"ถ":[{},[0,6]]}],"ฐ":[{"ะ":[{},[0,6]]}],"ช":[{"ะ":[{},[0,7]]}],"ท":[{"ะ":[{},[0,7]]}]}],"ห":[{"ก":[{"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{"้":[{},[0,0,5]]}],"า":[{"ร":[{},[5]]}],".":[{},[5]]},[2,1]],"ง":[{"ส":[{"า":[{},[0,0,5]]},[0,0,4]],"ำ":[{},[0,6]],"ง":[{},[0,6]]}],"ฤ":[{"ห":[{"ร":[{},[0,0,5]]}],"โ":[{"ห":[{},[0,0,5]]}]}],"ล":[{"ส":[{"ะ":[{},[0,0,5]]}]}],"อ":[{"ค":[{"อ":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}]}],"ั":[{},[1]],"า":[{"ก":[{"ฐ":[{},[0,0,5]]}],"บ":[{"พ":[{},[0,0,5]]}],"ป":[{"ณ":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]],"น":[{},[0,0,7]]}],"ร":[{"ื":[{},[0,0,5]],"ี":[{},[0,0,7]]}],"ฤ":[{"ก":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}]}],"ิ":[{"ร":[{"ก":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],".":[{},[5]]}],"ุ":[{"ค":[{"ู":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ู":[{"ก":[{"ร":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"ห":[{"น":[{},[0,0,5]]}]},[5]],"้":[{"ท":[{"่":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ร":[{"้":[{},[0,0,5]]}]}],"์":[{"ก":[{"ร":[{},[0,0,5]]}],"ส":[{"น":[{},[0,0,5]]}],".":[{},[6]]},[2]],".":[{},[6]],"ม":[{"ณ":[{"ี":[{},[0,0,7]],"ะ":[{},[0,0,7]]}],"ะ":[{},[0,6]]}],"น":[{"ำ":[{},[0,6]],"ี":[{},[0,6]]}],"ส":[{"ี":[{},[0,7]],"ิ":[{},[0,7]]}],"ะ":[{},[5]],"ย":[{"ี":[{},[0,6]]}],"ด":[{".":[{},[5]]}],"ห":[{},[0,7]],"ณ":[{"ี":[{},[0,7]]}]},[0,2]],"ฬ":[{"ว":[{"ร":[{"า":[{},[0,0,5]]}]}],"ห":[{"บ":[{"ู":[{},[0,0,5]]}],"า":[{},[0,7]],"ี":[{},[0,7]]}],"า":[{"ม":[{"ณ":[{},[0,0,5]]}],"ร":[{"ึ":[{},[0,0,5]]}]},[1]],".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ส":[{".":[{},[7]]}]}],"อ":[{"ก":[{"ซ":[{"อ":[{},[0,0,5]]}],"ถ":[{"ล":[{},[0,0,5]]}],"ร":[{"ณ":[{},[0,0,5]],"ี":[{},[0,0,5]],"ู":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ฤ":[{"ท":[{},[0,0,5]]}],"ล":[{"ว":[{},[0,0,5]],"อ":[{},[0,0,5]],"า":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ว":[{"่":[{},[0,0,5]]}],"ใ":[{"บ":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ค":[{"ท":[{"ี":[{},[0,0,5]]}]}],"ฆ":[{"ส":[{"ง":[{},[0,0,5]]}]}],"ง":[{"ค":[{"ม":[{},[0,0,4]]}],"ถ":[{"ิ":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"อ":[{"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}]}],"ด":[{"ช":[{"่":[{},[0,0,5]]}],"ถ":[{"อ":[{},[0,0,5]]}],"น":[{"่":[{},[0,0,5]]}],"ฝ":[{"า":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"อ":[{"ย":[{},[0,0,5]],"อ":[{},[0,0,5]],"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ิ":[{},[0,3]],"ี":[{},[0,5]]}],"ต":[{"ด":[{"อ":[{},[0,0,5]],"็":[{},[0,0,5]]}],"ส":[{"ว":[{},[0,0,5]]}],"ไ":[{"ว":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ท":[{"ค":[{"อ":[{},[0,0,5]]},[0,4]]},[0,1]],"น":[{"ง":[{"้":[{},[0,0,5]]}],"จ":[{"อ":[{},[0,0,5]]}],"ท":[{"ำ":[{},[0,0,5]]}],"ผ":[{"ั":[{},[0,0,5]]}],"ฝ":[{"ู":[{},[0,0,5]]}],"ย":[{"้":[{},[0,0,5]]}],"า":[{},[0,4]],"ุ":[{},[0,4,0,1]]}],"บ":[{"ช":[{"้":[{},[0,0,5]]}],"ถ":[{"า":[{},[0,0,5]]}],"บ":[{"ี":[{},[0,0,5]]}],"อ":[{},[0,0,3]],"ไ":[{"ล":[{},[0,0,5]]}],"ร":[{"ม":[{},[0,0,7]]}],"น":[{"บ":[{},[0,0,7]]}]}],"ป":[{"ค":[{"อ":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ร":[{},[0,0,4]],"ว":[{"า":[{},[0,0,5]]}],"โ":[{"ล":[{},[0,0,5]]}],"น":[{".":[{},[0,7]]}]}],"พ":[{"ร":[{"ิ":[{},[0,0,5]]}],"ย":[{"พ":[{},[0,0,7]]}]}],"ฟ":[{"ฟ":[{"ี":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"โ":[{"ร":[{},[0,0,5]]}],"ไ":[{"ล":[{},[0,0,5]]}]}],"ภ":[{"ั":[{},[0,4]]}],"ม":[{"ค":[{"ล":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ฎ":[{"อ":[{},[0,0,5]]}],"ด":[{"อ":[{},[0,0,5]]}],"ถ":[{"อ":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ฤ":[{"ต":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]],"ว":[{},[0,0,5]],"้":[{},[0,0,5]]}],"อ":[{"น":[{},[0,5]]}]}],"ย":[{"ก":[{"อ":[{},[0,0,5]],"๋":[{},[0,0,5]]}],"น":[{"ว":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]],"้":[{},[0,0,5]]}],"อ":[{"ิ":[{},[0,0,5]],"ด":[{},[0,0,6]]}],"า":[{".":[{},[0,7]]},[0,4]],"ไ":[{"ด":[{},[0,0,5]]}]}],"ร":[{"ม":[{"น":[{},[0,0,5]]}],"อ":[{},[0,3]],"ั":[{},[0,1]],"า":[{},[0,3]],"ิ":[{".":[{},[0,6]]},[0,1]],"ี":[{},[0,1]],"้":[{},[0,3]],"์":[{},[0,0,0,1]],"ต":[{"ิ":[{},[0,0,7]]}],"บ":[{".":[{},[0,7]]}]}],"ล":[{"จ":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ฟ":[{"่":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]]}],"ั":[{},[0,3]],"ิ":[{},[0,1]],"ำ":[{},[0,7]],"ว":[{"น":[{},[0,0,7]]}]}],"ว":[{"ร":[{"ุ":[{},[0,0,5]]}]}],"ศ":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]]}]}],"ษ":[{"ฐ":[{"ช":[{},[0,0,5]],"ภ":[{},[0,0,5]]}]}],"ส":[{"ก":[{"า":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"พ":[{"ล":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ม":[{"ิ":[{},[0,0,5]],".":[{},[0,7]]}],"เ":[{"ฟ":[{},[0,0,5]]}],"แ":[{"อ":[{},[0,0,5]]}],"ไ":[{"พ":[{},[0,0,5]]}]}],"ห":[{},[0,1]],"อ":[{"น":[{},[3]],"อ":[{"ว":[{},[0,0,5]],".":[{},[0,7]]}]}],"ะ":[{"ธ":[{"ี":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}]}],"ั":[{"ฐ":[{"ม":[{"ี":[{},[0,0,0,7]]},[0,0,0,6]]},[0,0,0,5]]},[1]],"า":[{"ค":[{"เ":[{},[0,0,5,5]]}],"ฏ":[{"า":[{},[0,0,5]]}],"ณ":[{"ั":[{},[0,0,5]]}],"ด":[{"ุ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ต":[{},[0,0,2]],"ถ":[{"ร":[{},[0,0,5]]}],"น":[{"น":[{},[0,0,5]]}],"ป":[{"ณ":[{},[0,0,5]]}],"ม":[{"ล":[{},[0,0,5]]}],"ย":[{"ต":[{},[0,0,5,5]]}],"ร":[{"ด":[{},[0,0,5]],"ต":[{},[0,0,5]],"บ":[{},[0,0,5]],"ย":[{},[0,0,3]]}],"ล":[{"ป":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ส":[{"ว":[{},[0,0,5]],"น":[{"ะ":[{},[0,0,0,7]]}]}],"จ":[{"อ":[{"ง":[{},[0,0,0,7]]}]}]},[1]],"ำ":[{"ย":[{"ว":[{},[0,0,5]]}],"อ":[{"ว":[{},[0,0,5]]}]}],"ิ":[{"ช":[{"ย":[{},[0,0,5]]}],"ด":[{"ะ":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"ค":[{"ิ":[{},[0,0,5]]}],"จ":[{"ู":[{},[0,0,5]]}],"ซ":[{"ู":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,0,5]]}],"ล":[{"ุ":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]]}],"ห":[{"ร":[{},[0,0,5]]}]}],"ุ":[{"ก":[{"ฤ":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]]}],"ด":[{"ม":[{},[0,0,5]],"ร":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ต":[{"ร":[{"า":[{},[0,0,3]]}],"ุ":[{},[0,0,5]]}],"ท":[{"ร":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ธ":[{"ั":[{},[0,0,5]]}],"บ":[{"ล":[{},[0,0,5]],"๊":[{},[0,0,5]]}],"ม":[{"ง":[{},[0,0,5]]}],"ร":[{"พ":[{},[0,0,5]]}],"ล":[{"ก":[{},[0,0,5]]}],"แ":[{"ว":[{},[0,0,5]]}],"์":[{".":[{},[6]]}],"ป":[{"โ":[{"ภ":[{},[0,0,0,7]]}]}],".":[{},[7]]}],"ู":[{"ค":[{"ู":[{},[0,0,5]]}],"ม":[{"า":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]]}],".":[{},[7]]}],"เ":[{"ป":[{"ร":[{},[0,0,0,5]]}],"ส":[{"ก":[{},[0,0,0,0,5]],"ข":[{},[0,0,0,5]]}],"ห":[{"ต":[{},[0,0,0,5]]}],"จ":[{"ล":[{},[0,0,0,7]]}]},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"่":[{"อ":[{"ว":[{},[0,0,5]],"่":[{},[0,0,5]]},[3]],"โ":[{"ถ":[{},[0,0,5]]}]}],"้":[{"อ":[{"ว":[{},[0,0,5]]}],"โ":[{"ถ":[{},[0,0,5]],"ล":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"จ":[{"ล":[{"า":[{},[0,0,7]]}]}],"ึ":[{"ง":[{"อ":[{"ล":[{},[0,0,0,7]]}]}]}],"ข":[{"อ":[{".":[{},[0,7]]}]}]}],"ฮ":[{"ก":[{"ฮ":[{"า":[{},[0,0,5]],"ื":[{},[0,0,5]]}]}],"ช":[{"แ":[{"ท":[{},[0,0,5]]}]}],"น":[{"ร":[{"ี":[{},[0,0,5]]}]}],"ฟ":[{"ว":[{"ี":[{},[0,0,5]]}]}],"ล":[{"ด":[{"ิ":[{},[0,0,5]]}]}],"อ":[{"ล":[{},[3]]}],"า":[{"น":[{"อ":[{},[0,0,5]]}],"ป":[{"่":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}]},[5]],"ิ":[{"บ":[{"ร":[{"ู":[{},[0,0,0,6]]},[0,0,5]]}],"์":[{".":[{},[6]]}]}],"ี":[{"บ":[{"ร":[{"ู":[{},[0,0,0,6]]},[0,0,5]]}]}],"ื":[{"้":[{},[3]]}],"ู":[{"ล":[{"า":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"เ":[{},[0,1]],"โ":[{},[0,1]],"่":[{"ก":[{"ึ":[{},[0,0,5]]}]}],".":[{},[6]],"์":[{".":[{},[6]]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ต":[{"ิ":[{},[0,7]]}]}],"ะ":[{"ก":[{},[0,1]],"ข":[{},[0,1]],"ค":[{},[0,1]],"ง":[{},[0,1]],"จ":[{},[0,1]],"ฉ":[{},[0,1]],"ช":[{},[0,1]],"ซ":[{},[0,1]],"ด":[{},[0,1]],"ต":[{"ะ":[{},[0,0,0,4]]},[0,1]],"ท":[{},[0,1]],"น":[{},[0,1]],"บ":[{},[0,1]],"ป":[{},[0,1]],"ผ":[{"ี":[{},[0,0,0,4]]}],"พ":[{},[0,1]],"ม":[{"ว":[{"ง":[{},[0,0,6]]}]},[0,1]],"ย":[{},[0,1]],"ร":[{},[0,1]],"ล":[{},[0,1]],"ว":[{},[0,1]],"ส":[{},[0,1]],"ห":[{},[0,1]],"อ":[{},[0,1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]]},[6]],"ั":[{"ก":[{"ง":[{"่":[{},[0,0,5]]}],"ซ":[{"้":[{},[0,0,5]]}],"ต":[{"บ":[{},[0,0,5]]}],"ผ":[{"่":[{},[0,0,5]]}],"ฝ":[{"่":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]],"้":[{},[0,0,5]]},[0,6]],"ล":[{},[0,0,3]],"ว":[{"ิ":[{},[0,0,5]]}],"ษ":[{"ร":[{},[0,0,5]],"อ":[{},[0,0,5]]}],"อ":[{"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ใ":[{"ค":[{},[0,0,5]],"ฝ":[{},[0,0,5]]}]}],"ค":[{"ฆ":[{"ิ":[{},[0,0,5]]}],"ซ":[{"ี":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}]}],"ง":[{"ถ":[{"ึ":[{},[0,0,5]]}],"ศ":[{"ุ":[{},[0,0,5]]}],"ส":[{"ว":[{},[0,0,4,5]]}],"อ":[{"ว":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ฮ":[{"ี":[{},[0,0,5]]}]}],"จ":[{"ก":[{"ล":[{},[0,0,5]]}],"ญ":[{"ะ":[{},[0,0,5]]}],"ถ":[{"ร":[{},[0,0,5]]}],"น":[{"ึ":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"โ":[{"จ":[{},[0,0,5]]}]}],"ช":[{"ฎ":[{"า":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"พ":[{"ย":[{},[0,0,5]],"ื":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ส":[{"ก":[{},[0,0,5]],"ม":[{},[0,0,5]]}],"แ":[{"พ":[{},[0,0,5]]}],"โ":[{"ญ":[{},[0,0,5]],"ย":[{},[0,0,5]]}]}],"ญ":[{},[0,0,1]],"ฏ":[{"ท":[{"ุ":[{},[0,0,5]]}],"ส":[{"ง":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}],"ก":[{"ะ":[{},[0,0,7]]}]}],"ฐ":[{"ท":[{"ิ":[{},[0,0,5]]}],"บ":[{"ร":[{},[0,0,5]]}],"ส":[{"ภ":[{},[0,0,5]]}],"เ":[{"ค":[{},[0,0,5]]}]}],"ณ":[{"ฏ":[{"ก":[{},[0,0,5]]}],"ฐ":[{},[0,0,3]],"ย":[{"ก":[{},[0,0,5]]}],"เ":[{"ฑ":[{},[0,0,5]]}],"โ":[{"ร":[{},[0,0,5]]}]}],"ด":[{"ร":[{"ู":[{},[0,0,5]]}]},[0,0,1]],"ต":[{"ด":[{"ึ":[{},[0,0,5]]}],"ถ":[{"ล":[{},[0,0,5]],"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ุ":[{"์":[{},[0,0,6]]},[0,0,5]]}],"ม":[{"ณ":[{},[0,0,5]],"ห":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ฤ":[{"ก":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"ส":[{},[0,0,3]],"ห":[{"ล":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}]}],"ท":[{"ค":[{"ี":[{},[0,0,5]]}],"ท":[{"ว":[{},[0,0,5]]}],"ธ":[{"น":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}],"ว":[{"ะ":[{},[0,0,7]]}]}],"ธ":[{"ย":[{"ม":[{},[0,0,5]]}]}],"น":[{"ฉ":[{"่":[{},[0,0,5]]}],"ต":[{"ภ":[{},[0,0,5]],"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]],"า":[{},[0,0,5]]},[0,0,2]],"ถ":[{"ธ":[{},[0,0,5]]}],"ท":[{"ึ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ธ":[{"า":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ร":[{".":[{},[0,0,7]]}]},[0,0,4]],"ผ":[{"ว":[{},[0,0,5]]}],"ฝ":[{"ร":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ย":[{"ะ":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"บ":[{},[0,0,1]],"ป":[{"ค":[{"ั":[{},[0,0,5]]}],"ผ":[{"า":[{},[0,0,5]]}],"ร":[{},[0,0,4]],"ล":[{"า":[{},[0,0,5]]}],"ห":[{"ง":[{},[0,0,5]]}],"โ":[{"ป":[{},[0,0,5]],"ห":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}]}],"พ":[{"ย":[{"อ":[{},[0,0,5]],"า":[{},[0,0,5]]}],"โ":[{"พ":[{},[0,0,5]],"ห":[{},[0,0,5]]}]}],"ฟ":[{"ร":[{"ิ":[{},[0,0,5]]}]}],"ม":[{"ช":[{},[0,0,4]],"ห":[{"ม":[{},[0,0,5]]}]}],"ย":[{"ม":[{"ร":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,0,5]]}],"ก":[{"ะ":[{},[0,0,7]]}]}],"ล":[{"ด":[{"ี":[{},[0,0,5]]}],"ป":[{"น":[{},[0,0,5]],"พ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]]}],"ไ":[{"ซ":[{},[0,0,5]],"ฟ":[{},[0,0,5]]}]}],"ว":[{},[0,0,1]],"ศ":[{"น":[{"ี":[{},[0,0,5]]}],"ม":[{"ี":[{},[0,0,5]]}],"เ":[{"จ":[{},[0,0,5]]}],"ไ":[{"น":[{},[0,0,5]]}]}],"ส":[{"ก":[{"า":[{},[0,0,5]]}],"ม":[{"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ว":[{"า":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}],"ด":[{"ุ":[{".":[{},[0,0,7]]}]}],"ร":[{"ะ":[{},[0,0,7]]}],"า":[{},[0,6]]},[0,0,1]],"ฒ":[{"น":[{"ะ":[{},[0,0,7]]}],"ก":[{"ะ":[{},[0,0,7]]}]}]},[0,2]],"า":[{"ก":[{"ถ":[{"า":[{},[0,0,5]]}],"ฝ":[{"ร":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,4,5]]},[0,1]],"อ":[{".":[{},[0,7]]},[0,3]],"ฮ":[{"อ":[{},[0,0,5]]}],"ี":[{},[0,3]],"ิ":[{},[0,7]],"ล":[{},[0,7]]}],"ข":[{"บ":[{"ู":[{},[0,0,5]]},[0,4]],"ะ":[{},[0,7]]},[0,1]],"ค":[{"จ":[{},[0,4]],"ท":[{},[0,4]],"บ":[{},[0,4]],"ป":[{"ร":[{},[0,0,5]]},[0,4]],"พ":[{"ื":[{},[0,0,5]]},[0,4]],"ภ":[{},[0,4]],"ร":[{"ี":[{},[0,5]]}]},[0,1]],"ง":[{"บ":[{"ำ":[{},[0,0,5]]}],"ฝ":[{"ี":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ิ":[{},[0,7]]}],"จ":[{"ญ":[{},[0,4]],"ห":[{"า":[{},[0,0,5]]},[0,4]],"อ":[{},[0,4]],"เ":[{},[0,4]]},[0,1]],"ช":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]],"ฤ":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,5]],"ี":[{},[0,0,5]]}],"ป":[{"ะ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"ว":[{"โ":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"ส":[{"ก":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"อ":[{"ง":[{},[0,0,5]]}],"ิ":[{},[0,1]],"ี":[{},[0,3]],"โ":[{"อ":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ซ":[{},[0,1]],"ญ":[{"ร":[{"อ":[{},[0,0,5]]}]}],"ฏ":[{"ก":[{"ะ":[{},[0,5]]}],"ด":[{"น":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,5]],"ี":[{},[0,0,5]]}],"ิ":[{},[0,3]]}],"ฐ":[{"ก":[{"ถ":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ณ":[{"ค":[{"ด":[{},[0,0,5]]}],"ส":[{"ถ":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ด":[{"ผ":[{"ว":[{},[0,0,5]]}],"อ":[{},[0,3]],"ิ":[{},[0,3]],"ไ":[{"ท":[{},[0,0,5]],"ห":[{},[0,0,5]]}],"ี":[{},[0,7]],"ะ":[{},[0,7]]}],"ต":[{"ญ":[{},[0,4]],"ภ":[{},[0,4]],"ว":[{},[0,0,4]],"ี":[{},[0,7]],"า":[{},[0,7]]},[0,1]],"ท":[{"ธ":[{},[0,4]],"น":[{"ะ":[{},[0,5]]},[0,4]],"บ":[{"ง":[{},[0,0,5]],"ร":[{},[0,0,5]]}],"ส":[{"ก":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]]}],"ร":[{".":[{},[0,7]]}]},[0,1]],"ธ":[{"น":[{},[0,4]],"ย":[{"ม":[{},[0,0,5]]},[0,2]],"า":[{},[0,0,0,1]]},[0,1]],"น":[{"ญ":[{"่":[{},[0,0,5]]}],"ผ":[{"ู":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ฤ":[{"ด":[{},[0,0,5]]}],"อ":[{"ว":[{},[0,0,5]]}],"ุ":[{},[0,0,0,1]],"ะ":[{},[0,7]],"ี":[{},[0,7]],"ล":[{".":[{},[0,7]]}],"น":[{".":[{},[0,7]]}]}],"บ":[{"จ":[{"้":[{},[0,0,5]]}],"ฉ":[{"ว":[{},[0,0,5]]}],"ช":[{"้":[{},[0,0,5]]}],"ซ":[{"ึ":[{},[0,0,5]]}],"พ":[{},[0,0,4]],"ร":[{"ื":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,0,5]]}],"ิ":[{},[0,3]],"ี":[{".":[{},[0,7]]}]}],"ป":[{"ส":[{"ร":[{},[0,0,5]],"่":[{},[0,0,5]]}],"แ":[{"ช":[{},[0,0,5]]}]}],"พ":[{"ถ":[{"่":[{},[0,0,5]]}],"ย":[{"น":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"ล":[{"ว":[{},[0,0,5]]}]}],"ฟ":[{"ต":[{"้":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ภ":[{"ป":[{},[0,4]],"ล":[{"อ":[{},[0,0,5]]},[0,4]]},[0,1]],"ม":[{"ค":[{"ิ":[{},[0,0,5]]}],"ง":[{"่":[{},[0,0,5]]}],"น":[{"ิ":[{},[0,0,5]]},[0,0,4,4]],"ส":[{"ก":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]],"ล":[{},[0,0,5]],"า":[{},[0,0,5]]},[0,0,2]],"ี":[{},[0,3]],"ก":[{".":[{},[0,7]]}],"อ":[{".":[{},[0,7]]}]}],"ย":[{"ก":[{"ล":[{},[0,0,5]],"อ":[{},[0,0,5]],".":[{},[0,7]]}],"ข":[{"ว":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ช":[{"น":[{},[0,0,5]]}],"ด":[{"ิ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ต":[{"น":[{},[0,5]]}],"น":[{"ธ":[{},[0,5]],"ม":[{},[0,5]],"อ":[{},[0,0,5]],"เ":[{},[0,5]],".":[{},[0,7]]}],"บ":[{"ร":[{},[0,0,5]]}],"ผ":[{"อ":[{},[0,0,5]]}],"ฝ":[{"ั":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ว":[{"อ":[{},[0,0,5]]}],"อ":[{"ำ":[{},[0,0,5]]}],"ิ":[{},[0,3]],"ไ":[{"ห":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ร":[{"ก":[{"ำ":[{},[0,0,5]],".":[{},[0,7]]}],"ค":[{},[0,0,3]],"ณ":[{"ะ":[{},[0,5]],"ู":[{},[0,0,5]],".":[{},[0,7]]}],"ต":[{"ร":[{},[0,0,5]]}],"ท":[{"ะ":[{},[0,5]]}],"ธ":[{"ุ":[{},[0,0,5]]}],"ผ":[{"จ":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]],".":[{},[0,7]]}],"ภ":[{"ย":[{},[0,5]],".":[{},[0,7]]}],"ม":[{},[0,1]],"ร":[{"า":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,0,5]]}],"ว":[{"ด":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ห":[{"น":[{},[0,0,5]]}],"ะ":[{},[0,1]],"ั":[{},[0,1]],"า":[{},[0,1]],"ิ":[{"ก":[{},[0,5]],"ย":[{"ะ":[{},[0,5]]}]},[0,1]],"ี":[{},[0,1]],"ุ":[{},[0,1]],"น":[{"ี":[{},[0,0,6]]}]}],"ล":[{"ก":[{},[0,4]],"ค":[{},[0,4]],"จ":[{},[0,4]],"ฎ":[{"ี":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,0,5]]},[0,4]],"ท":[{"ห":[{},[0,0,5]]}],"ป":[{"ก":[{},[0,0,5]],"น":[{"ะ":[{},[0,0,0,7]]}]},[0,4]],"พ":[{"ร":[{},[0,0,5]]}],"ว":[{},[0,4]],"ส":[{},[0,4]],"อ":[{"ุ":[{},[0,0,5]]}],"โ":[{},[0,4]],"ี":[{},[0,7]]},[0,1]],"ว":[{"ก":[{"่":[{},[0,0,5]],".":[{},[0,7]]}],"ข":[{"้":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,3]],"ึ":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"บ":[{"อ":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]],"ื":[{},[0,0,5]]}],"ร":[{"ณ":[{},[0,5]],"ภ":[{},[0,0,5]],"ร":[{},[0,5]],"า":[{},[0,0,5]],"ี":[{},[0,5,5]],"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ฤ":[{"ก":[{},[0,0,5]]}],"อ":[{"น":[{},[0,5]]}],"ี":[{},[0,7]],"ะ":[{},[0,7]]}],"ศ":[{"น":[{"ี":[{},[0,0,5]]}],"ร":[{},[0,3]],"เ":[{"ล":[{},[0,0,5]]}]}],"ษ":[{"ด":[{"ื":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"แ":[{"ก":[{},[0,0,5]]}]}],"ส":[{"ก":[{"า":[{},[0,0,5]],".":[{},[0,7]]}],"ค":[{"อ":[{},[0,0,5]]}],"ด":[{"้":[{},[0,0,5]]}],"ต":[{"้":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ป":[{"อ":[{},[0,0,5]]}],"ม":[{"ห":[{},[0,0,5]],".":[{},[0,7]]}],"ี":[{},[0,7]],"พ":[{},[0,7]]}],"ห":[{"ก":[{},[0,0,3]],"ม":[{"ง":[{},[0,0,5]]}]},[0,1]],"ฬ":[{"โ":[{"ร":[{},[0,0,5]]}],"ี":[{},[0,7]],"ก":[{".":[{},[0,7]]}]}],"อ":[{"น":[{"า":[{},[0,0,0,0,4]]}]},[0,1]],"ฮ":[{},[0,1]],"เ":[{"ม":[{"ศ":[{},[0,0,0,5]]}]},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"ถ":[{"า":[{},[0,7]]}],"ฑ":[{"ู":[{},[0,7]]}],"ฝ":[{},[0,7]],"ฒ":[{"ะ":[{},[0,7]]}]},[6]],"ำ":[{"ก":[{},[0,1]],"ค":[{},[0,1]],"ท":[{"ว":[{},[0,0,4]]}],"น":[{},[0,1]],"บ":[{},[0,1]],"ป":[{},[0,1]],"พ":[{},[0,1]],"ม":[{"ร":[{"ง":[{},[0,0,5]]}]},[0,1]],"ร":[{},[0,1]],"ล":[{},[0,1]],"ส":[{},[0,1]],"ห":[{},[0,1]],"เ":[{},[0,1]],"แ":[{},[0,1]]},[6,7]],"ิ":[{"ก":[{"ซ":[{"ี":[{},[0,0,5]]}],"ถ":[{"อ":[{},[0,0,5]]}],"ร":[{"้":[{},[0,0,5]]},[0,1]],"ฤ":[{},[0,3]],"ล":[{"้":[{},[0,0,5]],".":[{},[0,7]]}],"ว":[{"า":[{},[0,0,5]]}],"ษ":[{"ุ":[{},[0,0,5]]}],"ิ":[{"ส":[{},[0,0,0,5]]}],"ะ":[{},[0,7]]}],"ข":[{"ส":[{"ิ":[{},[0,0,5]]},[0,4]]},[0,1]],"ค":[{"ต":[{"อ":[{},[0,0,5]]},[0,4]],"น":[{},[0,4]],"ห":[{"ะ":[{},[0,4]]}]},[0,1]],"ฆ":[{"เ":[{"น":[{},[0,0,5]]}]}],"ง":[{"ช":[{"ี":[{},[0,0,5]]}],"ส":[{"ต":[{},[0,0,4]]}],"ห":[{"า":[{},[0,0,5]],"้":[{},[0,0,5]]},[0,0,4]],"อ":[{"ร":[{},[0,0,5]]}]}],"จ":[{"ศ":[{"ี":[{},[0,0,5]]}],"ี":[{},[0,7]],"ล":[{".":[{},[0,7]]}]}],"ช":[{"น":[{},[0,0,4]],"ล":[{"ิ":[{},[0,0,5]]}],"ิ":[{},[0,3]],"ก":[{"ะ":[{},[0,0,7]]}],"ะ":[{},[0,7]]}],"ญ":[{"ห":[{"น":[{},[0,0,5]]}],"โ":[{"ญ":[{},[0,0,5]]}]}],"ด":[{"ฉ":[{"ิ":[{},[0,0,5]]}],"ช":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ผ":[{"น":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"า":[{},[0,7]]}],"ต":[{"ซ":[{"ู":[{},[0,0,5]]}],"ถ":[{"ี":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ล":[{"ด":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ว":[{"ส":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]]}],"ิ":[{},[0,1]],"ุ":[{},[0,3]],"ี":[{},[0,7]],"ร":[{"า":[{},[0,0,7]],"ะ":[{},[0,0,7]]}]}],"ท":[{"ค":[{"อ":[{},[0,0,5]]}],"ธ":[{"ั":[{},[0,0,5]],"ิ":[{".":[{},[0,0,5]]}]}],"ส":[{"น":[{},[0,0,5]]}]}],"ธ":[{"ี":[{},[0,3]],"ิ":[{},[0,7]],"ุ":[{},[0,7]]}],"น":[{"ง":[{"อ":[{},[0,0,5]]}],"ฟ":[{"ร":[{},[0,0,5]]}],"ย":[{"ว":[{},[0,0,5]],"อ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]],"ิ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"อ":[{"บ":[{},[0,5]],"ิ":[{},[0,0,5]]}],"ฮ":[{"ุ":[{},[0,0,5]]}],"ู":[{"ป":[{},[0,0,0,5]]}]}],"บ":[{"บ":[{"ิ":[{},[0,0,5]]}],"ผ":[{"ย":[{},[0,0,5]]}],"ย":[{"ื":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]],"้":[{},[0,0,5]]}]}],"ป":[{"ก":[{},[0,0,4]],"ท":[{"อ":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ร":[{},[0,3]],"ส":[{"ต":[{},[0,0,5]],"เ":[{},[0,0,5]]}],"ฮ":[{"อ":[{},[0,0,5]]}],"โ":[{"ป":[{},[0,0,5]],"ย":[{},[0,0,5]]}],"ุ":[{},[0,7]],"ู":[{},[0,7]],"ิ":[{},[0,7]]}],"พ":[{"พ":[{},[0,4]],"โ":[{"ส":[{},[0,0,5]]},[0,4]]},[0,1]],"ฟ":[{"ฟ":[{"อ":[{},[0,0,5]]}]}],"ภ":[{},[0,1]],"ม":[{"ฝ":[{"ี":[{},[0,0,5]]}],"ุ":[{},[0,1]]}],"ย":[{"ม":[{"ิ":[{},[0,0,5]]}],"ะ":[{},[0,7]],"ก":[{"ะ":[{},[0,0,7]]}],"ง":[{},[0,7]],"น":[{},[0,7]]}],"ร":[{"ว":[{"ด":[{},[0,0,5]]}],"ั":[{},[0,1]],"า":[{},[0,1]],"ิ":[{},[0,1]],"ุ":[{},[0,1]],"ี":[{},[0,7]],"ะ":[{},[0,7]],"พ":[{},[0,7]],"ม":[{".":[{},[0,7]]}]}],"ล":[{"ป":[{"ิ":[{},[0,0,5]]}],"ั":[{},[0,1]],"า":[{},[0,1]],"ิ":[{},[0,1]],"ี":[{},[0,5]],"ะ":[{},[0,7]],"ก":[{},[0,7]]}],"ว":[{"ซ":[{"ี":[{},[0,0,5]]}],"ท":[{"ร":[{},[0,0,5]]}],"บ":[{"ิ":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ร":[{"ร":[{},[0,3]],"ิ":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"า":[{"ส":[{},[0,0,0,5]]}],"ะ":[{},[0,7]]}],"ศ":[{"พ":[{"ร":[{},[0,0,5]]}],"ร":[{"้":[{},[0,0,5]],"า":[{},[0,0,7]]}],"เ":[{"ล":[{},[0,0,5]]}],"แ":[{"พ":[{},[0,0,5]]}]}],"ษ":[{"ณ":[{"ุ":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}]}],"ส":[{"ก":[{"ร":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,5]],"ิ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ท":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"บ":[{"อ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"ล":[{"า":[{},[0,0,5]]}],"ไ":[{"ซ":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ห":[{"า":[{},[0,0,0,4]]},[0,1]],"อ":[{},[0,1]],"เ":[{"น":[{},[0,0,0,4]]},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"ณ":[{"ะ":[{},[0,7]],"ก":[{"ะ":[{},[0,0,7]]}]}],"ถ":[{"ี":[{},[0,7]]}],"ฐ":[{"ิ":[{},[0,7]]}]},[6]],"ี":[{"ก":[{"ต":[{},[0,4]],"ย":[{"่":[{},[0,0,5]]},[0,4]],"ร":[{"ิ":[{},[0,0,5]]}]},[0,1]],"ฆ":[{"ส":[{"ร":[{},[0,0,5]]}]}],"ช":[{"ค":[{"ณ":[{},[0,0,5]]}]}],"ซ":[{"ส":[{"ถ":[{},[0,0,5]]}]}],"ด":[{"ฆ":[{"่":[{},[0,0,5]]}],"ิ":[{"ย":[{},[0,5]]}],"ี":[{},[0,7]]}],"ต":[{"ก":[{"ว":[{},[0,0,5]]}],"ป":[{"ฏ":[{},[0,0,5]]}],"ิ":[{},[0,7]]}],"ท":[{"น":[{},[0,0,4]]},[0,1]],"บ":[{"ร":[{"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}]}],"ป":[{},[0,1]],"พ":[{"จ":[{},[0,4]]},[0,1]],"ม":[{"ู":[{},[0,7]]},[0,1]],"ย":[{"ก":[{"ถ":[{},[0,0,5]]}],"ร":[{"ย":[{},[0,0,5]],"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ว":[{"น":[{},[0,5]]}],"ไ":[{"ต":[{},[0,0,5]]}]}],"ร":[{"ณ":[{"ั":[{},[0,0,5]]}],"ี":[{"บ":[{},[0,0,0,5]]},[0,3]],"า":[{},[0,7]],"ะ":[{},[0,7]],"ม":[{".":[{},[0,7]]}],"อ":[{".":[{},[0,7]]}],"ุ":[{},[0,7]]}],"ล":[{"จ":[{"ุ":[{},[0,0,5]]}],"า":[{},[0,7]],"ม":[{".":[{},[0,7]]}]}],"ว":[{"ั":[{},[0,4]],"า":[{},[0,0,0,4]],"ี":[{},[0,7]],"ะ":[{},[0,7]],"ก":[{},[0,7]],"ร":[{},[0,7]],"ง":[{},[0,7]]}],"ษ":[{"ม":[{"า":[{},[0,0,5]]}]}],"ห":[{"น":[{"า":[{},[0,0,5]],"้":[{},[0,5]]}],"บ":[{"ั":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ล":[{},[0,3]],"โ":[{"ม":[{},[0,0,5]]}],"ไ":[{"ส":[{},[0,0,5]]}]}],"อ":[{"ร":[{},[0,0,4]],"า":[{},[0,0,0,4]]},[0,1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ไ":[{},[0,1]],"่":[{"ก":[{"่":[{},[0,0,5]]}],"ถ":[{"้":[{},[0,0,5]]}],"ป":[{"ุ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ห":[{},[0,0,3]],"โ":[{"ค":[{},[0,0,5]],"ป":[{},[0,0,5]]}]}],"้":[{"ก":[{"ร":[{},[0,0,5]]}],"จ":[{"้":[{},[0,0,5]]}],"ต":[{"ะ":[{},[0,0,5]]}],"ฟ":[{"ู":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]],"ุ":[{},[0,0,5]]}]}],"๊":[{"ก":[{"ร":[{},[0,0,5]]}],"ด":[{"๊":[{},[0,0,5]]}],"ต":[{"่":[{},[0,0,5]]}]}],"๋":[{"จ":[{"้":[{},[0,0,5]]}],"อ":[{"๋":[{},[0,0,5]]}]}],"จ":[{"ี":[{},[0,7]]}],"ฑ":[{"า":[{},[0,7]]}],"ข":[{},[0,7]],"ส":[{"ป":[{},[0,7]]}]},[6]],"ึ":[{"ก":[{"ซ":[{"ึ":[{},[0,0,5]]}],"ด":[{"ำ":[{},[0,0,5]],"ื":[{},[0,0,5]]}],"ย":[{"ื":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}]}],"ด":[{"ถ":[{"ื":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}]}],"น":[{"ท":[{"ึ":[{},[0,0,5]]}]}]},[6]],"ื":[{"ด":[{"ฮ":[{"า":[{},[0,0,5]]}]}],"อ":[{"ก":[{"ล":[{},[0,0,5]],"อ":[{},[0,0,5]],"ำ":[{},[0,0,5]]}],"ข":[{"่":[{},[0,0,5]]}],"จ":[{"้":[{},[0,0,5]]}],"ช":[{"ื":[{},[0,0,5]]}],"ด":[{"ำ":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]]}],"ถ":[{"ื":[{},[0,0,5]]}],"น":[{"ำ":[{},[0,0,5]]}],"ป":[{"ล":[{},[0,0,5]],"ื":[{},[0,0,5]],"่":[{},[0,0,5]]}],"พ":[{"ว":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ย":[{"น":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ร":[{"ื":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ส":[{"อ":[{},[0,0,5]],"ำ":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}]}]},[6]],"ุ":[{"ก":[{"ง":[{"อ":[{},[0,0,5]]}],"ฉ":[{"ก":[{},[0,0,5]]}],"ซ":[{"่":[{},[0,0,5]]}],"ด":[{"ิ":[{},[0,0,5]]}],"ผ":[{"า":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"ุ":[{},[0,0,5]],"ะ":[{".":[{},[0,0,5]]}]}],"ล":[{"ะ":[{},[0,0,5]],"ี":[{},[0,0,5]],"้":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}],"ฮ":[{"ื":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"ข":[{"น":[{"า":[{},[0,0,5]]}],"ป":[{"า":[{},[0,0,5]]}],"ภ":[{"ั":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ล":[{"ั":[{},[0,0,5]]}],"ศ":[{"า":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"เ":[{"ด":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ค":[{"ท":[{"อ":[{},[0,0,5]]}],"น":[{},[0,3]]}],"ง":[{"ถ":[{"ุ":[{},[0,0,5]]}]}],"จ":[{"ล":[{"ิ":[{},[0,0,5]]}],"ห":[{"น":[{},[0,0,5]]}],"น":[{"ะ":[{},[0,0,7]]}],"ี":[{},[0,7]]}],"ญ":[{"จ":[{"น":[{},[0,0,5]]}],"ฤ":[{"ท":[{},[0,0,5]]}],"แ":[{"จ":[{},[0,0,5]]}]}],"ฎ":[{"ฐ":[{"ั":[{},[0,0,5]]}],"ี":[{},[0,7]],"า":[{},[0,7]]}],"ฑ":[{"พ":[{"่":[{},[0,0,5]]}]}],"ณ":[{"ค":[{"่":[{},[0,0,5]]}],"ฑ":[{"ก":[{},[0,0,5]]}],"ห":[{"ญ":[{},[0,0,5]],"า":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ู":[{"ป":[{},[0,0,0,0,5]]}],"ะ":[{},[0,7]]}],"ด":[{"ผ":[{"า":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"อ":[{"ู":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ต":[{"ก":[{"ว":[{},[0,0,5]]}],"ซ":[{"อ":[{},[0,0,5]]}],"ต":[{"ก":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,5]],"ิ":[{},[0,5]]}],"ล":[{"ุ":[{},[0,0,5]]}],"ส":[{"่":[{},[0,0,5]]}],"ถ":[{"ี":[{},[0,0,6]]}]}],"ท":[{"ก":[{},[0,3]],"ธ":[{"ั":[{},[0,0,5]],"ิ":[{".":[{},[0,0,7]]}]}],"ร":[{"ิ":[{},[0,5]]}],"ล":[{"ุ":[{},[0,0,5]]}],"โ":[{"ธ":[{},[0,0,5]]}],"ส":[{},[0,7]]}],"น":[{"ท":[{"ร":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}],"ะ":[{},[0,7]]}],"บ":[{"ง":[{"ิ":[{},[0,0,5]]}],"บ":[{"ิ":[{},[0,0,5]]}],"ผ":[{"ล":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"อ":[{"ิ":[{},[0,0,5]]}],"ล":[{".":[{},[0,5]]}]}],"ป":[{"ก":[{"ร":[{},[0,0,5]]}],"จ":[{"า":[{},[0,0,5]]}],"ถ":[{"ั":[{},[0,0,5]]}],"ย":[{"ุ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,3]],"ิ":[{},[0,5]]}],"ส":[{"ง":[{},[0,0,5]],"ร":[{},[0,0,5]]},[0,4]],"ฮ":[{"า":[{},[0,0,5]]}],"โ":[{"ภ":[{},[0,0,5]],"ล":[{},[0,0,5]]}]}],"พ":[{"พ":[{"า":[{},[0,0,5]]}],"ภ":[{"ิ":[{},[0,0,5]]}]}],"ภ":[{"ช":[{"ล":[{},[0,0,5]]}],"เ":[{"ค":[{},[0,0,5]]}]}],"ม":[{"น":[{"ุ":[{},[0,0,5]]},[0,0,4]],"ร":[{"ุ":[{},[0,0,5]]}],"ห":[{"ย":[{},[0,0,5]]}]}],"ย":[{"ช":[{"่":[{},[0,0,5]]}],"ฝ":[{"้":[{},[0,0,5]]}],"ง":[{},[0,7]]}],"ร":[{"ข":[{"่":[{},[0,0,5]]}],"ค":[{},[0,4]],"ฉ":[{},[0,4]],"ช":[{},[0,4]],"ท":[{},[0,4]],"ธ":[{},[0,4]],"บ":[{},[0,4]],"พ":[{},[0,4]],"ภ":[{"ี":[{},[0,5]]},[0,4]],"ย":[{},[0,4]],"ร":[{},[0,4]],"ล":[{},[0,4]],"ว":[{},[0,4]],"ศ":[{},[0,4]],"ส":[{},[0,4]],"อ":[{},[0,4]],"แ":[{},[0,4]],"โ":[{},[0,4]]},[0,1]],"ล":[{"จ":[{"อ":[{},[0,0,5]]}],"ช":[{"ี":[{},[0,0,5]]}],"ธ":[{"ิ":[{},[0,0,5]]}],"ม":[{"ุ":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]]}],"ส":[{"ต":[{},[0,0,5]],"แ":[{},[0,0,5]]}],"า":[{},[0,3]],"ิ":[{},[0,3]],"ี":[{},[0,5]],"ะ":[{},[0,7]]}],"ศ":[{"เ":[{"ร":[{},[0,0,5]]}],"โ":[{"ล":[{},[0,0,5]]}]}],"ษ":[{"จ":[{"ี":[{},[0,0,5]]}],"ฎ":[{"ี":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]]}],"ย":[{},[0,4]],"ร":[{"า":[{},[0,0,5]],"้":[{},[0,0,5]]}],"เ":[{"พ":[{},[0,0,5]]}],"ณ":[{"ะ":[{},[0,0,7]]}]}],"ส":[{"ร":[{"า":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,5]],"ิ":[{},[0,0,5]]}],"ว":[{"า":[{},[0,0,5]]}],"ภ":[{".":[{},[0,7]]}]}],"ห":[{"ก":[{"ล":[{},[0,0,5]]}],"น":[{"า":[{},[0,0,5]]}],"ย":[{"า":[{},[0,0,5]]},[0,4]],"เ":[{"ท":[{},[0,0,5]],"ส":[{},[0,0,5]]},[0,4]],"โ":[{"ย":[{},[0,0,5]]},[0,4]]},[0,1]],"เ":[{},[0,1]],"โ":[{},[0,1]],"๊":[{"ต":[{"๊":[{},[0,0,5]]}]}],"ว":[{"ด":[{"ี":[{},[0,0,7]]}],"ะ":[{},[0,7]]}],"ช":[{"ุ":[{},[0,7]]}]},[6]],"ู":[{"ก":[{"ว":[{"ั":[{},[0,0,5]]}]}],"ช":[{},[0,1]],"ญ":[{"ห":[{"า":[{},[0,0,5]]}],"เ":[{"ป":[{},[0,0,5]],"ส":[{},[0,0,5]]}]}],"ด":[{"บ":[{"ึ":[{},[0,0,5]]}],"ร":[{"ี":[{},[0,0,5]]}],"ู":[{},[0,7]]}],"ต":[{"ร":[{"ู":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ธ":[{"เ":[{"ร":[{},[0,0,5]]}]}],"บ":[{"ไ":[{"ล":[{},[0,0,5]]}]}],"ป":[{"ก":[{},[0,0,4]],"ฌ":[{"า":[{},[0,0,5]]}],"ถ":[{"่":[{},[0,0,5]]}],"ท":[{"ร":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]]}],"ร":[{"่":[{},[0,0,5]]}],"แ":[{"บ":[{},[0,0,5]]}],"โ":[{"ฉ":[{},[0,0,5]]}]}],"ฟ":[{"ว":[{"ี":[{},[0,0,5]]}]}],"ม":[{"ิ":[{"น":[{},[0,5]]}],"ี":[{},[0,7]]},[0,2]],"ร":[{"ข":[{"่":[{},[0,0,5]]}],"ณ":[{"ภ":[{},[0,5]],"ม":[{},[0,5]],"ะ":[{},[0,5]],"า":[{"ก":[{},[0,5]]}]},[0,0,4]],"พ":[{"ะ":[{},[0,5]],"า":[{},[0,5]]},[0,0,4]],"ม":[{},[0,0,4]],"ี":[{},[0,7]],"า":[{},[0,7]],"ะ":[{},[0,7]],"ุ":[{},[0,7]],"ิ":[{".":[{},[0,7]]}]}],"ล":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"่":[{},[0,0,5]]}],"ั":[{},[0,3]],"า":[{},[0,7]],"ะ":[{},[0,7]],"ู":[{},[0,7]]}],"ว":[{"ไ":[{"น":[{},[0,0,5]]}],"ี":[{},[0,7]]}],"ส":[{"ว":[{},[0,0,4]],"ี":[{},[0,7]]}],"เ":[{},[0,1]],"โ":[{},[0,1]],"่":[{},[0,0,1]],"้":[{},[0,0,1]],"๊":[{"ต":[{"ึ":[{},[0,0,5]]}]}],"๋":[{"ก":[{"ร":[{},[0,0,5]]}],"จ":[{"ี":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}]}],"ห":[{"า":[{},[0,7]]}],"จ":[{"ี":[{},[0,7]]}],"ข":[{"ะ":[{},[0,7]]}],"ฏ":[{"า":[{},[0,7]]}]},[6]],"เ":[{"ก":[{"ย":[{"ู":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ร":[{"ล":[{},[0,0,5]]}],"ว":[{"ั":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]],"า":[{},[0,0,7]]}],"อ":[{"ิ":[{},[0,0,5]]}],"ง":[{},[0,6]],"ช":[{"า":[{},[0,0,7]]}],"ก":[{},[0,6]],"ต":[{"ุ":[{".":[{},[0,0,6]]}]}]}],"ค":[{"ซ":[{"อ":[{},[0,0,5]]}],"ม":[{"ี":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]]}],"ห":[{"ะ":[{},[0,0,7]]}]},[0,6]],"จ":[{"ด":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ร":[{},[0,4]],"ล":[{"ิ":[{},[0,0,5]]}],"โ":[{"ต":[{},[0,0,5]],"ร":[{},[0,0,5]]}]},[0,6]],"ซ":[{"ท":[{"ิ":[{},[0,0,5]]}],"น":[{"อ":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,0,5]]}],"แ":[{"ค":[{},[0,0,5]]}]},[0,6]],"ด":[{"บ":[{"ิ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]]}]},[0,6]],"ต":[{"ช":[{},[2]],"ป":[{"ุ":[{},[0,0,5]]}],"ม":[{"ี":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ี":[{".":[{},[0,0,7]]}]}],"ล":[{"ุ":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"ศ":[{"ว":[{},[0,0,5]]}],"ห":[{"ะ":[{},[0,0,5]]}]},[0,6]],"ถ":[{"ร":[{"า":[{},[0,0,5]]}]},[0,6]],"ท":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]],"ว":[{},[0,0,5]]}],"โ":[{"ว":[{},[0,0,5]],"ศ":[{},[0,0,5]]}],"พ":[{"ี":[{},[0,0,7]]}],"ว":[{"ี":[{},[0,0,7]],"ะ":[{},[0,0,7]]}],"ห":[{"ะ":[{},[0,0,7]]}]},[0,6]],"น":[{"ต":[{"ิ":[{},[0,0,5]]},[0,0,4]],"ย":[{},[4]],"ร":[{"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]],"ุ":[{},[0,0,7]]}],"ส":[{"า":[{},[0,0,5]]},[0,0,2]],"เ":[{"ว":[{},[0,0,5]]}],"ห":[{"า":[{},[0,0,7]]}]},[0,6]],"บ":[{"ต":[{"้":[{},[0,0,5]]}],"บ":[{"ี":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,5]]}],"ื":[{"้":[{"อ":[{"ง":[{},[0,0,0,0,0,0,7]]}]}]}]},[0,6]],"ป":[{"ต":[{"อ":[{},[0,0,5]]}],"ส":[{"ก":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ี":[{"่":[{},[0,0,0,0,6]]}],"ร":[{"ี":[{"ย":[{"ะ":[{},[0,0,0,0,6]]}]}],"ะ":[{},[0,0,7]]}]},[0,6]],"พ":[{"ช":[{"ุ":[{},[0,0,5]]}],"ท":[{"ุ":[{},[0,0,5]]}],"ส":[{"ล":[{},[0,0,5]]}],"โ":[{"ท":[{},[0,0,5]]}],"ไ":[{"น":[{},[0,0,5]]}]},[0,6]],"ฟ":[{"อ":[{"ี":[{},[0,0,5]]}]},[0,6]],"ภ":[{"ต":[{"ร":[{},[0,0,5]]}],"ท":[{"ุ":[{},[0,0,5]]}],"ก":[{"ะ":[{},[0,0,7]]}]},[0,6]],"ม":[{"ฆ":[{"ิ":[{},[0,0,5]]}],"ด":[{"ิ":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ส":[{"ุ":[{},[0,0,5]]},[0,0,4]]},[0,6]],"ร":[{"ก":[{"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]]}],"ม":[{"อ":[{},[0,0,5]]}],"ร":[{"ว":[{},[0,0,5]]}],"ว":[{"ด":[{},[0,0,5]]}],"ื":[{"อ":[{"ธ":[{},[0,0,0,0,7]],"บ":[{},[0,0,0,0,7]]}]}]},[0,6]],"ล":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"อ":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,0,5]]}],"พ":[{"อ":[{},[0,0,5]]}],"ว":[{"ร":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ห":[{"ล":[{},[0,0,5]]}],"ฮ":[{"ุ":[{},[0,0,5]]}],"ิ":[{},[0,0,0,4]],"ส":[{"ไ":[{"ต":[{},[0,0,0,7]]}]}],"ี":[{"้":[{"ย":[{"ว":[{},[0,0,0,0,0,0,7]]}]}]}]},[0,6]],"ว":[{"ก":[{"้":[{},[0,0,5]]}],"ท":[{"ิ":[{},[0,0,5]]}],"ล":[{"่":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ฬ":[{"ุ":[{},[0,0,5]]}],"ไ":[{"น":[{},[0,0,5]]}],"ร":[{"ี":[{},[0,0,7]]}],"ส":[{"ี":[{},[0,0,7]]}],"จ":[{"ี":[{},[0,0,7]]}]},[0,6]],"ส":[{"ฉ":[{"ว":[{},[0,0,5]]}],"น":[{"ี":[{"ย":[{"์":[{},[0,0,5]]}]}]}],"ร":[{"ี":[{},[0,0,5]]}],"ว":[{"ก":[{},[0,0,5]],"น":[{"ะ":[{},[0,0,0,6]]},[0,0,5]]}],"แ":[{"ส":[{},[0,0,5]]}],"ภ":[{"า":[{},[0,0,7]]}]},[0,6]],"ห":[{"ม":[{"ั":[{},[0,0,5]]}],"ย":[{"ง":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]],"ั":[{},[0,0,5]],"า":[{".":[{},[0,0,7]]}]}],"ศ":[{"ว":[{},[0,0,5]],"ั":[{},[0,0,5]]}],"ส":[{"ั":[{},[0,0,5]]}]},[0,6]],"ฬ":[{"ว":[{"ร":[{},[0,0,5]]}]},[0,6]],"อ":[{"ก":[{"ว":[{},[0,0,5]]}],"ธ":[{"ิ":[{},[0,0,5]]}],"ฬ":[{"ก":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,7]]}]},[0,6]],"ฮ":[{"ล":[{"ะ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}]},[0,6]],"ข":[{"ี":[{"้":[{},[0,0,0,0,6]]}],"ฬ":[{"ะ":[{},[0,0,7]]}]},[0,6]],"ฃ":[{},[0,6]],"ฅ":[{},[0,6]],"ฆ":[{},[0,6]],"ง":[{},[0,6]],"ฉ":[{},[0,6]],"ช":[{"น":[{},[0,6]]},[0,6]],"ฌ":[{},[0,6]],"ญ":[{},[0,6]],"ฎ":[{},[0,6]],"ฏ":[{},[0,6]],"ฐ":[{},[0,6]],"ฑ":[{},[0,6]],"ฒ":[{},[0,6]],"ณ":[{},[0,6]],"ธ":[{},[0,6]],"ผ":[{},[7,6]],"ฝ":[{},[0,6]],"ย":[{},[0,6]],"ศ":[{},[0,6]],"ษ":[{},[0,6]]},[0,2]],"แ":[{"ก":[{"ว":[{"ั":[{},[0,0,5]]}]}],"ค":[{"ร":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ล":[{"อ":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"แ":[{"ต":[{},[0,0,5]],"ส":[{},[0,0,5]]}]}],"ซ":[{"ย":[{"ิ":[{},[0,0,5]]}],"ห":[{"ว":[{},[0,0,5]]}]}],"ด":[{"ร":[{"ี":[{},[0,0,5]]}],"ว":[{"ู":[{},[0,0,7]]}]}],"ต":[{"แ":[{"ต":[{},[0,0,5]]}],"ร":[{"ว":[{"ง":[{},[0,0,0,7]]}]}]}],"น":[{},[0,0,2]],"บ":[{"ค":[{},[0,0,4]],"ร":[{"ิ":[{},[0,0,5]]}]}],"ป":[{"ร":[{},[0,4]]}],"พ":[{"ท":[{},[3]]}],"ฟ":[{"ร":[{"ี":[{},[0,0,5]]}],"้":[{},[0,4]]}],"ม":[{"ก":[{"า":[{},[0,0,5]]}],"ช":[{"ี":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"เ":[{"ร":[{},[0,0,5]]}],"่":[{},[0,0,0,3]]},[0,0,2]],"อ":[{"น":[{"ะ":[{},[0,0,5]]}]}],"ล":[{".":[{},[5]]}],"ว":[{"ด":[{"ว":[{"ง":[{},[0,0,0,7]]}]}]}]},[0,6]],"โ":[{"ก":[{"ฐ":[{},[0,0,4]],"ล":[{"อ":[{},[0,0,5]],"า":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ว":[{"า":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ฮ":[{"า":[{},[0,0,5]]}],".":[{},[7]]}],"ข":[{"ท":[{"ั":[{},[0,0,5]]}],"ภ":[{"ิ":[{},[0,0,5]]}],"เ":[{"ภ":[{},[0,0,5]]}],"โ":[{"ล":[{},[0,0,5]]}]}],"ค":[{"ต":[{"ม":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ม":[{"ู":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]],"ำ":[{},[0,0,7]],"ส":[{},[0,0,6]]}],"ล":[{"อ":[{},[0,0,5]],"ั":[{},[0,0,5]],"ี":[{},[0,0,5]],"่":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]],"ะ":[{},[0,0,5]]}],"แ":[{"ท":[{},[0,0,5]]}],"ไ":[{"ซ":[{},[0,0,5]]}],"ท":[{"ร":[{".":[{},[0,0,7]]}]}],"น":[{"ม":[{},[0,0,7]]}]}],"จ":[{"ป":[{"ก":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}],"ร":[{".":[{},[0,6]]}]}],"ฉ":[{"เ":[{"บ":[{},[0,0,5]],"ก":[{},[0,0,7]]}]}],"ช":[{"ฎ":[{"ึ":[{},[0,0,5]]}],"ด":[{"ึ":[{},[0,0,5]]}],"ห":[{"่":[{},[0,0,5]]}],"น":[{},[0,6]]}],"ซ":[{"ก":[{"ร":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ย":[{"ู":[{},[0,0,5]]}],"ล":[{"ู":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ส":[{"เ":[{},[0,0,5]]}],"ร":[{},[0,0,6]]}],"ญ":[{"ช":[{},[0,0,4]],"ป":[{"ว":[{},[0,0,5]]}]}],"ด":[{"จ":[{"ี":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ม":[{"ร":[{},[0,0,7]]}]}],"ต":[{"ก":[{"ร":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"า":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ส":[{"เ":[{},[0,0,5]]}],"ไ":[{"ค":[{},[0,0,5]]}],"ม":[{"ร":[{},[0,0,7]]}]}],"ท":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"อ":[{},[0,0,5]]}],"ด":[{"อ":[{},[0,0,5]]}],"พ":[{"ล":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}],"แ":[{"อ":[{},[0,0,5]]}],"โ":[{"ส":[{},[0,0,7]]}]}],"ธ":[{"ท":[{"น":[{},[0,0,5]]}],"ป":[{"ก":[{},[0,0,5]],"ิ":[{},[0,0,5]]}],"ว":[{"น":[{},[0,0,5]]}],"เ":[{"ฟ":[{},[0,0,5]]}]}],"น":[{"ท":[{"ุ":[{},[0,0,5]]}],"ป":[{"จ":[{},[0,0,5]]}],"ร":[{"ม":[{},[0,0,5]]}]}],"บ":[{"ช":[{"ุ":[{},[0,0,5]]}],"ซ":[{"อ":[{},[0,0,5]]}],"ต":[{"้":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]],"ั":[{},[0,0,5]],"า":[{},[0,0,5]],"ิ":[{},[0,0,7]]}],"ล":[{"ิ":[{},[0,0,5]],"่":[{},[0,0,5]],"า":[{},[0,0,7]]}],"อ":[{"ิ":[{},[0,0,5]]}],"ไ":[{"ฮ":[{},[0,0,5]]}]}],"ป":[{"ก":[{"ส":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]],"ี":[{},[0,0,7]]}],"แ":[{"ต":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"โ":[{"ป":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ส":[{"ก":[{},[0,0,7]]}]}],"พ":[{"ท":[{"ะ":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]]}],"ล":[{"า":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ห":[{"า":[{},[0,0,5]]}],"แ":[{"ท":[{},[0,0,5]]}],"ไ":[{"ซ":[{},[0,0,5]]}]},[7]],"ฟ":[{"ก":[{"ร":[{},[0,0,5]]}],"ต":[{"อ":[{},[0,0,5]]}],"น":[{"ี":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}]}],"ภ":[{"ค":[{"ิ":[{},[0,0,5]]}],"ไ":[{"ค":[{},[0,0,5]]}]}],"ม":[{"ฆ":[{"ี":[{},[0,0,5]]}],"ด":[{"ู":[{},[0,0,5]]}],"ร":[{"็":[{},[0,0,5]],"ี":[{},[0,0,7]]}],"ห":[{"า":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]]}],"ล":[{"ี":[{},[0,0,7]]}]}],"ย":[{"ถ":[{"ิ":[{},[0,0,5]]}],"น":[{"ก":[{".":[{},[0,0,7]]}]}]}],"ร":[{"ก":[{"ะ":[{},[0,0,5]]}],"ค":[{"ิ":[{},[0,0,5]]}],"ง":[{"ั":[{},[0,0,5]]}],"ธ":[{"น":[{"ะ":[{},[0,0,5]]}]}],"พ":[{"ล":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ล":[{"่":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ส":[{"เ":[{},[0,0,5]]},[0,0,0,4]],"ห":[{"น":[{},[0,0,5]]}],"อ":[{"ี":[{},[0,0,5]]}],"ฮ":[{"ิ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"แ":[{"ม":[{},[0,0,5]]}],"ไ":[{"ล":[{},[0,0,5]]}]}],"ล":[{"ก":[{"ร":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"จ":[{"น":[{},[0,0,5]]}],"ป":[{"ุ":[{},[0,0,5]]}],"ม":[{"ก":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]]}],"ว":[{"ะ":[{},[0,0,5]]}],"ห":[{"ิ":[{},[0,0,5]]}],"ไ":[{"ม":[{},[0,0,5]]}],"ท":[{"ร":[{".":[{},[0,0,7]]}]}],"บ":[{"ล":[{".":[{},[0,0,7]]}]}],"่":[{"ง":[{"อ":[{"ก":[{},[0,0,0,0,7]]}]}]}]}],"ว":[{"น":[{"อ":[{},[0,0,5]]}]}],"ศ":[{"ธ":[{"น":[{},[0,0,5]]}],"ภ":[{"ิ":[{},[0,0,5]]}]}],"ส":[{"ก":[{"ร":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"ธ":[{"น":[{"ะ":[{},[0,0,0,6]]},[0,0,5]]}],"ภ":[{"ิ":[{},[0,0,5]],"า":[{},[0,0,7]]},[0,0,7]],"ร":[{"ั":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ห":[{"ุ":[{},[0,0,5]]}],"โ":[{"ค":[{},[0,0,5]]}],"ท":[{"ร":[{".":[{},[0,0,7]]}]}],"ม":[{"ม":[{},[0,0,7]]}]}],"ห":[{"ฐ":[{"า":[{},[0,0,5]]}],"ร":[{"ส":[{},[0,0,5]],"ะ":[{},[0,0,5]],"า":[{},[0,0,5]]}],"ส":[{"ิ":[{},[0,0,5]]}],"ฬ":[{"า":[{},[0,0,5]]}]}],"อ":[{"ค":[{"ล":[{},[0,0,5]],"็":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,0,5]]}],"ร":[{"ส":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,0,5]],"า":[{},[0,0,7]]}],"ส":[{"ถ":[{},[0,0,5]]}],"อ":[{"ิ":[{},[0,0,5]]}],"ช":[{"ะ":[{},[0,0,7]]}]}],"ผ":[{},[7]],"ฮ":[{},[7]]},[0,6]],"ใ":[{"ช":[{"้":[{},[3]]}],"ห":[{},[1]],"จ":[{},[0,0,7]]},[7,6]],"ไ":[{"ก":[{"ล":[{"า":[{},[0,0,5]]}],"ว":[{"ั":[{},[0,0,5]]}],"ร":[{"ส":[{"ิ":[{"ท":[{"ธ":[{"ิ":[{".":[{},[0,0,0,0,0,0,6]]}]}]}]}]}],"พ":[{},[0,0,7]]}]}],"ข":[{"ข":[{"้":[{},[0,0,5]]}],"ค":[{"ว":[{},[0,0,5]]}],"ม":[{"ั":[{},[0,0,5]]}],"ส":[{"ั":[{},[0,0,5]],"ื":[{},[0,0,5]]}]}],"ค":[{"ศ":[{"ว":[{},[0,0,5]]}]}],"ช":[{"น":[{"่":[{},[0,0,5]],"ะ":[{},[0,0,7]]}],"ศ":[{"ว":[{},[0,0,5]]}],"โ":[{"ย":[{},[0,0,7]]}]}],"ซ":[{"ด":[{"อ":[{},[0,0,5]]}],"บ":[{"อ":[{},[0,0,5]],"ี":[{},[0,0,5]]}],"ป":[{"ร":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]]}],"แ":[{"น":[{},[0,0,5]]}]}],"ด":[{"ฟ":[{"ุ":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ล":[{"ิ":[{},[0,0,5]]}],"อ":[{"อ":[{},[0,0,5]]}]}],"ต":[{"ร":[{"ี":[{},[0,0,5]]}]}],"ท":[{"ก":[{"ร":[{},[0,0,5]]}],"ฟ":[{"อ":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}],"แ":[{"ท":[{},[0,0,5]]}],"ว":[{"ะ":[{},[0,0,7]]}]}],"ป":[{"ร":[{"ิ":[{},[0,0,5]]}]}],"พ":[{"ช":[{"ย":[{},[0,0,5]]}],"ท":[{"อ":[{},[0,0,5]]}],"ธ":[{"อ":[{},[0,0,5]]}],"ร":[{"ั":[{},[0,0,5]],"ิ":[{},[0,0,5]],"ำ":[{},[0,0,7]],"่":[{},[0,0,0,0,7]]}],"ล":[{"ิ":[{},[0,0,5]]}],"ห":[{"า":[{},[0,0,5]]}],"โ":[{"ร":[{},[0,0,5]],"อ":[{},[0,0,5]]}]}],"ฟ":[{"แ":[{"ช":[{},[0,0,5]],"น":[{},[0,0,5]]}]}],"ภ":[{"ร":[{"ิ":[{},[0,0,5]]}]}],"ม":[{"ถ":[{"ิ":[{},[0,0,5]]}],"้":[{},[0,0,0,1]]}],"ล":[{"บ":[{"ร":[{},[0,0,5]],"ี":[{},[0,0,5]]}]}],"ว":[{"ร":[{"ั":[{},[0,0,5]]}],"อ":[{"ะ":[{},[0,0,5]]}]}],"ห":[{"ร":[{"ณ":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]]}],"ห":[{"ม":[{},[0,0,5]],"ล":[{},[0,0,5]]}]}],"อ":[{"ก":[{"ร":[{},[0,0,5]]}],"ค":[{"ิ":[{},[0,0,5]]}],"ซ":[{"ี":[{},[0,0,5]]}],"ด":[{"อ":[{},[0,0,5]]}],"ต":[{"ิ":[{},[0,0,5]]}],"พ":[{"อ":[{},[0,0,5]],"็":[{},[0,0,5]]}],"ศ":[{"ว":[{},[0,0,5]],"ุ":[{},[0,0,5]],"ู":[{},[0,0,5]]}]}],"ฮ":[{},[0,0,1]],"ศ":[{"ว":[{"ะ":[{},[0,0,7]]}]}]},[5,6]],"็":[{"ก":[{"ซ":[{"ี":[{},[0,0,5]]}]}],"จ":[{"ข":[{"บ":[{},[0,0,5]]}],"ส":[{"ร":[{},[0,0,5]]}]}],"ด":[{"ล":[{"อ":[{},[0,0,5]]}],"อ":[{"ร":[{},[0,0,5]],"ึ":[{},[0,0,5]]}]}],"น":[{"ฉ":[{"่":[{},[0,0,5]]}],"ร":[{"อ":[{},[0,0,5]]}],"ว":[{"ู":[{},[0,0,5]]}],"อ":[{"ย":[{},[0,0,5]],"้":[{},[0,0,5]]}]}],"บ":[{"ด":[{"้":[{},[0,0,5]]}]}],"ป":[{"ท":[{"็":[{},[0,0,5]]}]}],"ม":[{"ห":[{"ม":[{},[0,0,5]]}]}]},[6]],"่":[{"ก":[{"ล":[{"ั":[{},[0,0,5]]}]}],"ค":[{},[0,1]],"ง":[{"ร":[{"ิ":[{},[0,0,5]]}],"อ":[{"ร":[{},[0,0,5]],"ำ":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"ฉ":[{"ี":[{},[0,4]]}],"น":[{"ง":[{"่":[{},[0,0,5]]}],"ฉ":[{"่":[{},[0,0,5]]}],"ท":[{"ะ":[{},[0,0,5]]}],"ม":[{"ื":[{},[0,0,5]]}],"ย":[{"น":[{},[0,0,5]],"่":[{},[0,0,5]]},[0,4]],"ร":[{"ม":[{},[0,0,5]]}]}],"ม":[{"พ":[{"ว":[{},[0,0,5]]}]},[0,0,1]],"ย":[{"ก":[{"ะ":[{},[0,0,5]]}],"ฉ":[{"ุ":[{},[0,0,5]]}],"ร":[{"า":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"ว":[{"ช":[{"้":[{},[0,0,5]]}],"ถ":[{"ึ":[{},[0,0,5]]}],"ย":[{"ว":[{},[0,0,5]]}],"ฮ":[{"้":[{},[0,0,5]]}],"ไ":[{"ห":[{},[0,0,5]]}]}],"อ":[{"ก":[{"ร":[{},[0,0,5]],"ว":[{},[0,0,5]],"ะ":[{},[0,0,5]],"ี":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ข":[{"่":[{},[0,0,5]]}],"ต":[{"ร":[{},[0,0,5]],"ะ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ถ":[{"ื":[{},[0,0,5]]}],"บ":[{"ื":[{},[0,0,5]]}],"ผ":[{"ส":[{},[0,0,5]]}],"ม":[{"ว":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ย":[{"อ":[{},[0,0,5]],"่":[{},[0,0,5]]},[0,0,0,3]],"ร":[{"่":[{},[0,0,5]]}],"ล":[{},[0,0,3]],"ว":[{"่":[{},[0,0,5]]}],"ส":[{"ร":[{},[0,0,5]]}],"ฮ":[{"ั":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"า":[{"ก":[{"ล":[{},[0,0,5]]}],"ช":[{"้":[{},[0,0,5]]}],"ด":[{"ง":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ฝ":[{"ื":[{},[0,0,5]]}],"พ":[{"ร":[{},[0,0,5]]}],"ม":[{"ง":[{},[0,0,5]]}],"ร":[{"ึ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ว":[{},[0,0,0,3]]}],"ำ":[{"ช":[{"อ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ต":[{"้":[{},[0,0,5]],"๊":[{},[0,0,5]]}],"ไ":[{"ห":[{},[0,0,5]]}]}],"เ":[{},[0,1]],"แ":[{},[0,1]],"ห":[{"า":[{},[0,7]]}],"ล":[{"ะ":[{},[0,7]]}]},[6]],"้":[{"ก":[{"อ":[{"้":[{},[0,0,5]]}]}],"ง":[{"ถ":[{"่":[{},[0,0,5]]}],"ฝ":[{"ุ":[{},[0,0,5]]}]}],"น":[{"ง":[{"ู":[{},[0,0,5]]}],"ฉ":[{"บ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"ท":[{"ะ":[{},[0,0,5]],"ุ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ร":[{"ุ":[{},[0,0,5]],"่":[{},[0,0,5]]}]}],"ม":[{"ค":[{"ล":[{},[0,0,5]]}],"ง":[{"ว":[{},[0,0,5]]}],"ฉ":[{"ุ":[{},[0,0,5]]}],"น":[{"้":[{},[0,0,5]]}],"ย":[{"ิ":[{},[0,0,5]]}],"ล":[{"ะ":[{},[0,0,5]],"ุ":[{},[0,0,5]]}],"อ":[{"ล":[{},[0,0,5]]}]}],"ย":[{"ก":[{"ล":[{},[0,0,5]]}],"ง":[{"ช":[{},[0,0,5]]}],"ล":[{"่":[{},[0,0,5]]}],"อ":[{"้":[{},[0,0,5]]}],"ใ":[{"บ":[{},[0,0,5]]}]}],"ว":[{"ร":[{"อ":[{},[0,0,5]]}]}],"ห":[{},[0,1]],"อ":[{"ก":[{"ร":[{},[0,0,5]],"ล":[{},[0,0,5]]}],"ค":[{"ร":[{},[0,0,5]],"ู":[{},[0,0,5]]}],"ง":[{"อ":[{},[0,0,5]]}],"ฉ":[{"ี":[{},[0,0,5]]}],"ด":[{"ึ":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ต":[{"๊":[{},[0,0,5]]}],"ถ":[{"อ":[{},[0,0,5]]}],"น":[{},[0,0,0,3]],"ผ":[{"้":[{},[0,0,5]]}],"ฝ":[{"ั":[{},[0,0,5]]}],"ฟ":[{"ื":[{},[0,0,5]]}],"ม":[{"ู":[{},[0,0,5]]}],"ร":[{"ะ":[{},[0,0,5]],"่":[{},[0,0,5]]}],"อ":[{"ึ":[{},[0,0,5]]}],"ฮ":[{"ื":[{},[0,0,5]]}]}],"า":[{"จ":[{"อ":[{},[0,0,5]]}],"ช":[{"ื":[{},[0,0,5]],"ู":[{},[0,0,5]],"่":[{},[0,0,5]],"้":[{},[0,0,5]]}],"ด":[{"ี":[{},[0,0,5]]}],"ถ":[{"ิ":[{},[0,0,5]],"ึ":[{},[0,0,5]]}],"บ":[{"่":[{},[0,0,5]],"้":[{},[0,0,5]],"๋":[{},[0,0,5]]}],"ป":[{"ี":[{},[0,0,5]]}],"ผ":[{"า":[{},[0,0,5]]}],"ฝ":[{"ร":[{},[0,0,5]]}],"พ":[{},[0,0,3]],"ม":[{"ุ":[{},[0,0,5]]}],"ว":[{"่":[{},[0,0,5]]}],"ส":[{"ม":[{},[0,0,5]],"ร":[{},[0,0,5]],"ล":[{},[0,0,5]]}]}],"ำ":[{},[0,0,1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"ล":[{"ำ":[{},[0,7]]}],"ป":[{"ด":[{".":[{},[0,7]]}]}]},[6]],"๊":[{"ก":[{"ซ":[{"อ":[{},[0,0,5]]}],"ร":[{"ิ":[{},[0,0,5]]}],"ล":[{"ุ":[{},[0,0,5]]}],"ฮ":[{"ว":[{},[0,0,5]]}]}],"ง":[{"บ":[{"๊":[{},[0,0,5]]}]}],"ป":[{"ซ":[{"ี":[{},[0,0,5]]}]}],"ย":[{"ก":[{"่":[{},[0,0,5]]}]}]},[6]],"๋":[{"ย":[{"อ":[{"ิ":[{},[0,0,5]]}]}],"อ":[{"ด":[{"๋":[{},[0,0,5]]}]}]},[6]],"์":[{"ค":[{"ส":[{"เ":[{},[0,0,5]]}],"แ":[{"ล":[{},[0,0,5]]}]}],"ต":[{"ไ":[{"ท":[{},[0,0,5]]}]}],"ท":[{"เ":[{},[0,4]],"ไ":[{"ท":[{},[0,0,5]]}]}],"น":[{},[0,1]],"บ":[{},[0,1]],"พ":[{},[0,1]],"ร":[{"า":[{},[0,7]]},[0,1]],"เ":[{},[0,1]],"แ":[{},[0,1]],"โ":[{},[0,1]],"ก":[{"ล":[{},[0,7]]}]},[6]],"ฃ":[{".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}]}],"ฅ":[{".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}]}],"ฌ":[{".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}]}],"ฎ":[{".":[{},[6]],"์":[{".":[{},[6]]}],"ิ":[{"์":[{".":[{},[6]]}]}],"ุ":[{"์":[{".":[{},[6]]}]}],"ก":[{},[7]]}],"ๅ":[{},[6]],"ํ":[{},[6]],"ฺ":[{},[6]],"๎":[{},[6]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
