"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _testhelpers = require("@tamanu/shared/test-helpers");
const _chance = require("../../chance");
const _insertEncounter = require("../insertEncounter");
const _default = {
    setup: [
        'examiners',
        'facilitiesDepartmentsAndLocations',
        'scheduledVaccines'
    ],
    run: async (store, setupData, patientId)=>{
        const { AdministeredVaccine } = store.models;
        const insertVaccination = async (scheduledVaccineId)=>{
            const encounter = await (0, _insertEncounter.insertEncounter)(store, setupData, patientId);
            await AdministeredVaccine.create({
                ...(0, _testhelpers.fake)(AdministeredVaccine),
                encounterId: encounter.id,
                scheduledVaccineId
            });
        };
        const doses = _chance.chance.integer({
            min: 0,
            max: 2
        });
        if (doses >= 1) {
            await insertVaccination(setupData.scheduledVaccines[0].id);
        }
        if (doses >= 2) {
            await insertVaccination(setupData.scheduledVaccines[1].id);
        }
    }
};

//# sourceMappingURL=administeredVaccines.js.map