"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "saveCertificateRequestCommand", {
    enumerable: true,
    get: function() {
        return saveCertificateRequestCommand;
    }
});
const _commander = require("commander");
const _fs = require("fs");
const _logging = require("@tamanu/shared/services/logging");
const _models = require("@tamanu/shared/models");
const _database = require("../database");
async function saveCertificateRequest({ output }) {
    _logging.log.info(`Writing certificate request to ${output}`);
    await (0, _database.initDatabase)({
        testMode: false
    });
    const pending = await _models.Signer.findPending();
    if (!pending) {
        throw new Error('No signers found with pending certificate requests');
    }
    await _fs.promises.writeFile(output, pending.request);
}
const saveCertificateRequestCommand = new _commander.Command('saveCertificateRequest').description('Fetches the latest certificate request without a matching certificate').requiredOption('-o, --output <file>', 'Output filepath').action(saveCertificateRequest);

//# sourceMappingURL=saveCertificateRequest.js.map