"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "globalDefaults", {
    enumerable: true,
    get: function() {
        return globalDefaults;
    }
});
const _constants = require("@tamanu/constants");
const globalDefaults = {
    customisations: {
        componentVersions: {}
    },
    fhir: {
        worker: {
            heartbeat: '1 minute',
            assumeDroppedAfter: '10 minutes'
        }
    },
    integrations: {
        imaging: {
            enabled: false
        }
    },
    upcomingVaccinations: {
        ageLimit: 15,
        thresholds: [
            {
                threshold: 28,
                status: _constants.VACCINE_STATUS.SCHEDULED
            },
            {
                threshold: 7,
                status: _constants.VACCINE_STATUS.UPCOMING
            },
            {
                threshold: -7,
                status: _constants.VACCINE_STATUS.DUE
            },
            {
                threshold: -55,
                status: _constants.VACCINE_STATUS.OVERDUE
            },
            {
                threshold: '-Infinity',
                status: _constants.VACCINE_STATUS.MISSED
            }
        ]
    },
    features: {
        mandateSpecimenType: false
    }
};

//# sourceMappingURL=global.js.map