"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.sequelize.query(`
    ALTER TABLE lab_test_panel_lab_test_types DROP CONSTRAINT lab_test_panel_lab_test_types_pkey;
    ALTER TABLE lab_test_panel_lab_test_types ADD PRIMARY KEY (lab_test_panel_id, lab_test_type_id);
  `);
    await query.removeColumn('lab_test_panel_lab_test_types', 'id');
    await query.addColumn('lab_test_panel_lab_test_types', 'id', {
        type: _sequelize.default.TEXT
    });
    await query.sequelize.query(`UPDATE lab_test_panel_lab_test_types SET id = CONCAT(lab_test_panel_id, ';', lab_test_type_id)`);
}
async function down(query) {
    await query.removeColumn('lab_test_panel_lab_test_types', 'id');
    await query.addColumn('lab_test_panel_lab_test_types', 'id', {
        type: _sequelize.default.TEXT,
        allowNull: false,
        defaultValue: _sequelize.default.fn('uuid_generate_v4')
    });
    await query.sequelize.query(`
    ALTER TABLE lab_test_panel_lab_test_types DROP CONSTRAINT lab_test_panel_lab_test_types_pkey;
    ALTER TABLE lab_test_panel_lab_test_types ADD PRIMARY KEY (id);
  `);
}

//# sourceMappingURL=1680147932505-useGeneratedIdForPanelRelations.js.map