"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceLineType", {
    enumerable: true,
    get: function() {
        return InvoiceLineType;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let InvoiceLineType = class InvoiceLineType extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            itemId: _sequelize.Sequelize.STRING,
            itemType: _sequelize.Sequelize.STRING,
            name: _sequelize.Sequelize.TEXT,
            price: _sequelize.Sequelize.DECIMAL
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'itemId',
            as: 'procedureType',
            constraints: false
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'itemId',
            as: 'labTestType',
            constraints: false
        });
    }
    static getFullLinkedItemsInclude(models) {
        return [
            {
                model: models.ReferenceData,
                on: {
                    itemId: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoiceLineType->procedureType.id'), '=', _sequelize.Sequelize.col('invoiceLineType.item_id')),
                    itemType: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoiceLineType->procedureType.type'), '=', 'procedureType')
                },
                as: 'procedureType'
            },
            {
                model: models.LabTestType,
                on: {
                    itemId: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoiceLineType->labTestType.id'), '=', _sequelize.Sequelize.col('invoiceLineType.item_id')),
                    itemType: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoiceLineType.item_type'), '=', 'labTestType')
                },
                as: 'labTestType'
            }
        ];
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=InvoiceLineType.js.map