"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabRequestAttachment", {
    enumerable: true,
    get: function() {
        return LabRequestAttachment;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sequelize = require("sequelize");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let LabRequestAttachment = class LabRequestAttachment extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            // Relation can't be managed by sequelize because the
            // attachment won't get downloaded to facility server
            attachmentId: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            title: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            replacedById: {
                type: _sequelize.Sequelize.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
    }
    static buildPatientSyncFilter(patientIds, markedForSyncPatientsTable, sessionConfig) {
        if (sessionConfig.syncAllLabRequests) {
            return ''; // include all lab request attachments
        }
        if (patientIds.length === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id',
                isLabRequestValue: 'TRUE'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'lab_requests',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=LabRequestAttachment.js.map