"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientProgramRegistrationCondition", {
    enumerable: true,
    get: function() {
        return PatientProgramRegistrationCondition;
    }
});
const _constants = require("@tamanu/constants");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _Model = require("./Model");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientProgramRegistrationCondition = class PatientProgramRegistrationCondition extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _dateTimeTypes.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            deletionDate: (0, _dateTimeTypes.dateTimeType)('deletionDate', {
                defaultValue: null
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        // Note that we use a kind of composite foreign key here (patientId + programRegistryId)
        // rather than just a single patientProgramRegistrationId. This is because
        // PatientProgramRegistrion is an append-only array rather than a single record,
        // so the relevant id changes every time a change is made to the relevant registration.
        this.belongsTo(models.Patient, {
            foreignKey: {
                name: 'patientId',
                allowNull: false
            },
            as: 'patient'
        });
        this.belongsTo(models.ProgramRegistry, {
            foreignKey: {
                name: 'programRegistryId',
                allowNull: false
            },
            as: 'programRegistry'
        });
        this.belongsTo(models.ProgramRegistryCondition, {
            foreignKey: 'programRegistryConditionId',
            as: 'programRegistryCondition'
        });
        this.belongsTo(models.User, {
            foreignKey: 'clinicianId',
            as: 'clinician'
        });
        this.belongsTo(models.User, {
            foreignKey: 'deletionClinicianId',
            as: 'deletionClinician'
        });
    }
    static getFullReferenceAssociations() {
        return [
            'programRegistryCondition'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return `WHERE patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}) AND updated_at_sync_tick > :since`;
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=PatientProgramRegistrationCondition.js.map