"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "RefreshToken", {
    enumerable: true,
    get: function() {
        return RefreshToken;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let RefreshToken = class RefreshToken extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            refreshId: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            deviceId: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            expiresAt: {
                type: _sequelize.Sequelize.DATE,
                allowNull: false
            }
        }, {
            indexes: [
                {
                    name: 'refresh_tokens_user_id_device_id',
                    fields: [
                        'user_id',
                        'device_id'
                    ],
                    unique: true
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            ...options
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId'
        });
    }
};

//# sourceMappingURL=RefreshToken.js.map