"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildEncounterLinkedJoin: function() {
        return buildEncounterLinkedJoin;
    },
    buildEncounterLinkedSyncFilter: function() {
        return buildEncounterLinkedSyncFilter;
    },
    buildEncounterLinkedSyncFilterJoins: function() {
        return buildEncounterLinkedSyncFilterJoins;
    }
});
const _sequelize = require("sequelize");
function buildEncounterLinkedSyncFilterJoins(tablesToTraverse) {
    return tablesToTraverse.slice(1).map((table, i)=>`
      LEFT JOIN ${table} ON ${tablesToTraverse[i]}.${_sequelize.Utils.singularize(table)}_id = ${table}.id
    `).join('\n');
}
function buildEncounterLinkedSyncFilter(tablesToTraverse, markedForSyncPatientsTable) {
    const joins = buildEncounterLinkedSyncFilterJoins(tablesToTraverse);
    return `
    ${joins}
    WHERE encounters.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable})
    AND ${tablesToTraverse[0]}.updated_at_sync_tick > :since
  `;
}
function buildEncounterLinkedJoin() {
    return `
    JOIN
      encounters
    ON
      encounter_id = encounters.id
  `;
}

//# sourceMappingURL=buildEncounterLinkedSyncFilter.js.map