"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirImmunization", {
    enumerable: true,
    get: function() {
        return FhirImmunization;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
let FhirImmunization = class FhirImmunization extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            status: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            vaccineCode: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            patient: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            encounter: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: true
            },
            occurrenceDateTime: _sequelize.Sequelize.TEXT,
            lotNumber: _sequelize.Sequelize.TEXT,
            site: _sequelize.DataTypes.JSONB,
            performer: _sequelize.DataTypes.JSONB,
            protocolApplied: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.AdministeredVaccine
        ];
        this.upstreams = [
            models.AdministeredVaccine,
            models.Encounter,
            models.Patient,
            models.ReferenceData,
            models.ScheduledVaccine,
            models.User
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { AdministeredVaccine } = this.sequelize.models;
        if (upstreamTable === AdministeredVaccine.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromAdministeredVaccines)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirImmunization.js.map