"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceDetails", {
    enumerable: true,
    get: function() {
        return InvoiceDetails;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _constants = require("@tamanu/constants");
const _DataSection = require("./DataSection");
const _DataItem = require("./DataItem");
const _Layout = require("../Layout");
const _dateTime = require("../../dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const InvoiceDetails = ({ encounter, invoice })=>{
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: "Invoice details",
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date",
        value: (0, _dateTime.formatShort)(invoice.date)
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Invoice status",
        value: _constants.INVOICE_STATUS_LABELS[invoice.status]
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Admission",
        value: _constants.ENCOUNTER_LABELS[encounter?.encounterType]
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Payment status",
        value: invoice.status === _constants.INVOICE_STATUSES.FINALISED ? _constants.INVOICE_PATIENT_PAYMENT_STATUSES_LABELS[invoice.patientPaymentStatus] + (invoice.insurerPaymentStatus === _constants.INVOICE_INSURER_PAYMENT_STATUSES.REJECTED ? `/${_constants.INVOICE_INSURER_PAYMENT_STATUS_LABELS[invoice.insurerPaymentStatus]}` : '') : 'n/a'
    }))));
};

//# sourceMappingURL=InvoiceDetails.js.map