"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    NOTE_PERMISSION_TYPES: function() {
        return NOTE_PERMISSION_TYPES;
    },
    NOTE_RECORD_TYPES: function() {
        return NOTE_RECORD_TYPES;
    },
    NOTE_RECORD_TYPE_VALUES: function() {
        return NOTE_RECORD_TYPE_VALUES;
    },
    NOTE_TYPES: function() {
        return NOTE_TYPES;
    },
    NOTE_TYPE_LABELS: function() {
        return NOTE_TYPE_LABELS;
    },
    NOTE_TYPE_VALUES: function() {
        return NOTE_TYPE_VALUES;
    }
});
const NOTE_RECORD_TYPES = {
    ENCOUNTER: 'Encounter',
    PATIENT: 'Patient',
    TRIAGE: 'Triage',
    PATIENT_CARE_PLAN: 'PatientCarePlan',
    LAB_REQUEST: 'LabRequest',
    IMAGING_REQUEST: 'ImagingRequest'
};
const NOTE_TYPES = {
    TREATMENT_PLAN: 'treatmentPlan',
    ADMISSION: 'admission',
    MEDICAL: 'medical',
    SURGICAL: 'surgical',
    NURSING: 'nursing',
    DIETARY: 'dietary',
    PHARMACY: 'pharmacy',
    PHYSIOTHERAPY: 'physiotherapy',
    SOCIAL: 'social',
    DISCHARGE: 'discharge',
    AREA_TO_BE_IMAGED: 'areaToBeImaged',
    RESULT_DESCRIPTION: 'resultDescription',
    SYSTEM: 'system',
    OTHER: 'other',
    CLINICAL_MOBILE: 'clinicalMobile',
    HANDOVER: 'handover'
};
const NOTE_TYPE_LABELS = {
    [NOTE_TYPES.TREATMENT_PLAN]: 'Treatment plan',
    [NOTE_TYPES.ADMISSION]: 'Admission',
    [NOTE_TYPES.CLINICAL_MOBILE]: 'Clinical note (mobile)',
    [NOTE_TYPES.DIETARY]: 'Dietary',
    [NOTE_TYPES.DISCHARGE]: 'Discharge planning',
    [NOTE_TYPES.HANDOVER]: 'Handover note',
    [NOTE_TYPES.MEDICAL]: 'Medical',
    [NOTE_TYPES.NURSING]: 'Nursing',
    [NOTE_TYPES.OTHER]: 'Other',
    [NOTE_TYPES.PHARMACY]: 'Pharmacy',
    [NOTE_TYPES.PHYSIOTHERAPY]: 'Physiotherapy',
    [NOTE_TYPES.SOCIAL]: 'Social welfare',
    [NOTE_TYPES.SURGICAL]: 'Surgical',
    [NOTE_TYPES.SYSTEM]: 'System'
};
const NOTE_PERMISSION_TYPES = {
    OTHER_PRACTITIONER_ENCOUNTER_NOTE: 'OtherPractitionerEncounterNote',
    TREATMENT_PLAN_NOTE: 'TreatmentPlanNote'
};
const NOTE_RECORD_TYPE_VALUES = Object.values(NOTE_RECORD_TYPES);
const NOTE_TYPE_VALUES = Object.values(NOTE_TYPES);

//# sourceMappingURL=notes.js.map