"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ApplicationContext", {
    enumerable: true,
    get: function() {
        return ApplicationContext;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _lodash = require("lodash");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("./database");
const _versionCompatibility = require("./middleware/versionCompatibility.js");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let ApplicationContext = class ApplicationContext {
    async init({ appType } = {}) {
        if (_config.default.errors?.enabled) {
            if (_config.default.errors.type === 'bugsnag') {
                await (0, _logging.initBugsnag)({
                    ...(0, _lodash.omit)(_config.default.errors, [
                        'enabled',
                        'type'
                    ]),
                    appVersion: _versionCompatibility.VERSION,
                    appType
                });
            }
        }
        const database = await (0, _database.initDatabase)();
        this.sequelize = database.sequelize;
        this.models = database.models;
        if (_config.default.db.reportSchemas?.enabled) {
            this.reportSchemaStores = await (0, _database.initReporting)();
        }
        return this;
    }
    onClose(hook) {
        this.closeHooks.push(hook);
    }
    async close() {
        for (const hook of this.closeHooks){
            await hook();
        }
        await (0, _database.closeDatabase)();
    }
    constructor(){
        /** @type {import('sequelize').Sequelize | null} */ _define_property(this, "sequelize", null);
        /** @type {import('@tamanu/shared/models') | null} */ _define_property(this, "models", null);
        _define_property(this, "reportSchemaStores", null);
        _define_property(this, "closeHooks", []);
    }
};

//# sourceMappingURL=ApplicationContext.js.map