"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createApiApp", {
    enumerable: true,
    get: function() {
        return createApiApp;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _middleware = require("@tamanu/settings/middleware");
const _auditLog = require("./middleware/auditLog");
const _routes = /*#__PURE__*/ _interop_require_default(require("./routes"));
const _errorHandler = /*#__PURE__*/ _interop_require_default(require("./middleware/errorHandler"));
const _versionCompatibility = require("./middleware/versionCompatibility");
const _http = require("http");
const _websocketService = require("./services/websocketService");
const _websocketClientService = require("./services/websocketClientService");
const _addFacilityMiddleware = require("./addFacilityMiddleware");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function createApiApp({ sequelize, reportSchemaStores, models, syncConnection, deviceId }) {
    const express = (0, _express.default)();
    const server = (0, _http.createServer)(express);
    const pg = await sequelize.connectionManager.getConnection();
    const websocketService = (0, _websocketService.defineWebsocketService)({
        httpServer: server,
        pg
    });
    const websocketClientService = (0, _websocketClientService.defineWebsocketClientService)({
        config: _config.default,
        websocketService,
        models
    });
    const { errorMiddleware } = (0, _addFacilityMiddleware.addFacilityMiddleware)(express);
    // Release the connection back to the pool when the server is closed
    server.on('close', ()=>sequelize.connectionManager.releaseConnection(pg));
    express.use((req, res, next)=>{
        req.models = models;
        req.db = sequelize;
        req.reportSchemaStores = reportSchemaStores;
        req.syncConnection = syncConnection;
        req.deviceId = deviceId;
        req.language = req.headers['language'];
        req.websocketService = websocketService;
        req.websocketClientService = websocketClientService;
        next();
    });
    express.use((0, _middleware.buildSettingsReaderMiddleware)(_config.default.serverFacilityId));
    express.use(_versionCompatibility.versionCompatibility);
    express.use((0, _auditLog.getAuditMiddleware)());
    // index route for debugging connectivity
    express.get('/$', (req, res)=>{
        res.send({
            index: true
        });
    });
    express.use('/', _routes.default);
    // Dis-allow all other routes
    express.get('*', (req, res)=>{
        res.status(404).end();
    });
    if (errorMiddleware) {
        express.use(errorMiddleware);
    }
    express.use(_errorHandler.default);
    return {
        express,
        server
    };
}

//# sourceMappingURL=createApiApp.js.map