"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "appointments", {
    enumerable: true,
    get: function() {
        return appointments;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _datefns = require("date-fns");
const _sequelize = require("sequelize");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _query = require("../../utils/query");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const appointments = _express.default.Router();
appointments.post('/$', (0, _crudHelpers.simplePost)('Appointment'));
const searchableFields = [
    'startTime',
    'endTime',
    'type',
    'status',
    'clinicianId',
    'locationId',
    'locationGroupId',
    'patient.first_name',
    'patient.last_name',
    'patient.display_id'
];
const sortKeys = {
    patientName: _sequelize.Sequelize.fn('concat', _sequelize.Sequelize.col('patient.first_name'), ' ', _sequelize.Sequelize.col('patient.last_name')),
    displayId: _sequelize.Sequelize.col('patient.display_id'),
    sex: _sequelize.Sequelize.col('patient.sex'),
    dateOfBirth: _sequelize.Sequelize.col('patient.date_of_birth'),
    location: _sequelize.Sequelize.col('location.name'),
    locationGroup: _sequelize.Sequelize.col('location_groups.name'),
    clinician: _sequelize.Sequelize.col('clinician.display_name')
};
appointments.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Appointment');
    const { models, query: { after, before, rowsPerPage = 10, page = 0, all = false, order = 'ASC', orderBy = 'startTime', ...queries } } = req;
    const { Appointment } = models;
    const afterTime = after || (0, _datefns.startOfDay)(new Date());
    const startTimeQuery = {
        [_sequelize.Op.gte]: afterTime
    };
    if (before) {
        startTimeQuery[_sequelize.Op.lte] = before;
    }
    const filters = Object.entries(queries).reduce((_filters, [queryField, queryValue])=>{
        if (!searchableFields.includes(queryField)) {
            return _filters;
        }
        if (!(typeof queryValue === 'string')) {
            return _filters;
        }
        let column = queryField;
        // querying on a joined table (associations)
        if (queryField.includes('.')) {
            column = `$${queryField}$`;
        }
        return {
            ..._filters,
            [column]: {
                [_sequelize.Op.iLike]: `%${(0, _query.escapePatternWildcard)(queryValue)}%`
            }
        };
    }, {});
    const { rows, count } = await Appointment.findAndCountAll({
        limit: all ? undefined : rowsPerPage,
        offset: all ? undefined : page * rowsPerPage,
        order: [
            [
                sortKeys[orderBy] || orderBy,
                order
            ]
        ],
        where: {
            startTime: startTimeQuery,
            ...filters
        },
        include: [
            ...Appointment.getListReferenceAssociations()
        ]
    });
    // Backwards compatibility for appointments created before locationHierarchy was implemented
    const backwardsCompatibleRows = rows.map((data)=>{
        const { location, locationGroup, ...rest } = data.get({
            plain: true
        });
        return {
            ...rest,
            locationGroup: locationGroup || location
        };
    });
    res.send({
        count,
        data: backwardsCompatibleRows
    });
}));
appointments.put('/:id', (0, _crudHelpers.simplePut)('Appointment'));

//# sourceMappingURL=appointments.js.map