"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    shell: function() {
        return shell;
    },
    shellCommand: function() {
        return shellCommand;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _repl = /*#__PURE__*/ _interop_require_default(require("repl"));
const _os = require("os");
const _path = require("path");
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _serverInfo = require("../serverInfo");
const _ApplicationContext = require("../ApplicationContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const shell = async ({ skipMigrationCheck })=>{
    _logging.log.info(`Starting shell in Facility Server ${_serverInfo.version} ${_config.default.serverFacilityId}`);
    const context = await new _ApplicationContext.ApplicationContext().init();
    await context.sequelize.assertUpToDate({
        skipMigrationCheck
    });
    const replServer = await new Promise((resolve, reject)=>{
        _repl.default.start().setupHistory((0, _path.join)((0, _os.homedir)(), '.tamanu_repl_history'), (err, srv)=>{
            if (err) reject(err);
            else resolve(srv);
        });
    });
    Object.assign(replServer.context, {
        context,
        models: context.models
    });
    return new Promise((resolve)=>{
        replServer.on('exit', ()=>resolve());
    });
};
const shellCommand = new _commander.Command('shell').description('Start a Node.js shell').action(shell);

//# sourceMappingURL=shell.js.map