"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncTask", {
    enumerable: true,
    get: function() {
        return SyncTask;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let SyncTask = class SyncTask extends _tasks.ScheduledTask {
    getName() {
        return 'SyncTask';
    }
    async run() {
        return this.context.syncManager.triggerSync({
            type: 'scheduled',
            urgent: false
        });
    }
    constructor(context){
        const { schedule, jitterTime, enabled } = _config.default.sync;
        super(schedule, _logging.log, jitterTime, enabled);
        _define_property(this, "context", null);
        this.context = context;
        this.runImmediately();
    }
};

//# sourceMappingURL=SyncTask.js.map