"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createLabTestTypes: function() {
        return createLabTestTypes;
    },
    randomLabRequest: function() {
        return randomLabRequest;
    }
});
const _patients = require("./patients");
const _fake = require("../test-helpers/fake");
const randomLabRequest = async (models, overrides)=>{
    const categoryId = overrides?.categoryId || await (0, _patients.randomReferenceId)(models, 'labTestCategory');
    const labTestTypes = await createLabTestTypes(models, categoryId);
    return {
        categoryId,
        labTestTypeIds: labTestTypes.map((t)=>t.id),
        displayId: 'TESTID',
        ...overrides
    };
};
const createLabTestTypes = async (models, categoryId)=>{
    const labTestCategoryId = categoryId || await (0, _patients.randomReferenceId)(models, 'labTestCategory');
    const { LabTestType } = models;
    const labTestTypes = Array(2).fill().map(()=>({
            ...(0, _fake.fake)(LabTestType),
            labTestCategoryId
        }));
    const createdLabTestTypes = await Promise.all(labTestTypes.map((t)=>LabTestType.create(t)));
    return createdLabTestTypes;
};

//# sourceMappingURL=labRequests.js.map