"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CertificateNotification", {
    enumerable: true,
    get: function() {
        return CertificateNotification;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
let CertificateNotification = class CertificateNotification extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            createdBy: _sequelize.Sequelize.STRING,
            type: _sequelize.Sequelize.STRING,
            facilityName: _sequelize.Sequelize.STRING,
            forwardAddress: _sequelize.Sequelize.STRING,
            requireSigning: _sequelize.Sequelize.BOOLEAN,
            status: _sequelize.Sequelize.STRING,
            error: _sequelize.Sequelize.TEXT,
            language: _sequelize.Sequelize.STRING,
            printedDate: (0, _dateTimeTypes.dateType)('printedDate')
        }, {
            ...options,
            // Note that if this changes to bidirectional, the SendCertificateNotification task
            // will need to be updated / limited to handle only new publishes!
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        // For test certificates only
        this.belongsTo(models.LabTest, {
            foreignKey: 'labTestId',
            as: 'labTest'
        });
        // For automated emails
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
    }
};

//# sourceMappingURL=CertificateNotification.js.map