"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Discharge", {
    enumerable: true,
    get: function() {
        return Discharge;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("../errors");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let Discharge = class Discharge extends _Model.Model {
    static init({ primaryKey, ...options }) {
        const validate = {
            mustHaveEncounter () {
                if (!this.deletedAt && !this.encounterId) {
                    throw new _errors.InvalidOperationError('A discharge must have an encounter.');
                }
            }
        };
        super.init({
            id: primaryKey,
            note: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: true
            },
            facilityName: {
                type: _sequelize.Sequelize.STRING,
                allowNull: true
            },
            facilityAddress: {
                type: _sequelize.Sequelize.STRING,
                allowNull: true
            },
            facilityTown: {
                type: _sequelize.Sequelize.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate
        });
    }
    static getFullReferenceAssociations() {
        return [
            'discharger',
            'disposition'
        ];
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.User, {
            foreignKey: 'dischargerId',
            as: 'discharger'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'dispositionId',
            as: 'disposition'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=Discharge.js.map