"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePriceChangeItem", {
    enumerable: true,
    get: function() {
        return InvoicePriceChangeItem;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let InvoicePriceChangeItem = class InvoicePriceChangeItem extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            description: _sequelize.Sequelize.STRING,
            percentageChange: _sequelize.Sequelize.STRING,
            date: (0, _dateTimeTypes.dateType)('date'),
            status: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                defaultValue: _constants.INVOICE_PRICE_CHANGE_ITEM_STATUSES.ACTIVE
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.belongsTo(models.InvoicePriceChangeType, {
            foreignKey: 'invoicePriceChangeTypeId',
            as: 'invoicePriceChangeType'
        });
        this.belongsTo(models.User, {
            foreignKey: 'orderedById',
            as: 'orderedBy'
        });
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.InvoicePriceChangeType,
                as: 'invoicePriceChangeType',
                include: models.InvoicePriceChangeType.getFullLinkedItemsInclude(models)
            },
            {
                model: models.User,
                as: 'orderedBy'
            }
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildPatientLinkedLookupFilter.buildEncounterPatientIdSelect)(this),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoicePriceChangeItem.js.map