"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LocationGroup", {
    enumerable: true,
    get: function() {
        return LocationGroup;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("../errors");
const _Model = require("./Model");
let LocationGroup = class LocationGroup extends _Model.Model {
    static init({ primaryKey, ...options }) {
        const validate = {
            mustHaveFacility () {
                if (!this.deletedAt && !this.facilityId) {
                    throw new _errors.InvalidOperationError('A location group must have a facility.');
                }
            },
            mustNotIncludeComma () {
                if (this.name.includes(',')) {
                    throw new _errors.InvalidOperationError('A location group name cannot include a comma.');
                }
            }
        };
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            validate,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
        this.hasMany(models.Location, {
            foreignKey: 'locationGroupId'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=LocationGroup.js.map