"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Template", {
    enumerable: true,
    get: function() {
        return Template;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
let Template = class Template extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            dateCreated: (0, _dateTimeTypes.dateType)('dateCreated', {
                defaultValue: _dateTime.getCurrentDateString
            }),
            title: {
                type: _sequelize.Sequelize.TEXT
            },
            body: {
                type: _sequelize.Sequelize.TEXT
            },
            type: {
                type: _sequelize.Sequelize.ENUM(Object.values(_constants.TEMPLATE_TYPES)),
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'createdById',
            as: 'createdBy'
        });
    }
    static getListReferenceAssociations() {
        return [
            'createdBy'
        ];
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Template.js.map