"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserPreference", {
    enumerable: true,
    get: function() {
        return UserPreference;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let UserPreference = class UserPreference extends _Model.Model {
    static init(options) {
        super.init({
            id: {
                // User preference records use a user_id as the primary key, acting as a
                // db-level enforcement of one per user, and simplifying sync
                type: `TEXT GENERATED ALWAYS AS ("user_id")`,
                set () {
                // any sets of the convenience generated "id" field can be ignored, so do nothing here
                }
            },
            selectedGraphedVitalsOnFilter: _sequelize.Sequelize.STRING,
            userId: {
                type: _sequelize.DataTypes.STRING,
                primaryKey: true,
                references: {
                    model: 'users',
                    key: 'id'
                }
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static buildSyncFilter() {
        return null;
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=UserPreference.js.map